/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.UpdatePlanTraitTraitRequestBody;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdatePlanTraitBulkRequestBody {
    private final String planId;
    private final List<UpdatePlanTraitTraitRequestBody> traits;
    private final Map<String, Object> additionalProperties;

    private UpdatePlanTraitBulkRequestBody(String planId, List<UpdatePlanTraitTraitRequestBody> traits, Map<String, Object> additionalProperties) {
        this.planId = planId;
        this.traits = traits;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="plan_id")
    public String getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="traits")
    public List<UpdatePlanTraitTraitRequestBody> getTraits() {
        return this.traits;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdatePlanTraitBulkRequestBody && this.equalTo((UpdatePlanTraitBulkRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdatePlanTraitBulkRequestBody other) {
        return this.planId.equals(other.planId) && this.traits.equals(other.traits);
    }

    public int hashCode() {
        return Objects.hash(this.planId, this.traits);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PlanIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PlanIdStage,
    _FinalStage {
        private String planId;
        private List<UpdatePlanTraitTraitRequestBody> traits = new ArrayList<UpdatePlanTraitTraitRequestBody>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdatePlanTraitBulkRequestBody other) {
            this.planId(other.getPlanId());
            this.traits(other.getTraits());
            return this;
        }

        @Override
        @JsonSetter(value="plan_id")
        public _FinalStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllTraits(List<UpdatePlanTraitTraitRequestBody> traits) {
            if (traits != null) {
                this.traits.addAll(traits);
            }
            return this;
        }

        @Override
        public _FinalStage addTraits(UpdatePlanTraitTraitRequestBody traits) {
            this.traits.add(traits);
            return this;
        }

        @Override
        @JsonSetter(value="traits", nulls=Nulls.SKIP)
        public _FinalStage traits(List<UpdatePlanTraitTraitRequestBody> traits) {
            this.traits.clear();
            if (traits != null) {
                this.traits.addAll(traits);
            }
            return this;
        }

        @Override
        public UpdatePlanTraitBulkRequestBody build() {
            return new UpdatePlanTraitBulkRequestBody(this.planId, this.traits, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdatePlanTraitBulkRequestBody build();

        public _FinalStage traits(List<UpdatePlanTraitTraitRequestBody> var1);

        public _FinalStage addTraits(UpdatePlanTraitTraitRequestBody var1);

        public _FinalStage addAllTraits(List<UpdatePlanTraitTraitRequestBody> var1);
    }

    public static interface PlanIdStage {
        public _FinalStage planId(@NotNull String var1);

        public Builder from(UpdatePlanTraitBulkRequestBody var1);
    }
}

