/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdatePlanTraitRequestBody {
    private final String planId;
    private final String traitValue;
    private final Map<String, Object> additionalProperties;

    private UpdatePlanTraitRequestBody(String planId, String traitValue, Map<String, Object> additionalProperties) {
        this.planId = planId;
        this.traitValue = traitValue;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="plan_id")
    public String getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="trait_value")
    public String getTraitValue() {
        return this.traitValue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdatePlanTraitRequestBody && this.equalTo((UpdatePlanTraitRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdatePlanTraitRequestBody other) {
        return this.planId.equals(other.planId) && this.traitValue.equals(other.traitValue);
    }

    public int hashCode() {
        return Objects.hash(this.planId, this.traitValue);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PlanIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PlanIdStage,
    TraitValueStage,
    _FinalStage {
        private String planId;
        private String traitValue;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdatePlanTraitRequestBody other) {
            this.planId(other.getPlanId());
            this.traitValue(other.getTraitValue());
            return this;
        }

        @Override
        @JsonSetter(value="plan_id")
        public TraitValueStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="trait_value")
        public _FinalStage traitValue(@NotNull String traitValue) {
            this.traitValue = Objects.requireNonNull(traitValue, "traitValue must not be null");
            return this;
        }

        @Override
        public UpdatePlanTraitRequestBody build() {
            return new UpdatePlanTraitRequestBody(this.planId, this.traitValue, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdatePlanTraitRequestBody build();
    }

    public static interface TraitValueStage {
        public _FinalStage traitValue(@NotNull String var1);
    }

    public static interface PlanIdStage {
        public TraitValueStage planId(@NotNull String var1);

        public Builder from(UpdatePlanTraitRequestBody var1);
    }
}

