/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.companies.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CountPlanTraitsParams {
    private final Optional<List<String>> ids;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Optional<String> planId;
    private final Optional<String> traitId;
    private final Optional<List<String>> traitIds;
    private final Map<String, Object> additionalProperties;

    private CountPlanTraitsParams(Optional<List<String>> ids, Optional<Integer> limit, Optional<Integer> offset, Optional<String> planId, Optional<String> traitId, Optional<List<String>> traitIds, Map<String, Object> additionalProperties) {
        this.ids = ids;
        this.limit = limit;
        this.offset = offset;
        this.planId = planId;
        this.traitId = traitId;
        this.traitIds = traitIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ids")
    public Optional<List<String>> getIds() {
        return this.ids;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    @JsonProperty(value="plan_id")
    public Optional<String> getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="trait_id")
    public Optional<String> getTraitId() {
        return this.traitId;
    }

    @JsonProperty(value="trait_ids")
    public Optional<List<String>> getTraitIds() {
        return this.traitIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CountPlanTraitsParams && this.equalTo((CountPlanTraitsParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CountPlanTraitsParams other) {
        return this.ids.equals(other.ids) && this.limit.equals(other.limit) && this.offset.equals(other.offset) && this.planId.equals(other.planId) && this.traitId.equals(other.traitId) && this.traitIds.equals(other.traitIds);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.limit, this.offset, this.planId, this.traitId, this.traitIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> ids = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        private Optional<String> planId = Optional.empty();
        private Optional<String> traitId = Optional.empty();
        private Optional<List<String>> traitIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CountPlanTraitsParams other) {
            this.ids(other.getIds());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            this.planId(other.getPlanId());
            this.traitId(other.getTraitId());
            this.traitIds(other.getTraitIds());
            return this;
        }

        @JsonSetter(value="ids", nulls=Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value="plan_id", nulls=Nulls.SKIP)
        public Builder planId(Optional<String> planId) {
            this.planId = planId;
            return this;
        }

        public Builder planId(String planId) {
            this.planId = Optional.ofNullable(planId);
            return this;
        }

        @JsonSetter(value="trait_id", nulls=Nulls.SKIP)
        public Builder traitId(Optional<String> traitId) {
            this.traitId = traitId;
            return this;
        }

        public Builder traitId(String traitId) {
            this.traitId = Optional.ofNullable(traitId);
            return this;
        }

        @JsonSetter(value="trait_ids", nulls=Nulls.SKIP)
        public Builder traitIds(Optional<List<String>> traitIds) {
            this.traitIds = traitIds;
            return this;
        }

        public Builder traitIds(List<String> traitIds) {
            this.traitIds = Optional.ofNullable(traitIds);
            return this;
        }

        public CountPlanTraitsParams build() {
            return new CountPlanTraitsParams(this.ids, this.limit, this.offset, this.planId, this.traitId, this.traitIds, this.additionalProperties);
        }
    }
}

