/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.companies.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListCompaniesParams {
    private final Optional<List<String>> ids;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Optional<String> planId;
    private final Optional<String> q;
    private final Optional<Boolean> withSubscription;
    private final Optional<String> withoutFeatureOverrideFor;
    private final Optional<Boolean> withoutPlan;
    private final Map<String, Object> additionalProperties;

    private ListCompaniesParams(Optional<List<String>> ids, Optional<Integer> limit, Optional<Integer> offset, Optional<String> planId, Optional<String> q, Optional<Boolean> withSubscription, Optional<String> withoutFeatureOverrideFor, Optional<Boolean> withoutPlan, Map<String, Object> additionalProperties) {
        this.ids = ids;
        this.limit = limit;
        this.offset = offset;
        this.planId = planId;
        this.q = q;
        this.withSubscription = withSubscription;
        this.withoutFeatureOverrideFor = withoutFeatureOverrideFor;
        this.withoutPlan = withoutPlan;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ids")
    public Optional<List<String>> getIds() {
        return this.ids;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    @JsonProperty(value="plan_id")
    public Optional<String> getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="q")
    public Optional<String> getQ() {
        return this.q;
    }

    @JsonProperty(value="with_subscription")
    public Optional<Boolean> getWithSubscription() {
        return this.withSubscription;
    }

    @JsonProperty(value="without_feature_override_for")
    public Optional<String> getWithoutFeatureOverrideFor() {
        return this.withoutFeatureOverrideFor;
    }

    @JsonProperty(value="without_plan")
    public Optional<Boolean> getWithoutPlan() {
        return this.withoutPlan;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListCompaniesParams && this.equalTo((ListCompaniesParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCompaniesParams other) {
        return this.ids.equals(other.ids) && this.limit.equals(other.limit) && this.offset.equals(other.offset) && this.planId.equals(other.planId) && this.q.equals(other.q) && this.withSubscription.equals(other.withSubscription) && this.withoutFeatureOverrideFor.equals(other.withoutFeatureOverrideFor) && this.withoutPlan.equals(other.withoutPlan);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.limit, this.offset, this.planId, this.q, this.withSubscription, this.withoutFeatureOverrideFor, this.withoutPlan);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> ids = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        private Optional<String> planId = Optional.empty();
        private Optional<String> q = Optional.empty();
        private Optional<Boolean> withSubscription = Optional.empty();
        private Optional<String> withoutFeatureOverrideFor = Optional.empty();
        private Optional<Boolean> withoutPlan = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListCompaniesParams other) {
            this.ids(other.getIds());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            this.planId(other.getPlanId());
            this.q(other.getQ());
            this.withSubscription(other.getWithSubscription());
            this.withoutFeatureOverrideFor(other.getWithoutFeatureOverrideFor());
            this.withoutPlan(other.getWithoutPlan());
            return this;
        }

        @JsonSetter(value="ids", nulls=Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value="plan_id", nulls=Nulls.SKIP)
        public Builder planId(Optional<String> planId) {
            this.planId = planId;
            return this;
        }

        public Builder planId(String planId) {
            this.planId = Optional.ofNullable(planId);
            return this;
        }

        @JsonSetter(value="q", nulls=Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @JsonSetter(value="with_subscription", nulls=Nulls.SKIP)
        public Builder withSubscription(Optional<Boolean> withSubscription) {
            this.withSubscription = withSubscription;
            return this;
        }

        public Builder withSubscription(Boolean withSubscription) {
            this.withSubscription = Optional.ofNullable(withSubscription);
            return this;
        }

        @JsonSetter(value="without_feature_override_for", nulls=Nulls.SKIP)
        public Builder withoutFeatureOverrideFor(Optional<String> withoutFeatureOverrideFor) {
            this.withoutFeatureOverrideFor = withoutFeatureOverrideFor;
            return this;
        }

        public Builder withoutFeatureOverrideFor(String withoutFeatureOverrideFor) {
            this.withoutFeatureOverrideFor = Optional.ofNullable(withoutFeatureOverrideFor);
            return this;
        }

        @JsonSetter(value="without_plan", nulls=Nulls.SKIP)
        public Builder withoutPlan(Optional<Boolean> withoutPlan) {
            this.withoutPlan = withoutPlan;
            return this;
        }

        public Builder withoutPlan(Boolean withoutPlan) {
            this.withoutPlan = Optional.ofNullable(withoutPlan);
            return this;
        }

        public ListCompaniesParams build() {
            return new ListCompaniesParams(this.ids, this.limit, this.offset, this.planId, this.q, this.withSubscription, this.withoutFeatureOverrideFor, this.withoutPlan, this.additionalProperties);
        }
    }
}

