/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.companies.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListPlanChangesParams {
    private final Optional<String> action;
    private final Optional<String> basePlanAction;
    private final Optional<String> companyId;
    private final Optional<List<String>> companyIds;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Optional<List<String>> planIds;
    private final Map<String, Object> additionalProperties;

    private ListPlanChangesParams(Optional<String> action, Optional<String> basePlanAction, Optional<String> companyId, Optional<List<String>> companyIds, Optional<Integer> limit, Optional<Integer> offset, Optional<List<String>> planIds, Map<String, Object> additionalProperties) {
        this.action = action;
        this.basePlanAction = basePlanAction;
        this.companyId = companyId;
        this.companyIds = companyIds;
        this.limit = limit;
        this.offset = offset;
        this.planIds = planIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="action")
    public Optional<String> getAction() {
        return this.action;
    }

    @JsonProperty(value="base_plan_action")
    public Optional<String> getBasePlanAction() {
        return this.basePlanAction;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="company_ids")
    public Optional<List<String>> getCompanyIds() {
        return this.companyIds;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    @JsonProperty(value="plan_ids")
    public Optional<List<String>> getPlanIds() {
        return this.planIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListPlanChangesParams && this.equalTo((ListPlanChangesParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListPlanChangesParams other) {
        return this.action.equals(other.action) && this.basePlanAction.equals(other.basePlanAction) && this.companyId.equals(other.companyId) && this.companyIds.equals(other.companyIds) && this.limit.equals(other.limit) && this.offset.equals(other.offset) && this.planIds.equals(other.planIds);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.basePlanAction, this.companyId, this.companyIds, this.limit, this.offset, this.planIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> action = Optional.empty();
        private Optional<String> basePlanAction = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        private Optional<List<String>> companyIds = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        private Optional<List<String>> planIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListPlanChangesParams other) {
            this.action(other.getAction());
            this.basePlanAction(other.getBasePlanAction());
            this.companyId(other.getCompanyId());
            this.companyIds(other.getCompanyIds());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            this.planIds(other.getPlanIds());
            return this;
        }

        @JsonSetter(value="action", nulls=Nulls.SKIP)
        public Builder action(Optional<String> action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        @JsonSetter(value="base_plan_action", nulls=Nulls.SKIP)
        public Builder basePlanAction(Optional<String> basePlanAction) {
            this.basePlanAction = basePlanAction;
            return this;
        }

        public Builder basePlanAction(String basePlanAction) {
            this.basePlanAction = Optional.ofNullable(basePlanAction);
            return this;
        }

        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value="company_ids", nulls=Nulls.SKIP)
        public Builder companyIds(Optional<List<String>> companyIds) {
            this.companyIds = companyIds;
            return this;
        }

        public Builder companyIds(List<String> companyIds) {
            this.companyIds = Optional.ofNullable(companyIds);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value="plan_ids", nulls=Nulls.SKIP)
        public Builder planIds(Optional<List<String>> planIds) {
            this.planIds = planIds;
            return this;
        }

        public Builder planIds(List<String> planIds) {
            this.planIds = Optional.ofNullable(planIds);
            return this;
        }

        public ListPlanChangesParams build() {
            return new ListPlanChangesParams(this.action, this.basePlanAction, this.companyId, this.companyIds, this.limit, this.offset, this.planIds, this.additionalProperties);
        }
    }
}

