/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.components;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.components.AsyncRawComponentsClient;
import com.schematic.api.resources.components.requests.CountComponentsRequest;
import com.schematic.api.resources.components.requests.CreateComponentRequestBody;
import com.schematic.api.resources.components.requests.ListComponentsRequest;
import com.schematic.api.resources.components.requests.PreviewComponentDataRequest;
import com.schematic.api.resources.components.requests.UpdateComponentRequestBody;
import com.schematic.api.resources.components.types.CountComponentsResponse;
import com.schematic.api.resources.components.types.CreateComponentResponse;
import com.schematic.api.resources.components.types.DeleteComponentResponse;
import com.schematic.api.resources.components.types.GetComponentResponse;
import com.schematic.api.resources.components.types.ListComponentsResponse;
import com.schematic.api.resources.components.types.PreviewComponentDataResponse;
import com.schematic.api.resources.components.types.UpdateComponentResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncComponentsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawComponentsClient rawClient;

    public AsyncComponentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawComponentsClient(clientOptions);
    }

    public AsyncRawComponentsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListComponentsResponse> listComponents() {
        return this.rawClient.listComponents().thenApply(response -> (ListComponentsResponse)response.body());
    }

    public CompletableFuture<ListComponentsResponse> listComponents(ListComponentsRequest request) {
        return this.rawClient.listComponents(request).thenApply(response -> (ListComponentsResponse)response.body());
    }

    public CompletableFuture<ListComponentsResponse> listComponents(ListComponentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listComponents(request, requestOptions).thenApply(response -> (ListComponentsResponse)response.body());
    }

    public CompletableFuture<CreateComponentResponse> createComponent(CreateComponentRequestBody request) {
        return this.rawClient.createComponent(request).thenApply(response -> (CreateComponentResponse)response.body());
    }

    public CompletableFuture<CreateComponentResponse> createComponent(CreateComponentRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createComponent(request, requestOptions).thenApply(response -> (CreateComponentResponse)response.body());
    }

    public CompletableFuture<GetComponentResponse> getComponent(String componentId) {
        return this.rawClient.getComponent(componentId).thenApply(response -> (GetComponentResponse)response.body());
    }

    public CompletableFuture<GetComponentResponse> getComponent(String componentId, RequestOptions requestOptions) {
        return this.rawClient.getComponent(componentId, requestOptions).thenApply(response -> (GetComponentResponse)response.body());
    }

    public CompletableFuture<UpdateComponentResponse> updateComponent(String componentId) {
        return this.rawClient.updateComponent(componentId).thenApply(response -> (UpdateComponentResponse)response.body());
    }

    public CompletableFuture<UpdateComponentResponse> updateComponent(String componentId, UpdateComponentRequestBody request) {
        return this.rawClient.updateComponent(componentId, request).thenApply(response -> (UpdateComponentResponse)response.body());
    }

    public CompletableFuture<UpdateComponentResponse> updateComponent(String componentId, UpdateComponentRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateComponent(componentId, request, requestOptions).thenApply(response -> (UpdateComponentResponse)response.body());
    }

    public CompletableFuture<DeleteComponentResponse> deleteComponent(String componentId) {
        return this.rawClient.deleteComponent(componentId).thenApply(response -> (DeleteComponentResponse)response.body());
    }

    public CompletableFuture<DeleteComponentResponse> deleteComponent(String componentId, RequestOptions requestOptions) {
        return this.rawClient.deleteComponent(componentId, requestOptions).thenApply(response -> (DeleteComponentResponse)response.body());
    }

    public CompletableFuture<CountComponentsResponse> countComponents() {
        return this.rawClient.countComponents().thenApply(response -> (CountComponentsResponse)response.body());
    }

    public CompletableFuture<CountComponentsResponse> countComponents(CountComponentsRequest request) {
        return this.rawClient.countComponents(request).thenApply(response -> (CountComponentsResponse)response.body());
    }

    public CompletableFuture<CountComponentsResponse> countComponents(CountComponentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countComponents(request, requestOptions).thenApply(response -> (CountComponentsResponse)response.body());
    }

    public CompletableFuture<PreviewComponentDataResponse> previewComponentData() {
        return this.rawClient.previewComponentData().thenApply(response -> (PreviewComponentDataResponse)response.body());
    }

    public CompletableFuture<PreviewComponentDataResponse> previewComponentData(PreviewComponentDataRequest request) {
        return this.rawClient.previewComponentData(request).thenApply(response -> (PreviewComponentDataResponse)response.body());
    }

    public CompletableFuture<PreviewComponentDataResponse> previewComponentData(PreviewComponentDataRequest request, RequestOptions requestOptions) {
        return this.rawClient.previewComponentData(request, requestOptions).thenApply(response -> (PreviewComponentDataResponse)response.body());
    }
}

