/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.components.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.components.types.CreateComponentRequestBodyEntityType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateComponentRequestBody {
    private final Optional<Map<String, Double>> ast;
    private final CreateComponentRequestBodyEntityType entityType;
    private final String name;
    private final Map<String, Object> additionalProperties;

    private CreateComponentRequestBody(Optional<Map<String, Double>> ast, CreateComponentRequestBodyEntityType entityType, String name, Map<String, Object> additionalProperties) {
        this.ast = ast;
        this.entityType = entityType;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ast")
    public Optional<Map<String, Double>> getAst() {
        return this.ast;
    }

    @JsonProperty(value="entity_type")
    public CreateComponentRequestBodyEntityType getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateComponentRequestBody && this.equalTo((CreateComponentRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateComponentRequestBody other) {
        return this.ast.equals(other.ast) && this.entityType.equals(other.entityType) && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.ast, this.entityType, this.name);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EntityTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EntityTypeStage,
    NameStage,
    _FinalStage {
        private CreateComponentRequestBodyEntityType entityType;
        private String name;
        private Optional<Map<String, Double>> ast = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateComponentRequestBody other) {
            this.ast(other.getAst());
            this.entityType(other.getEntityType());
            this.name(other.getName());
            return this;
        }

        @Override
        @JsonSetter(value="entity_type")
        public NameStage entityType(@NotNull CreateComponentRequestBodyEntityType entityType) {
            this.entityType = Objects.requireNonNull(entityType, "entityType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage ast(Map<String, Double> ast) {
            this.ast = Optional.ofNullable(ast);
            return this;
        }

        @Override
        @JsonSetter(value="ast", nulls=Nulls.SKIP)
        public _FinalStage ast(Optional<Map<String, Double>> ast) {
            this.ast = ast;
            return this;
        }

        @Override
        public CreateComponentRequestBody build() {
            return new CreateComponentRequestBody(this.ast, this.entityType, this.name, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateComponentRequestBody build();

        public _FinalStage ast(Optional<Map<String, Double>> var1);

        public _FinalStage ast(Map<String, Double> var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface EntityTypeStage {
        public NameStage entityType(@NotNull CreateComponentRequestBodyEntityType var1);

        public Builder from(CreateComponentRequestBody var1);
    }
}

