/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.credits;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.credits.AsyncRawCreditsClient;
import com.schematic.api.resources.credits.requests.CountBillingCreditsGrantsRequest;
import com.schematic.api.resources.credits.requests.CountBillingCreditsRequest;
import com.schematic.api.resources.credits.requests.CountBillingPlanCreditGrantsRequest;
import com.schematic.api.resources.credits.requests.CountCreditBundlesRequest;
import com.schematic.api.resources.credits.requests.CountCreditLedgerRequest;
import com.schematic.api.resources.credits.requests.CreateBillingCreditRequestBody;
import com.schematic.api.resources.credits.requests.CreateBillingPlanCreditGrantRequestBody;
import com.schematic.api.resources.credits.requests.CreateCompanyCreditGrant;
import com.schematic.api.resources.credits.requests.CreateCreditBundleRequestBody;
import com.schematic.api.resources.credits.requests.GetEnrichedCreditLedgerRequest;
import com.schematic.api.resources.credits.requests.ListBillingCreditsRequest;
import com.schematic.api.resources.credits.requests.ListBillingPlanCreditGrantsRequest;
import com.schematic.api.resources.credits.requests.ListCompanyGrantsRequest;
import com.schematic.api.resources.credits.requests.ListCreditBundlesRequest;
import com.schematic.api.resources.credits.requests.ListGrantsForCreditRequest;
import com.schematic.api.resources.credits.requests.UpdateBillingCreditRequestBody;
import com.schematic.api.resources.credits.requests.UpdateCreditBundleDetailsRequestBody;
import com.schematic.api.resources.credits.requests.ZeroOutGrantRequestBody;
import com.schematic.api.resources.credits.types.CountBillingCreditsGrantsResponse;
import com.schematic.api.resources.credits.types.CountBillingCreditsResponse;
import com.schematic.api.resources.credits.types.CountBillingPlanCreditGrantsResponse;
import com.schematic.api.resources.credits.types.CountCreditBundlesResponse;
import com.schematic.api.resources.credits.types.CountCreditLedgerResponse;
import com.schematic.api.resources.credits.types.CreateBillingCreditResponse;
import com.schematic.api.resources.credits.types.CreateBillingPlanCreditGrantResponse;
import com.schematic.api.resources.credits.types.CreateCreditBundleResponse;
import com.schematic.api.resources.credits.types.DeleteBillingPlanCreditGrantResponse;
import com.schematic.api.resources.credits.types.DeleteCreditBundleResponse;
import com.schematic.api.resources.credits.types.GetCreditBundleResponse;
import com.schematic.api.resources.credits.types.GetEnrichedCreditLedgerResponse;
import com.schematic.api.resources.credits.types.GetSingleBillingCreditResponse;
import com.schematic.api.resources.credits.types.GrantBillingCreditsToCompanyResponse;
import com.schematic.api.resources.credits.types.ListBillingCreditsResponse;
import com.schematic.api.resources.credits.types.ListBillingPlanCreditGrantsResponse;
import com.schematic.api.resources.credits.types.ListCompanyGrantsResponse;
import com.schematic.api.resources.credits.types.ListCreditBundlesResponse;
import com.schematic.api.resources.credits.types.ListGrantsForCreditResponse;
import com.schematic.api.resources.credits.types.SoftDeleteBillingCreditResponse;
import com.schematic.api.resources.credits.types.UpdateBillingCreditResponse;
import com.schematic.api.resources.credits.types.UpdateCreditBundleDetailsResponse;
import com.schematic.api.resources.credits.types.ZeroOutGrantResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCreditsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCreditsClient rawClient;

    public AsyncCreditsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCreditsClient(clientOptions);
    }

    public AsyncRawCreditsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListBillingCreditsResponse> listBillingCredits() {
        return this.rawClient.listBillingCredits().thenApply(response -> (ListBillingCreditsResponse)response.body());
    }

    public CompletableFuture<ListBillingCreditsResponse> listBillingCredits(ListBillingCreditsRequest request) {
        return this.rawClient.listBillingCredits(request).thenApply(response -> (ListBillingCreditsResponse)response.body());
    }

    public CompletableFuture<ListBillingCreditsResponse> listBillingCredits(ListBillingCreditsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listBillingCredits(request, requestOptions).thenApply(response -> (ListBillingCreditsResponse)response.body());
    }

    public CompletableFuture<CreateBillingCreditResponse> createBillingCredit(CreateBillingCreditRequestBody request) {
        return this.rawClient.createBillingCredit(request).thenApply(response -> (CreateBillingCreditResponse)response.body());
    }

    public CompletableFuture<CreateBillingCreditResponse> createBillingCredit(CreateBillingCreditRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createBillingCredit(request, requestOptions).thenApply(response -> (CreateBillingCreditResponse)response.body());
    }

    public CompletableFuture<GetSingleBillingCreditResponse> getSingleBillingCredit(String creditId) {
        return this.rawClient.getSingleBillingCredit(creditId).thenApply(response -> (GetSingleBillingCreditResponse)response.body());
    }

    public CompletableFuture<GetSingleBillingCreditResponse> getSingleBillingCredit(String creditId, RequestOptions requestOptions) {
        return this.rawClient.getSingleBillingCredit(creditId, requestOptions).thenApply(response -> (GetSingleBillingCreditResponse)response.body());
    }

    public CompletableFuture<UpdateBillingCreditResponse> updateBillingCredit(String creditId, UpdateBillingCreditRequestBody request) {
        return this.rawClient.updateBillingCredit(creditId, request).thenApply(response -> (UpdateBillingCreditResponse)response.body());
    }

    public CompletableFuture<UpdateBillingCreditResponse> updateBillingCredit(String creditId, UpdateBillingCreditRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateBillingCredit(creditId, request, requestOptions).thenApply(response -> (UpdateBillingCreditResponse)response.body());
    }

    public CompletableFuture<SoftDeleteBillingCreditResponse> softDeleteBillingCredit(String creditId) {
        return this.rawClient.softDeleteBillingCredit(creditId).thenApply(response -> (SoftDeleteBillingCreditResponse)response.body());
    }

    public CompletableFuture<SoftDeleteBillingCreditResponse> softDeleteBillingCredit(String creditId, RequestOptions requestOptions) {
        return this.rawClient.softDeleteBillingCredit(creditId, requestOptions).thenApply(response -> (SoftDeleteBillingCreditResponse)response.body());
    }

    public CompletableFuture<ListCreditBundlesResponse> listCreditBundles() {
        return this.rawClient.listCreditBundles().thenApply(response -> (ListCreditBundlesResponse)response.body());
    }

    public CompletableFuture<ListCreditBundlesResponse> listCreditBundles(ListCreditBundlesRequest request) {
        return this.rawClient.listCreditBundles(request).thenApply(response -> (ListCreditBundlesResponse)response.body());
    }

    public CompletableFuture<ListCreditBundlesResponse> listCreditBundles(ListCreditBundlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCreditBundles(request, requestOptions).thenApply(response -> (ListCreditBundlesResponse)response.body());
    }

    public CompletableFuture<CreateCreditBundleResponse> createCreditBundle(CreateCreditBundleRequestBody request) {
        return this.rawClient.createCreditBundle(request).thenApply(response -> (CreateCreditBundleResponse)response.body());
    }

    public CompletableFuture<CreateCreditBundleResponse> createCreditBundle(CreateCreditBundleRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createCreditBundle(request, requestOptions).thenApply(response -> (CreateCreditBundleResponse)response.body());
    }

    public CompletableFuture<GetCreditBundleResponse> getCreditBundle(String bundleId) {
        return this.rawClient.getCreditBundle(bundleId).thenApply(response -> (GetCreditBundleResponse)response.body());
    }

    public CompletableFuture<GetCreditBundleResponse> getCreditBundle(String bundleId, RequestOptions requestOptions) {
        return this.rawClient.getCreditBundle(bundleId, requestOptions).thenApply(response -> (GetCreditBundleResponse)response.body());
    }

    public CompletableFuture<UpdateCreditBundleDetailsResponse> updateCreditBundleDetails(String bundleId, UpdateCreditBundleDetailsRequestBody request) {
        return this.rawClient.updateCreditBundleDetails(bundleId, request).thenApply(response -> (UpdateCreditBundleDetailsResponse)response.body());
    }

    public CompletableFuture<UpdateCreditBundleDetailsResponse> updateCreditBundleDetails(String bundleId, UpdateCreditBundleDetailsRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateCreditBundleDetails(bundleId, request, requestOptions).thenApply(response -> (UpdateCreditBundleDetailsResponse)response.body());
    }

    public CompletableFuture<DeleteCreditBundleResponse> deleteCreditBundle(String bundleId) {
        return this.rawClient.deleteCreditBundle(bundleId).thenApply(response -> (DeleteCreditBundleResponse)response.body());
    }

    public CompletableFuture<DeleteCreditBundleResponse> deleteCreditBundle(String bundleId, RequestOptions requestOptions) {
        return this.rawClient.deleteCreditBundle(bundleId, requestOptions).thenApply(response -> (DeleteCreditBundleResponse)response.body());
    }

    public CompletableFuture<CountCreditBundlesResponse> countCreditBundles() {
        return this.rawClient.countCreditBundles().thenApply(response -> (CountCreditBundlesResponse)response.body());
    }

    public CompletableFuture<CountCreditBundlesResponse> countCreditBundles(CountCreditBundlesRequest request) {
        return this.rawClient.countCreditBundles(request).thenApply(response -> (CountCreditBundlesResponse)response.body());
    }

    public CompletableFuture<CountCreditBundlesResponse> countCreditBundles(CountCreditBundlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.countCreditBundles(request, requestOptions).thenApply(response -> (CountCreditBundlesResponse)response.body());
    }

    public CompletableFuture<CountBillingCreditsResponse> countBillingCredits() {
        return this.rawClient.countBillingCredits().thenApply(response -> (CountBillingCreditsResponse)response.body());
    }

    public CompletableFuture<CountBillingCreditsResponse> countBillingCredits(CountBillingCreditsRequest request) {
        return this.rawClient.countBillingCredits(request).thenApply(response -> (CountBillingCreditsResponse)response.body());
    }

    public CompletableFuture<CountBillingCreditsResponse> countBillingCredits(CountBillingCreditsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countBillingCredits(request, requestOptions).thenApply(response -> (CountBillingCreditsResponse)response.body());
    }

    public CompletableFuture<ZeroOutGrantResponse> zeroOutGrant(String grantId) {
        return this.rawClient.zeroOutGrant(grantId).thenApply(response -> (ZeroOutGrantResponse)response.body());
    }

    public CompletableFuture<ZeroOutGrantResponse> zeroOutGrant(String grantId, ZeroOutGrantRequestBody request) {
        return this.rawClient.zeroOutGrant(grantId, request).thenApply(response -> (ZeroOutGrantResponse)response.body());
    }

    public CompletableFuture<ZeroOutGrantResponse> zeroOutGrant(String grantId, ZeroOutGrantRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.zeroOutGrant(grantId, request, requestOptions).thenApply(response -> (ZeroOutGrantResponse)response.body());
    }

    public CompletableFuture<GrantBillingCreditsToCompanyResponse> grantBillingCreditsToCompany(CreateCompanyCreditGrant request) {
        return this.rawClient.grantBillingCreditsToCompany(request).thenApply(response -> (GrantBillingCreditsToCompanyResponse)response.body());
    }

    public CompletableFuture<GrantBillingCreditsToCompanyResponse> grantBillingCreditsToCompany(CreateCompanyCreditGrant request, RequestOptions requestOptions) {
        return this.rawClient.grantBillingCreditsToCompany(request, requestOptions).thenApply(response -> (GrantBillingCreditsToCompanyResponse)response.body());
    }

    public CompletableFuture<ListCompanyGrantsResponse> listCompanyGrants() {
        return this.rawClient.listCompanyGrants().thenApply(response -> (ListCompanyGrantsResponse)response.body());
    }

    public CompletableFuture<ListCompanyGrantsResponse> listCompanyGrants(ListCompanyGrantsRequest request) {
        return this.rawClient.listCompanyGrants(request).thenApply(response -> (ListCompanyGrantsResponse)response.body());
    }

    public CompletableFuture<ListCompanyGrantsResponse> listCompanyGrants(ListCompanyGrantsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompanyGrants(request, requestOptions).thenApply(response -> (ListCompanyGrantsResponse)response.body());
    }

    public CompletableFuture<CountBillingCreditsGrantsResponse> countBillingCreditsGrants() {
        return this.rawClient.countBillingCreditsGrants().thenApply(response -> (CountBillingCreditsGrantsResponse)response.body());
    }

    public CompletableFuture<CountBillingCreditsGrantsResponse> countBillingCreditsGrants(CountBillingCreditsGrantsRequest request) {
        return this.rawClient.countBillingCreditsGrants(request).thenApply(response -> (CountBillingCreditsGrantsResponse)response.body());
    }

    public CompletableFuture<CountBillingCreditsGrantsResponse> countBillingCreditsGrants(CountBillingCreditsGrantsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countBillingCreditsGrants(request, requestOptions).thenApply(response -> (CountBillingCreditsGrantsResponse)response.body());
    }

    public CompletableFuture<ListGrantsForCreditResponse> listGrantsForCredit() {
        return this.rawClient.listGrantsForCredit().thenApply(response -> (ListGrantsForCreditResponse)response.body());
    }

    public CompletableFuture<ListGrantsForCreditResponse> listGrantsForCredit(ListGrantsForCreditRequest request) {
        return this.rawClient.listGrantsForCredit(request).thenApply(response -> (ListGrantsForCreditResponse)response.body());
    }

    public CompletableFuture<ListGrantsForCreditResponse> listGrantsForCredit(ListGrantsForCreditRequest request, RequestOptions requestOptions) {
        return this.rawClient.listGrantsForCredit(request, requestOptions).thenApply(response -> (ListGrantsForCreditResponse)response.body());
    }

    public CompletableFuture<GetEnrichedCreditLedgerResponse> getEnrichedCreditLedger(GetEnrichedCreditLedgerRequest request) {
        return this.rawClient.getEnrichedCreditLedger(request).thenApply(response -> (GetEnrichedCreditLedgerResponse)response.body());
    }

    public CompletableFuture<GetEnrichedCreditLedgerResponse> getEnrichedCreditLedger(GetEnrichedCreditLedgerRequest request, RequestOptions requestOptions) {
        return this.rawClient.getEnrichedCreditLedger(request, requestOptions).thenApply(response -> (GetEnrichedCreditLedgerResponse)response.body());
    }

    public CompletableFuture<CountCreditLedgerResponse> countCreditLedger(CountCreditLedgerRequest request) {
        return this.rawClient.countCreditLedger(request).thenApply(response -> (CountCreditLedgerResponse)response.body());
    }

    public CompletableFuture<CountCreditLedgerResponse> countCreditLedger(CountCreditLedgerRequest request, RequestOptions requestOptions) {
        return this.rawClient.countCreditLedger(request, requestOptions).thenApply(response -> (CountCreditLedgerResponse)response.body());
    }

    public CompletableFuture<ListBillingPlanCreditGrantsResponse> listBillingPlanCreditGrants() {
        return this.rawClient.listBillingPlanCreditGrants().thenApply(response -> (ListBillingPlanCreditGrantsResponse)response.body());
    }

    public CompletableFuture<ListBillingPlanCreditGrantsResponse> listBillingPlanCreditGrants(ListBillingPlanCreditGrantsRequest request) {
        return this.rawClient.listBillingPlanCreditGrants(request).thenApply(response -> (ListBillingPlanCreditGrantsResponse)response.body());
    }

    public CompletableFuture<ListBillingPlanCreditGrantsResponse> listBillingPlanCreditGrants(ListBillingPlanCreditGrantsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listBillingPlanCreditGrants(request, requestOptions).thenApply(response -> (ListBillingPlanCreditGrantsResponse)response.body());
    }

    public CompletableFuture<CreateBillingPlanCreditGrantResponse> createBillingPlanCreditGrant(CreateBillingPlanCreditGrantRequestBody request) {
        return this.rawClient.createBillingPlanCreditGrant(request).thenApply(response -> (CreateBillingPlanCreditGrantResponse)response.body());
    }

    public CompletableFuture<CreateBillingPlanCreditGrantResponse> createBillingPlanCreditGrant(CreateBillingPlanCreditGrantRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createBillingPlanCreditGrant(request, requestOptions).thenApply(response -> (CreateBillingPlanCreditGrantResponse)response.body());
    }

    public CompletableFuture<DeleteBillingPlanCreditGrantResponse> deleteBillingPlanCreditGrant(String planGrantId) {
        return this.rawClient.deleteBillingPlanCreditGrant(planGrantId).thenApply(response -> (DeleteBillingPlanCreditGrantResponse)response.body());
    }

    public CompletableFuture<DeleteBillingPlanCreditGrantResponse> deleteBillingPlanCreditGrant(String planGrantId, RequestOptions requestOptions) {
        return this.rawClient.deleteBillingPlanCreditGrant(planGrantId, requestOptions).thenApply(response -> (DeleteBillingPlanCreditGrantResponse)response.body());
    }

    public CompletableFuture<CountBillingPlanCreditGrantsResponse> countBillingPlanCreditGrants() {
        return this.rawClient.countBillingPlanCreditGrants().thenApply(response -> (CountBillingPlanCreditGrantsResponse)response.body());
    }

    public CompletableFuture<CountBillingPlanCreditGrantsResponse> countBillingPlanCreditGrants(CountBillingPlanCreditGrantsRequest request) {
        return this.rawClient.countBillingPlanCreditGrants(request).thenApply(response -> (CountBillingPlanCreditGrantsResponse)response.body());
    }

    public CompletableFuture<CountBillingPlanCreditGrantsResponse> countBillingPlanCreditGrants(CountBillingPlanCreditGrantsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countBillingPlanCreditGrants(request, requestOptions).thenApply(response -> (CountBillingPlanCreditGrantsResponse)response.body());
    }
}

