/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.credits;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.credits.RawCreditsClient;
import com.schematic.api.resources.credits.requests.CountBillingCreditsGrantsRequest;
import com.schematic.api.resources.credits.requests.CountBillingCreditsRequest;
import com.schematic.api.resources.credits.requests.CountBillingPlanCreditGrantsRequest;
import com.schematic.api.resources.credits.requests.CountCreditBundlesRequest;
import com.schematic.api.resources.credits.requests.CountCreditLedgerRequest;
import com.schematic.api.resources.credits.requests.CreateBillingCreditRequestBody;
import com.schematic.api.resources.credits.requests.CreateBillingPlanCreditGrantRequestBody;
import com.schematic.api.resources.credits.requests.CreateCompanyCreditGrant;
import com.schematic.api.resources.credits.requests.CreateCreditBundleRequestBody;
import com.schematic.api.resources.credits.requests.GetEnrichedCreditLedgerRequest;
import com.schematic.api.resources.credits.requests.ListBillingCreditsRequest;
import com.schematic.api.resources.credits.requests.ListBillingPlanCreditGrantsRequest;
import com.schematic.api.resources.credits.requests.ListCompanyGrantsRequest;
import com.schematic.api.resources.credits.requests.ListCreditBundlesRequest;
import com.schematic.api.resources.credits.requests.ListGrantsForCreditRequest;
import com.schematic.api.resources.credits.requests.UpdateBillingCreditRequestBody;
import com.schematic.api.resources.credits.requests.UpdateCreditBundleDetailsRequestBody;
import com.schematic.api.resources.credits.requests.ZeroOutGrantRequestBody;
import com.schematic.api.resources.credits.types.CountBillingCreditsGrantsResponse;
import com.schematic.api.resources.credits.types.CountBillingCreditsResponse;
import com.schematic.api.resources.credits.types.CountBillingPlanCreditGrantsResponse;
import com.schematic.api.resources.credits.types.CountCreditBundlesResponse;
import com.schematic.api.resources.credits.types.CountCreditLedgerResponse;
import com.schematic.api.resources.credits.types.CreateBillingCreditResponse;
import com.schematic.api.resources.credits.types.CreateBillingPlanCreditGrantResponse;
import com.schematic.api.resources.credits.types.CreateCreditBundleResponse;
import com.schematic.api.resources.credits.types.DeleteBillingPlanCreditGrantResponse;
import com.schematic.api.resources.credits.types.DeleteCreditBundleResponse;
import com.schematic.api.resources.credits.types.GetCreditBundleResponse;
import com.schematic.api.resources.credits.types.GetEnrichedCreditLedgerResponse;
import com.schematic.api.resources.credits.types.GetSingleBillingCreditResponse;
import com.schematic.api.resources.credits.types.GrantBillingCreditsToCompanyResponse;
import com.schematic.api.resources.credits.types.ListBillingCreditsResponse;
import com.schematic.api.resources.credits.types.ListBillingPlanCreditGrantsResponse;
import com.schematic.api.resources.credits.types.ListCompanyGrantsResponse;
import com.schematic.api.resources.credits.types.ListCreditBundlesResponse;
import com.schematic.api.resources.credits.types.ListGrantsForCreditResponse;
import com.schematic.api.resources.credits.types.SoftDeleteBillingCreditResponse;
import com.schematic.api.resources.credits.types.UpdateBillingCreditResponse;
import com.schematic.api.resources.credits.types.UpdateCreditBundleDetailsResponse;
import com.schematic.api.resources.credits.types.ZeroOutGrantResponse;

public class CreditsClient {
    protected final ClientOptions clientOptions;
    private final RawCreditsClient rawClient;

    public CreditsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCreditsClient(clientOptions);
    }

    public RawCreditsClient withRawResponse() {
        return this.rawClient;
    }

    public ListBillingCreditsResponse listBillingCredits() {
        return this.rawClient.listBillingCredits().body();
    }

    public ListBillingCreditsResponse listBillingCredits(ListBillingCreditsRequest request) {
        return this.rawClient.listBillingCredits(request).body();
    }

    public ListBillingCreditsResponse listBillingCredits(ListBillingCreditsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listBillingCredits(request, requestOptions).body();
    }

    public CreateBillingCreditResponse createBillingCredit(CreateBillingCreditRequestBody request) {
        return this.rawClient.createBillingCredit(request).body();
    }

    public CreateBillingCreditResponse createBillingCredit(CreateBillingCreditRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createBillingCredit(request, requestOptions).body();
    }

    public GetSingleBillingCreditResponse getSingleBillingCredit(String creditId) {
        return this.rawClient.getSingleBillingCredit(creditId).body();
    }

    public GetSingleBillingCreditResponse getSingleBillingCredit(String creditId, RequestOptions requestOptions) {
        return this.rawClient.getSingleBillingCredit(creditId, requestOptions).body();
    }

    public UpdateBillingCreditResponse updateBillingCredit(String creditId, UpdateBillingCreditRequestBody request) {
        return this.rawClient.updateBillingCredit(creditId, request).body();
    }

    public UpdateBillingCreditResponse updateBillingCredit(String creditId, UpdateBillingCreditRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateBillingCredit(creditId, request, requestOptions).body();
    }

    public SoftDeleteBillingCreditResponse softDeleteBillingCredit(String creditId) {
        return this.rawClient.softDeleteBillingCredit(creditId).body();
    }

    public SoftDeleteBillingCreditResponse softDeleteBillingCredit(String creditId, RequestOptions requestOptions) {
        return this.rawClient.softDeleteBillingCredit(creditId, requestOptions).body();
    }

    public ListCreditBundlesResponse listCreditBundles() {
        return this.rawClient.listCreditBundles().body();
    }

    public ListCreditBundlesResponse listCreditBundles(ListCreditBundlesRequest request) {
        return this.rawClient.listCreditBundles(request).body();
    }

    public ListCreditBundlesResponse listCreditBundles(ListCreditBundlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCreditBundles(request, requestOptions).body();
    }

    public CreateCreditBundleResponse createCreditBundle(CreateCreditBundleRequestBody request) {
        return this.rawClient.createCreditBundle(request).body();
    }

    public CreateCreditBundleResponse createCreditBundle(CreateCreditBundleRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createCreditBundle(request, requestOptions).body();
    }

    public GetCreditBundleResponse getCreditBundle(String bundleId) {
        return this.rawClient.getCreditBundle(bundleId).body();
    }

    public GetCreditBundleResponse getCreditBundle(String bundleId, RequestOptions requestOptions) {
        return this.rawClient.getCreditBundle(bundleId, requestOptions).body();
    }

    public UpdateCreditBundleDetailsResponse updateCreditBundleDetails(String bundleId, UpdateCreditBundleDetailsRequestBody request) {
        return this.rawClient.updateCreditBundleDetails(bundleId, request).body();
    }

    public UpdateCreditBundleDetailsResponse updateCreditBundleDetails(String bundleId, UpdateCreditBundleDetailsRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateCreditBundleDetails(bundleId, request, requestOptions).body();
    }

    public DeleteCreditBundleResponse deleteCreditBundle(String bundleId) {
        return this.rawClient.deleteCreditBundle(bundleId).body();
    }

    public DeleteCreditBundleResponse deleteCreditBundle(String bundleId, RequestOptions requestOptions) {
        return this.rawClient.deleteCreditBundle(bundleId, requestOptions).body();
    }

    public CountCreditBundlesResponse countCreditBundles() {
        return this.rawClient.countCreditBundles().body();
    }

    public CountCreditBundlesResponse countCreditBundles(CountCreditBundlesRequest request) {
        return this.rawClient.countCreditBundles(request).body();
    }

    public CountCreditBundlesResponse countCreditBundles(CountCreditBundlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.countCreditBundles(request, requestOptions).body();
    }

    public CountBillingCreditsResponse countBillingCredits() {
        return this.rawClient.countBillingCredits().body();
    }

    public CountBillingCreditsResponse countBillingCredits(CountBillingCreditsRequest request) {
        return this.rawClient.countBillingCredits(request).body();
    }

    public CountBillingCreditsResponse countBillingCredits(CountBillingCreditsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countBillingCredits(request, requestOptions).body();
    }

    public ZeroOutGrantResponse zeroOutGrant(String grantId) {
        return this.rawClient.zeroOutGrant(grantId).body();
    }

    public ZeroOutGrantResponse zeroOutGrant(String grantId, ZeroOutGrantRequestBody request) {
        return this.rawClient.zeroOutGrant(grantId, request).body();
    }

    public ZeroOutGrantResponse zeroOutGrant(String grantId, ZeroOutGrantRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.zeroOutGrant(grantId, request, requestOptions).body();
    }

    public GrantBillingCreditsToCompanyResponse grantBillingCreditsToCompany(CreateCompanyCreditGrant request) {
        return this.rawClient.grantBillingCreditsToCompany(request).body();
    }

    public GrantBillingCreditsToCompanyResponse grantBillingCreditsToCompany(CreateCompanyCreditGrant request, RequestOptions requestOptions) {
        return this.rawClient.grantBillingCreditsToCompany(request, requestOptions).body();
    }

    public ListCompanyGrantsResponse listCompanyGrants() {
        return this.rawClient.listCompanyGrants().body();
    }

    public ListCompanyGrantsResponse listCompanyGrants(ListCompanyGrantsRequest request) {
        return this.rawClient.listCompanyGrants(request).body();
    }

    public ListCompanyGrantsResponse listCompanyGrants(ListCompanyGrantsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompanyGrants(request, requestOptions).body();
    }

    public CountBillingCreditsGrantsResponse countBillingCreditsGrants() {
        return this.rawClient.countBillingCreditsGrants().body();
    }

    public CountBillingCreditsGrantsResponse countBillingCreditsGrants(CountBillingCreditsGrantsRequest request) {
        return this.rawClient.countBillingCreditsGrants(request).body();
    }

    public CountBillingCreditsGrantsResponse countBillingCreditsGrants(CountBillingCreditsGrantsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countBillingCreditsGrants(request, requestOptions).body();
    }

    public ListGrantsForCreditResponse listGrantsForCredit() {
        return this.rawClient.listGrantsForCredit().body();
    }

    public ListGrantsForCreditResponse listGrantsForCredit(ListGrantsForCreditRequest request) {
        return this.rawClient.listGrantsForCredit(request).body();
    }

    public ListGrantsForCreditResponse listGrantsForCredit(ListGrantsForCreditRequest request, RequestOptions requestOptions) {
        return this.rawClient.listGrantsForCredit(request, requestOptions).body();
    }

    public GetEnrichedCreditLedgerResponse getEnrichedCreditLedger(GetEnrichedCreditLedgerRequest request) {
        return this.rawClient.getEnrichedCreditLedger(request).body();
    }

    public GetEnrichedCreditLedgerResponse getEnrichedCreditLedger(GetEnrichedCreditLedgerRequest request, RequestOptions requestOptions) {
        return this.rawClient.getEnrichedCreditLedger(request, requestOptions).body();
    }

    public CountCreditLedgerResponse countCreditLedger(CountCreditLedgerRequest request) {
        return this.rawClient.countCreditLedger(request).body();
    }

    public CountCreditLedgerResponse countCreditLedger(CountCreditLedgerRequest request, RequestOptions requestOptions) {
        return this.rawClient.countCreditLedger(request, requestOptions).body();
    }

    public ListBillingPlanCreditGrantsResponse listBillingPlanCreditGrants() {
        return this.rawClient.listBillingPlanCreditGrants().body();
    }

    public ListBillingPlanCreditGrantsResponse listBillingPlanCreditGrants(ListBillingPlanCreditGrantsRequest request) {
        return this.rawClient.listBillingPlanCreditGrants(request).body();
    }

    public ListBillingPlanCreditGrantsResponse listBillingPlanCreditGrants(ListBillingPlanCreditGrantsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listBillingPlanCreditGrants(request, requestOptions).body();
    }

    public CreateBillingPlanCreditGrantResponse createBillingPlanCreditGrant(CreateBillingPlanCreditGrantRequestBody request) {
        return this.rawClient.createBillingPlanCreditGrant(request).body();
    }

    public CreateBillingPlanCreditGrantResponse createBillingPlanCreditGrant(CreateBillingPlanCreditGrantRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createBillingPlanCreditGrant(request, requestOptions).body();
    }

    public DeleteBillingPlanCreditGrantResponse deleteBillingPlanCreditGrant(String planGrantId) {
        return this.rawClient.deleteBillingPlanCreditGrant(planGrantId).body();
    }

    public DeleteBillingPlanCreditGrantResponse deleteBillingPlanCreditGrant(String planGrantId, RequestOptions requestOptions) {
        return this.rawClient.deleteBillingPlanCreditGrant(planGrantId, requestOptions).body();
    }

    public CountBillingPlanCreditGrantsResponse countBillingPlanCreditGrants() {
        return this.rawClient.countBillingPlanCreditGrants().body();
    }

    public CountBillingPlanCreditGrantsResponse countBillingPlanCreditGrants(CountBillingPlanCreditGrantsRequest request) {
        return this.rawClient.countBillingPlanCreditGrants(request).body();
    }

    public CountBillingPlanCreditGrantsResponse countBillingPlanCreditGrants(CountBillingPlanCreditGrantsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countBillingPlanCreditGrants(request, requestOptions).body();
    }
}

