/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.credits.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.credits.types.CountCreditLedgerRequestPeriod;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CountCreditLedgerRequest {
    private final String companyId;
    private final Optional<String> billingCreditId;
    private final Optional<String> featureId;
    private final CountCreditLedgerRequestPeriod period;
    private final Optional<String> startTime;
    private final Optional<String> endTime;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Map<String, Object> additionalProperties;

    private CountCreditLedgerRequest(String companyId, Optional<String> billingCreditId, Optional<String> featureId, CountCreditLedgerRequestPeriod period, Optional<String> startTime, Optional<String> endTime, Optional<Integer> limit, Optional<Integer> offset, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.billingCreditId = billingCreditId;
        this.featureId = featureId;
        this.period = period;
        this.startTime = startTime;
        this.endTime = endTime;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="billing_credit_id")
    public Optional<String> getBillingCreditId() {
        return this.billingCreditId;
    }

    @JsonProperty(value="feature_id")
    public Optional<String> getFeatureId() {
        return this.featureId;
    }

    @JsonProperty(value="period")
    public CountCreditLedgerRequestPeriod getPeriod() {
        return this.period;
    }

    @JsonProperty(value="start_time")
    public Optional<String> getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="end_time")
    public Optional<String> getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CountCreditLedgerRequest && this.equalTo((CountCreditLedgerRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CountCreditLedgerRequest other) {
        return this.companyId.equals(other.companyId) && this.billingCreditId.equals(other.billingCreditId) && this.featureId.equals(other.featureId) && this.period.equals(other.period) && this.startTime.equals(other.startTime) && this.endTime.equals(other.endTime) && this.limit.equals(other.limit) && this.offset.equals(other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.billingCreditId, this.featureId, this.period, this.startTime, this.endTime, this.limit, this.offset);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CompanyIdStage,
    PeriodStage,
    _FinalStage {
        private String companyId;
        private CountCreditLedgerRequestPeriod period;
        private Optional<Integer> offset = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> endTime = Optional.empty();
        private Optional<String> startTime = Optional.empty();
        private Optional<String> featureId = Optional.empty();
        private Optional<String> billingCreditId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CountCreditLedgerRequest other) {
            this.companyId(other.getCompanyId());
            this.billingCreditId(other.getBillingCreditId());
            this.featureId(other.getFeatureId());
            this.period(other.getPeriod());
            this.startTime(other.getStartTime());
            this.endTime(other.getEndTime());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public PeriodStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="period")
        public _FinalStage period(@NotNull CountCreditLedgerRequestPeriod period) {
            this.period = Objects.requireNonNull(period, "period must not be null");
            return this;
        }

        @Override
        public _FinalStage offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @Override
        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public _FinalStage offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public _FinalStage endTime(String endTime) {
            this.endTime = Optional.ofNullable(endTime);
            return this;
        }

        @Override
        @JsonSetter(value="end_time", nulls=Nulls.SKIP)
        public _FinalStage endTime(Optional<String> endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public _FinalStage startTime(String startTime) {
            this.startTime = Optional.ofNullable(startTime);
            return this;
        }

        @Override
        @JsonSetter(value="start_time", nulls=Nulls.SKIP)
        public _FinalStage startTime(Optional<String> startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public _FinalStage featureId(String featureId) {
            this.featureId = Optional.ofNullable(featureId);
            return this;
        }

        @Override
        @JsonSetter(value="feature_id", nulls=Nulls.SKIP)
        public _FinalStage featureId(Optional<String> featureId) {
            this.featureId = featureId;
            return this;
        }

        @Override
        public _FinalStage billingCreditId(String billingCreditId) {
            this.billingCreditId = Optional.ofNullable(billingCreditId);
            return this;
        }

        @Override
        @JsonSetter(value="billing_credit_id", nulls=Nulls.SKIP)
        public _FinalStage billingCreditId(Optional<String> billingCreditId) {
            this.billingCreditId = billingCreditId;
            return this;
        }

        @Override
        public CountCreditLedgerRequest build() {
            return new CountCreditLedgerRequest(this.companyId, this.billingCreditId, this.featureId, this.period, this.startTime, this.endTime, this.limit, this.offset, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CountCreditLedgerRequest build();

        public _FinalStage billingCreditId(Optional<String> var1);

        public _FinalStage billingCreditId(String var1);

        public _FinalStage featureId(Optional<String> var1);

        public _FinalStage featureId(String var1);

        public _FinalStage startTime(Optional<String> var1);

        public _FinalStage startTime(String var1);

        public _FinalStage endTime(Optional<String> var1);

        public _FinalStage endTime(String var1);

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);

        public _FinalStage offset(Optional<Integer> var1);

        public _FinalStage offset(Integer var1);
    }

    public static interface PeriodStage {
        public _FinalStage period(@NotNull CountCreditLedgerRequestPeriod var1);
    }

    public static interface CompanyIdStage {
        public PeriodStage companyId(@NotNull String var1);

        public Builder from(CountCreditLedgerRequest var1);
    }
}

