/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.credits.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.credits.types.CreateBillingPlanCreditGrantRequestBodyExpiryType;
import com.schematic.api.resources.credits.types.CreateBillingPlanCreditGrantRequestBodyExpiryUnit;
import com.schematic.api.resources.credits.types.CreateBillingPlanCreditGrantRequestBodyResetCadence;
import com.schematic.api.resources.credits.types.CreateBillingPlanCreditGrantRequestBodyResetStart;
import com.schematic.api.resources.credits.types.CreateBillingPlanCreditGrantRequestBodyResetType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateBillingPlanCreditGrantRequestBody {
    private final int creditAmount;
    private final String creditId;
    private final Optional<CreateBillingPlanCreditGrantRequestBodyExpiryType> expiryType;
    private final Optional<CreateBillingPlanCreditGrantRequestBodyExpiryUnit> expiryUnit;
    private final Optional<Integer> expiryUnitCount;
    private final String planId;
    private final CreateBillingPlanCreditGrantRequestBodyResetCadence resetCadence;
    private final CreateBillingPlanCreditGrantRequestBodyResetStart resetStart;
    private final Optional<CreateBillingPlanCreditGrantRequestBodyResetType> resetType;
    private final Map<String, Object> additionalProperties;

    private CreateBillingPlanCreditGrantRequestBody(int creditAmount, String creditId, Optional<CreateBillingPlanCreditGrantRequestBodyExpiryType> expiryType, Optional<CreateBillingPlanCreditGrantRequestBodyExpiryUnit> expiryUnit, Optional<Integer> expiryUnitCount, String planId, CreateBillingPlanCreditGrantRequestBodyResetCadence resetCadence, CreateBillingPlanCreditGrantRequestBodyResetStart resetStart, Optional<CreateBillingPlanCreditGrantRequestBodyResetType> resetType, Map<String, Object> additionalProperties) {
        this.creditAmount = creditAmount;
        this.creditId = creditId;
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.planId = planId;
        this.resetCadence = resetCadence;
        this.resetStart = resetStart;
        this.resetType = resetType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="credit_amount")
    public int getCreditAmount() {
        return this.creditAmount;
    }

    @JsonProperty(value="credit_id")
    public String getCreditId() {
        return this.creditId;
    }

    @JsonProperty(value="expiry_type")
    public Optional<CreateBillingPlanCreditGrantRequestBodyExpiryType> getExpiryType() {
        return this.expiryType;
    }

    @JsonProperty(value="expiry_unit")
    public Optional<CreateBillingPlanCreditGrantRequestBodyExpiryUnit> getExpiryUnit() {
        return this.expiryUnit;
    }

    @JsonProperty(value="expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return this.expiryUnitCount;
    }

    @JsonProperty(value="plan_id")
    public String getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="reset_cadence")
    public CreateBillingPlanCreditGrantRequestBodyResetCadence getResetCadence() {
        return this.resetCadence;
    }

    @JsonProperty(value="reset_start")
    public CreateBillingPlanCreditGrantRequestBodyResetStart getResetStart() {
        return this.resetStart;
    }

    @JsonProperty(value="reset_type")
    public Optional<CreateBillingPlanCreditGrantRequestBodyResetType> getResetType() {
        return this.resetType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateBillingPlanCreditGrantRequestBody && this.equalTo((CreateBillingPlanCreditGrantRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBillingPlanCreditGrantRequestBody other) {
        return this.creditAmount == other.creditAmount && this.creditId.equals(other.creditId) && this.expiryType.equals(other.expiryType) && this.expiryUnit.equals(other.expiryUnit) && this.expiryUnitCount.equals(other.expiryUnitCount) && this.planId.equals(other.planId) && this.resetCadence.equals(other.resetCadence) && this.resetStart.equals(other.resetStart) && this.resetType.equals(other.resetType);
    }

    public int hashCode() {
        return Objects.hash(this.creditAmount, this.creditId, this.expiryType, this.expiryUnit, this.expiryUnitCount, this.planId, this.resetCadence, this.resetStart, this.resetType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreditAmountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreditAmountStage,
    CreditIdStage,
    PlanIdStage,
    ResetCadenceStage,
    ResetStartStage,
    _FinalStage {
        private int creditAmount;
        private String creditId;
        private String planId;
        private CreateBillingPlanCreditGrantRequestBodyResetCadence resetCadence;
        private CreateBillingPlanCreditGrantRequestBodyResetStart resetStart;
        private Optional<CreateBillingPlanCreditGrantRequestBodyResetType> resetType = Optional.empty();
        private Optional<Integer> expiryUnitCount = Optional.empty();
        private Optional<CreateBillingPlanCreditGrantRequestBodyExpiryUnit> expiryUnit = Optional.empty();
        private Optional<CreateBillingPlanCreditGrantRequestBodyExpiryType> expiryType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateBillingPlanCreditGrantRequestBody other) {
            this.creditAmount(other.getCreditAmount());
            this.creditId(other.getCreditId());
            this.expiryType(other.getExpiryType());
            this.expiryUnit(other.getExpiryUnit());
            this.expiryUnitCount(other.getExpiryUnitCount());
            this.planId(other.getPlanId());
            this.resetCadence(other.getResetCadence());
            this.resetStart(other.getResetStart());
            this.resetType(other.getResetType());
            return this;
        }

        @Override
        @JsonSetter(value="credit_amount")
        public CreditIdStage creditAmount(int creditAmount) {
            this.creditAmount = creditAmount;
            return this;
        }

        @Override
        @JsonSetter(value="credit_id")
        public PlanIdStage creditId(@NotNull String creditId) {
            this.creditId = Objects.requireNonNull(creditId, "creditId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="plan_id")
        public ResetCadenceStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reset_cadence")
        public ResetStartStage resetCadence(@NotNull CreateBillingPlanCreditGrantRequestBodyResetCadence resetCadence) {
            this.resetCadence = Objects.requireNonNull(resetCadence, "resetCadence must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reset_start")
        public _FinalStage resetStart(@NotNull CreateBillingPlanCreditGrantRequestBodyResetStart resetStart) {
            this.resetStart = Objects.requireNonNull(resetStart, "resetStart must not be null");
            return this;
        }

        @Override
        public _FinalStage resetType(CreateBillingPlanCreditGrantRequestBodyResetType resetType) {
            this.resetType = Optional.ofNullable(resetType);
            return this;
        }

        @Override
        @JsonSetter(value="reset_type", nulls=Nulls.SKIP)
        public _FinalStage resetType(Optional<CreateBillingPlanCreditGrantRequestBodyResetType> resetType) {
            this.resetType = resetType;
            return this;
        }

        @Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_unit_count", nulls=Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @Override
        public _FinalStage expiryUnit(CreateBillingPlanCreditGrantRequestBodyExpiryUnit expiryUnit) {
            this.expiryUnit = Optional.ofNullable(expiryUnit);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_unit", nulls=Nulls.SKIP)
        public _FinalStage expiryUnit(Optional<CreateBillingPlanCreditGrantRequestBodyExpiryUnit> expiryUnit) {
            this.expiryUnit = expiryUnit;
            return this;
        }

        @Override
        public _FinalStage expiryType(CreateBillingPlanCreditGrantRequestBodyExpiryType expiryType) {
            this.expiryType = Optional.ofNullable(expiryType);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_type", nulls=Nulls.SKIP)
        public _FinalStage expiryType(Optional<CreateBillingPlanCreditGrantRequestBodyExpiryType> expiryType) {
            this.expiryType = expiryType;
            return this;
        }

        @Override
        public CreateBillingPlanCreditGrantRequestBody build() {
            return new CreateBillingPlanCreditGrantRequestBody(this.creditAmount, this.creditId, this.expiryType, this.expiryUnit, this.expiryUnitCount, this.planId, this.resetCadence, this.resetStart, this.resetType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateBillingPlanCreditGrantRequestBody build();

        public _FinalStage expiryType(Optional<CreateBillingPlanCreditGrantRequestBodyExpiryType> var1);

        public _FinalStage expiryType(CreateBillingPlanCreditGrantRequestBodyExpiryType var1);

        public _FinalStage expiryUnit(Optional<CreateBillingPlanCreditGrantRequestBodyExpiryUnit> var1);

        public _FinalStage expiryUnit(CreateBillingPlanCreditGrantRequestBodyExpiryUnit var1);

        public _FinalStage expiryUnitCount(Optional<Integer> var1);

        public _FinalStage expiryUnitCount(Integer var1);

        public _FinalStage resetType(Optional<CreateBillingPlanCreditGrantRequestBodyResetType> var1);

        public _FinalStage resetType(CreateBillingPlanCreditGrantRequestBodyResetType var1);
    }

    public static interface ResetStartStage {
        public _FinalStage resetStart(@NotNull CreateBillingPlanCreditGrantRequestBodyResetStart var1);
    }

    public static interface ResetCadenceStage {
        public ResetStartStage resetCadence(@NotNull CreateBillingPlanCreditGrantRequestBodyResetCadence var1);
    }

    public static interface PlanIdStage {
        public ResetCadenceStage planId(@NotNull String var1);
    }

    public static interface CreditIdStage {
        public PlanIdStage creditId(@NotNull String var1);
    }

    public static interface CreditAmountStage {
        public CreditIdStage creditAmount(int var1);

        public Builder from(CreateBillingPlanCreditGrantRequestBody var1);
    }
}

