/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.credits.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.credits.types.CreateCompanyCreditGrantExpiryType;
import com.schematic.api.resources.credits.types.CreateCompanyCreditGrantExpiryUnit;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCompanyCreditGrant {
    private final Optional<Integer> billingPeriodsCount;
    private final String companyId;
    private final String creditId;
    private final Optional<OffsetDateTime> expiresAt;
    private final Optional<CreateCompanyCreditGrantExpiryType> expiryType;
    private final Optional<CreateCompanyCreditGrantExpiryUnit> expiryUnit;
    private final Optional<Integer> expiryUnitCount;
    private final int quantity;
    private final String reason;
    private final Map<String, Object> additionalProperties;

    private CreateCompanyCreditGrant(Optional<Integer> billingPeriodsCount, String companyId, String creditId, Optional<OffsetDateTime> expiresAt, Optional<CreateCompanyCreditGrantExpiryType> expiryType, Optional<CreateCompanyCreditGrantExpiryUnit> expiryUnit, Optional<Integer> expiryUnitCount, int quantity, String reason, Map<String, Object> additionalProperties) {
        this.billingPeriodsCount = billingPeriodsCount;
        this.companyId = companyId;
        this.creditId = creditId;
        this.expiresAt = expiresAt;
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.quantity = quantity;
        this.reason = reason;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="billing_periods_count")
    public Optional<Integer> getBillingPeriodsCount() {
        return this.billingPeriodsCount;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="credit_id")
    public String getCreditId() {
        return this.creditId;
    }

    @JsonProperty(value="expires_at")
    public Optional<OffsetDateTime> getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiry_type")
    public Optional<CreateCompanyCreditGrantExpiryType> getExpiryType() {
        return this.expiryType;
    }

    @JsonProperty(value="expiry_unit")
    public Optional<CreateCompanyCreditGrantExpiryUnit> getExpiryUnit() {
        return this.expiryUnit;
    }

    @JsonProperty(value="expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return this.expiryUnitCount;
    }

    @JsonProperty(value="quantity")
    public int getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCompanyCreditGrant && this.equalTo((CreateCompanyCreditGrant)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCompanyCreditGrant other) {
        return this.billingPeriodsCount.equals(other.billingPeriodsCount) && this.companyId.equals(other.companyId) && this.creditId.equals(other.creditId) && this.expiresAt.equals(other.expiresAt) && this.expiryType.equals(other.expiryType) && this.expiryUnit.equals(other.expiryUnit) && this.expiryUnitCount.equals(other.expiryUnitCount) && this.quantity == other.quantity && this.reason.equals(other.reason);
    }

    public int hashCode() {
        return Objects.hash(this.billingPeriodsCount, this.companyId, this.creditId, this.expiresAt, this.expiryType, this.expiryUnit, this.expiryUnitCount, this.quantity, this.reason);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CompanyIdStage,
    CreditIdStage,
    QuantityStage,
    ReasonStage,
    _FinalStage {
        private String companyId;
        private String creditId;
        private int quantity;
        private String reason;
        private Optional<Integer> expiryUnitCount = Optional.empty();
        private Optional<CreateCompanyCreditGrantExpiryUnit> expiryUnit = Optional.empty();
        private Optional<CreateCompanyCreditGrantExpiryType> expiryType = Optional.empty();
        private Optional<OffsetDateTime> expiresAt = Optional.empty();
        private Optional<Integer> billingPeriodsCount = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateCompanyCreditGrant other) {
            this.billingPeriodsCount(other.getBillingPeriodsCount());
            this.companyId(other.getCompanyId());
            this.creditId(other.getCreditId());
            this.expiresAt(other.getExpiresAt());
            this.expiryType(other.getExpiryType());
            this.expiryUnit(other.getExpiryUnit());
            this.expiryUnitCount(other.getExpiryUnitCount());
            this.quantity(other.getQuantity());
            this.reason(other.getReason());
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public CreditIdStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="credit_id")
        public QuantityStage creditId(@NotNull String creditId) {
            this.creditId = Objects.requireNonNull(creditId, "creditId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public ReasonStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        @JsonSetter(value="reason")
        public _FinalStage reason(@NotNull String reason) {
            this.reason = Objects.requireNonNull(reason, "reason must not be null");
            return this;
        }

        @Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_unit_count", nulls=Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @Override
        public _FinalStage expiryUnit(CreateCompanyCreditGrantExpiryUnit expiryUnit) {
            this.expiryUnit = Optional.ofNullable(expiryUnit);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_unit", nulls=Nulls.SKIP)
        public _FinalStage expiryUnit(Optional<CreateCompanyCreditGrantExpiryUnit> expiryUnit) {
            this.expiryUnit = expiryUnit;
            return this;
        }

        @Override
        public _FinalStage expiryType(CreateCompanyCreditGrantExpiryType expiryType) {
            this.expiryType = Optional.ofNullable(expiryType);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_type", nulls=Nulls.SKIP)
        public _FinalStage expiryType(Optional<CreateCompanyCreditGrantExpiryType> expiryType) {
            this.expiryType = expiryType;
            return this;
        }

        @Override
        public _FinalStage expiresAt(OffsetDateTime expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        @Override
        @JsonSetter(value="expires_at", nulls=Nulls.SKIP)
        public _FinalStage expiresAt(Optional<OffsetDateTime> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public _FinalStage billingPeriodsCount(Integer billingPeriodsCount) {
            this.billingPeriodsCount = Optional.ofNullable(billingPeriodsCount);
            return this;
        }

        @Override
        @JsonSetter(value="billing_periods_count", nulls=Nulls.SKIP)
        public _FinalStage billingPeriodsCount(Optional<Integer> billingPeriodsCount) {
            this.billingPeriodsCount = billingPeriodsCount;
            return this;
        }

        @Override
        public CreateCompanyCreditGrant build() {
            return new CreateCompanyCreditGrant(this.billingPeriodsCount, this.companyId, this.creditId, this.expiresAt, this.expiryType, this.expiryUnit, this.expiryUnitCount, this.quantity, this.reason, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateCompanyCreditGrant build();

        public _FinalStage billingPeriodsCount(Optional<Integer> var1);

        public _FinalStage billingPeriodsCount(Integer var1);

        public _FinalStage expiresAt(Optional<OffsetDateTime> var1);

        public _FinalStage expiresAt(OffsetDateTime var1);

        public _FinalStage expiryType(Optional<CreateCompanyCreditGrantExpiryType> var1);

        public _FinalStage expiryType(CreateCompanyCreditGrantExpiryType var1);

        public _FinalStage expiryUnit(Optional<CreateCompanyCreditGrantExpiryUnit> var1);

        public _FinalStage expiryUnit(CreateCompanyCreditGrantExpiryUnit var1);

        public _FinalStage expiryUnitCount(Optional<Integer> var1);

        public _FinalStage expiryUnitCount(Integer var1);
    }

    public static interface ReasonStage {
        public _FinalStage reason(@NotNull String var1);
    }

    public static interface QuantityStage {
        public ReasonStage quantity(int var1);
    }

    public static interface CreditIdStage {
        public QuantityStage creditId(@NotNull String var1);
    }

    public static interface CompanyIdStage {
        public CreditIdStage companyId(@NotNull String var1);

        public Builder from(CreateCompanyCreditGrant var1);
    }
}

