/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.credits.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.credits.types.UpdateCreditBundleDetailsRequestBodyExpiryType;
import com.schematic.api.resources.credits.types.UpdateCreditBundleDetailsRequestBodyExpiryUnit;
import com.schematic.api.resources.credits.types.UpdateCreditBundleDetailsRequestBodyStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateCreditBundleDetailsRequestBody {
    private final String bundleName;
    private final Optional<UpdateCreditBundleDetailsRequestBodyExpiryType> expiryType;
    private final Optional<UpdateCreditBundleDetailsRequestBodyExpiryUnit> expiryUnit;
    private final Optional<Integer> expiryUnitCount;
    private final int pricePerUnit;
    private final Optional<String> pricePerUnitDecimal;
    private final Optional<Integer> quantity;
    private final Optional<UpdateCreditBundleDetailsRequestBodyStatus> status;
    private final Map<String, Object> additionalProperties;

    private UpdateCreditBundleDetailsRequestBody(String bundleName, Optional<UpdateCreditBundleDetailsRequestBodyExpiryType> expiryType, Optional<UpdateCreditBundleDetailsRequestBodyExpiryUnit> expiryUnit, Optional<Integer> expiryUnitCount, int pricePerUnit, Optional<String> pricePerUnitDecimal, Optional<Integer> quantity, Optional<UpdateCreditBundleDetailsRequestBodyStatus> status, Map<String, Object> additionalProperties) {
        this.bundleName = bundleName;
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.pricePerUnit = pricePerUnit;
        this.pricePerUnitDecimal = pricePerUnitDecimal;
        this.quantity = quantity;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="bundle_name")
    public String getBundleName() {
        return this.bundleName;
    }

    @JsonProperty(value="expiry_type")
    public Optional<UpdateCreditBundleDetailsRequestBodyExpiryType> getExpiryType() {
        return this.expiryType;
    }

    @JsonProperty(value="expiry_unit")
    public Optional<UpdateCreditBundleDetailsRequestBodyExpiryUnit> getExpiryUnit() {
        return this.expiryUnit;
    }

    @JsonProperty(value="expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return this.expiryUnitCount;
    }

    @JsonProperty(value="price_per_unit")
    public int getPricePerUnit() {
        return this.pricePerUnit;
    }

    @JsonProperty(value="price_per_unit_decimal")
    public Optional<String> getPricePerUnitDecimal() {
        return this.pricePerUnitDecimal;
    }

    @JsonProperty(value="quantity")
    public Optional<Integer> getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="status")
    public Optional<UpdateCreditBundleDetailsRequestBodyStatus> getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateCreditBundleDetailsRequestBody && this.equalTo((UpdateCreditBundleDetailsRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateCreditBundleDetailsRequestBody other) {
        return this.bundleName.equals(other.bundleName) && this.expiryType.equals(other.expiryType) && this.expiryUnit.equals(other.expiryUnit) && this.expiryUnitCount.equals(other.expiryUnitCount) && this.pricePerUnit == other.pricePerUnit && this.pricePerUnitDecimal.equals(other.pricePerUnitDecimal) && this.quantity.equals(other.quantity) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.bundleName, this.expiryType, this.expiryUnit, this.expiryUnitCount, this.pricePerUnit, this.pricePerUnitDecimal, this.quantity, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BundleNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BundleNameStage,
    PricePerUnitStage,
    _FinalStage {
        private String bundleName;
        private int pricePerUnit;
        private Optional<UpdateCreditBundleDetailsRequestBodyStatus> status = Optional.empty();
        private Optional<Integer> quantity = Optional.empty();
        private Optional<String> pricePerUnitDecimal = Optional.empty();
        private Optional<Integer> expiryUnitCount = Optional.empty();
        private Optional<UpdateCreditBundleDetailsRequestBodyExpiryUnit> expiryUnit = Optional.empty();
        private Optional<UpdateCreditBundleDetailsRequestBodyExpiryType> expiryType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateCreditBundleDetailsRequestBody other) {
            this.bundleName(other.getBundleName());
            this.expiryType(other.getExpiryType());
            this.expiryUnit(other.getExpiryUnit());
            this.expiryUnitCount(other.getExpiryUnitCount());
            this.pricePerUnit(other.getPricePerUnit());
            this.pricePerUnitDecimal(other.getPricePerUnitDecimal());
            this.quantity(other.getQuantity());
            this.status(other.getStatus());
            return this;
        }

        @Override
        @JsonSetter(value="bundle_name")
        public PricePerUnitStage bundleName(@NotNull String bundleName) {
            this.bundleName = Objects.requireNonNull(bundleName, "bundleName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price_per_unit")
        public _FinalStage pricePerUnit(int pricePerUnit) {
            this.pricePerUnit = pricePerUnit;
            return this;
        }

        @Override
        public _FinalStage status(UpdateCreditBundleDetailsRequestBodyStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<UpdateCreditBundleDetailsRequestBodyStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage quantity(Integer quantity) {
            this.quantity = Optional.ofNullable(quantity);
            return this;
        }

        @Override
        @JsonSetter(value="quantity", nulls=Nulls.SKIP)
        public _FinalStage quantity(Optional<Integer> quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public _FinalStage pricePerUnitDecimal(String pricePerUnitDecimal) {
            this.pricePerUnitDecimal = Optional.ofNullable(pricePerUnitDecimal);
            return this;
        }

        @Override
        @JsonSetter(value="price_per_unit_decimal", nulls=Nulls.SKIP)
        public _FinalStage pricePerUnitDecimal(Optional<String> pricePerUnitDecimal) {
            this.pricePerUnitDecimal = pricePerUnitDecimal;
            return this;
        }

        @Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_unit_count", nulls=Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @Override
        public _FinalStage expiryUnit(UpdateCreditBundleDetailsRequestBodyExpiryUnit expiryUnit) {
            this.expiryUnit = Optional.ofNullable(expiryUnit);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_unit", nulls=Nulls.SKIP)
        public _FinalStage expiryUnit(Optional<UpdateCreditBundleDetailsRequestBodyExpiryUnit> expiryUnit) {
            this.expiryUnit = expiryUnit;
            return this;
        }

        @Override
        public _FinalStage expiryType(UpdateCreditBundleDetailsRequestBodyExpiryType expiryType) {
            this.expiryType = Optional.ofNullable(expiryType);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_type", nulls=Nulls.SKIP)
        public _FinalStage expiryType(Optional<UpdateCreditBundleDetailsRequestBodyExpiryType> expiryType) {
            this.expiryType = expiryType;
            return this;
        }

        @Override
        public UpdateCreditBundleDetailsRequestBody build() {
            return new UpdateCreditBundleDetailsRequestBody(this.bundleName, this.expiryType, this.expiryUnit, this.expiryUnitCount, this.pricePerUnit, this.pricePerUnitDecimal, this.quantity, this.status, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateCreditBundleDetailsRequestBody build();

        public _FinalStage expiryType(Optional<UpdateCreditBundleDetailsRequestBodyExpiryType> var1);

        public _FinalStage expiryType(UpdateCreditBundleDetailsRequestBodyExpiryType var1);

        public _FinalStage expiryUnit(Optional<UpdateCreditBundleDetailsRequestBodyExpiryUnit> var1);

        public _FinalStage expiryUnit(UpdateCreditBundleDetailsRequestBodyExpiryUnit var1);

        public _FinalStage expiryUnitCount(Optional<Integer> var1);

        public _FinalStage expiryUnitCount(Integer var1);

        public _FinalStage pricePerUnitDecimal(Optional<String> var1);

        public _FinalStage pricePerUnitDecimal(String var1);

        public _FinalStage quantity(Optional<Integer> var1);

        public _FinalStage quantity(Integer var1);

        public _FinalStage status(Optional<UpdateCreditBundleDetailsRequestBodyStatus> var1);

        public _FinalStage status(UpdateCreditBundleDetailsRequestBodyStatus var1);
    }

    public static interface PricePerUnitStage {
        public _FinalStage pricePerUnit(int var1);
    }

    public static interface BundleNameStage {
        public PricePerUnitStage bundleName(@NotNull String var1);

        public Builder from(UpdateCreditBundleDetailsRequestBody var1);
    }
}

