/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.credits.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.credits.types.CountCreditBundlesResponseParamsStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CountCreditBundlesParams {
    private final Optional<String> bundleType;
    private final Optional<String> creditId;
    private final Optional<List<String>> ids;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Optional<CountCreditBundlesResponseParamsStatus> status;
    private final Map<String, Object> additionalProperties;

    private CountCreditBundlesParams(Optional<String> bundleType, Optional<String> creditId, Optional<List<String>> ids, Optional<Integer> limit, Optional<Integer> offset, Optional<CountCreditBundlesResponseParamsStatus> status, Map<String, Object> additionalProperties) {
        this.bundleType = bundleType;
        this.creditId = creditId;
        this.ids = ids;
        this.limit = limit;
        this.offset = offset;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="bundle_type")
    public Optional<String> getBundleType() {
        return this.bundleType;
    }

    @JsonProperty(value="credit_id")
    public Optional<String> getCreditId() {
        return this.creditId;
    }

    @JsonProperty(value="ids")
    public Optional<List<String>> getIds() {
        return this.ids;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    @JsonProperty(value="status")
    public Optional<CountCreditBundlesResponseParamsStatus> getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CountCreditBundlesParams && this.equalTo((CountCreditBundlesParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CountCreditBundlesParams other) {
        return this.bundleType.equals(other.bundleType) && this.creditId.equals(other.creditId) && this.ids.equals(other.ids) && this.limit.equals(other.limit) && this.offset.equals(other.offset) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.bundleType, this.creditId, this.ids, this.limit, this.offset, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> bundleType = Optional.empty();
        private Optional<String> creditId = Optional.empty();
        private Optional<List<String>> ids = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        private Optional<CountCreditBundlesResponseParamsStatus> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CountCreditBundlesParams other) {
            this.bundleType(other.getBundleType());
            this.creditId(other.getCreditId());
            this.ids(other.getIds());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            this.status(other.getStatus());
            return this;
        }

        @JsonSetter(value="bundle_type", nulls=Nulls.SKIP)
        public Builder bundleType(Optional<String> bundleType) {
            this.bundleType = bundleType;
            return this;
        }

        public Builder bundleType(String bundleType) {
            this.bundleType = Optional.ofNullable(bundleType);
            return this;
        }

        @JsonSetter(value="credit_id", nulls=Nulls.SKIP)
        public Builder creditId(Optional<String> creditId) {
            this.creditId = creditId;
            return this;
        }

        public Builder creditId(String creditId) {
            this.creditId = Optional.ofNullable(creditId);
            return this;
        }

        @JsonSetter(value="ids", nulls=Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<CountCreditBundlesResponseParamsStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(CountCreditBundlesResponseParamsStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        public CountCreditBundlesParams build() {
            return new CountCreditBundlesParams(this.bundleType, this.creditId, this.ids, this.limit, this.offset, this.status, this.additionalProperties);
        }
    }
}

