/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.credits.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListBillingPlanCreditGrantsParams {
    private final Optional<String> creditId;
    private final Optional<List<String>> ids;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Optional<String> planId;
    private final Optional<List<String>> planIds;
    private final Map<String, Object> additionalProperties;

    private ListBillingPlanCreditGrantsParams(Optional<String> creditId, Optional<List<String>> ids, Optional<Integer> limit, Optional<Integer> offset, Optional<String> planId, Optional<List<String>> planIds, Map<String, Object> additionalProperties) {
        this.creditId = creditId;
        this.ids = ids;
        this.limit = limit;
        this.offset = offset;
        this.planId = planId;
        this.planIds = planIds;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="credit_id")
    public Optional<String> getCreditId() {
        return this.creditId;
    }

    @JsonProperty(value="ids")
    public Optional<List<String>> getIds() {
        return this.ids;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    @JsonProperty(value="plan_id")
    public Optional<String> getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="plan_ids")
    public Optional<List<String>> getPlanIds() {
        return this.planIds;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListBillingPlanCreditGrantsParams && this.equalTo((ListBillingPlanCreditGrantsParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListBillingPlanCreditGrantsParams other) {
        return this.creditId.equals(other.creditId) && this.ids.equals(other.ids) && this.limit.equals(other.limit) && this.offset.equals(other.offset) && this.planId.equals(other.planId) && this.planIds.equals(other.planIds);
    }

    public int hashCode() {
        return Objects.hash(this.creditId, this.ids, this.limit, this.offset, this.planId, this.planIds);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> creditId = Optional.empty();
        private Optional<List<String>> ids = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        private Optional<String> planId = Optional.empty();
        private Optional<List<String>> planIds = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListBillingPlanCreditGrantsParams other) {
            this.creditId(other.getCreditId());
            this.ids(other.getIds());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            this.planId(other.getPlanId());
            this.planIds(other.getPlanIds());
            return this;
        }

        @JsonSetter(value="credit_id", nulls=Nulls.SKIP)
        public Builder creditId(Optional<String> creditId) {
            this.creditId = creditId;
            return this;
        }

        public Builder creditId(String creditId) {
            this.creditId = Optional.ofNullable(creditId);
            return this;
        }

        @JsonSetter(value="ids", nulls=Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value="plan_id", nulls=Nulls.SKIP)
        public Builder planId(Optional<String> planId) {
            this.planId = planId;
            return this;
        }

        public Builder planId(String planId) {
            this.planId = Optional.ofNullable(planId);
            return this;
        }

        @JsonSetter(value="plan_ids", nulls=Nulls.SKIP)
        public Builder planIds(Optional<List<String>> planIds) {
            this.planIds = planIds;
            return this;
        }

        public Builder planIds(List<String> planIds) {
            this.planIds = Optional.ofNullable(planIds);
            return this;
        }

        public ListBillingPlanCreditGrantsParams build() {
            return new ListBillingPlanCreditGrantsParams(this.creditId, this.ids, this.limit, this.offset, this.planId, this.planIds, this.additionalProperties);
        }
    }
}

