/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.crm;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.crm.AsyncRawCrmClient;
import com.schematic.api.resources.crm.requests.CreateCrmDealLineItemAssociationRequestBody;
import com.schematic.api.resources.crm.requests.CreateCrmDealRequestBody;
import com.schematic.api.resources.crm.requests.CreateCrmLineItemRequestBody;
import com.schematic.api.resources.crm.requests.CreateCrmProductRequestBody;
import com.schematic.api.resources.crm.requests.ListCrmProductsRequest;
import com.schematic.api.resources.crm.types.ListCrmProductsResponse;
import com.schematic.api.resources.crm.types.UpsertCrmDealResponse;
import com.schematic.api.resources.crm.types.UpsertCrmProductResponse;
import com.schematic.api.resources.crm.types.UpsertDealLineItemAssociationResponse;
import com.schematic.api.resources.crm.types.UpsertLineItemResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCrmClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCrmClient rawClient;

    public AsyncCrmClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCrmClient(clientOptions);
    }

    public AsyncRawCrmClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<UpsertDealLineItemAssociationResponse> upsertDealLineItemAssociation(CreateCrmDealLineItemAssociationRequestBody request) {
        return this.rawClient.upsertDealLineItemAssociation(request).thenApply(response -> (UpsertDealLineItemAssociationResponse)response.body());
    }

    public CompletableFuture<UpsertDealLineItemAssociationResponse> upsertDealLineItemAssociation(CreateCrmDealLineItemAssociationRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertDealLineItemAssociation(request, requestOptions).thenApply(response -> (UpsertDealLineItemAssociationResponse)response.body());
    }

    public CompletableFuture<UpsertLineItemResponse> upsertLineItem(CreateCrmLineItemRequestBody request) {
        return this.rawClient.upsertLineItem(request).thenApply(response -> (UpsertLineItemResponse)response.body());
    }

    public CompletableFuture<UpsertLineItemResponse> upsertLineItem(CreateCrmLineItemRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertLineItem(request, requestOptions).thenApply(response -> (UpsertLineItemResponse)response.body());
    }

    public CompletableFuture<UpsertCrmDealResponse> upsertCrmDeal(CreateCrmDealRequestBody request) {
        return this.rawClient.upsertCrmDeal(request).thenApply(response -> (UpsertCrmDealResponse)response.body());
    }

    public CompletableFuture<UpsertCrmDealResponse> upsertCrmDeal(CreateCrmDealRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertCrmDeal(request, requestOptions).thenApply(response -> (UpsertCrmDealResponse)response.body());
    }

    public CompletableFuture<ListCrmProductsResponse> listCrmProducts() {
        return this.rawClient.listCrmProducts().thenApply(response -> (ListCrmProductsResponse)response.body());
    }

    public CompletableFuture<ListCrmProductsResponse> listCrmProducts(ListCrmProductsRequest request) {
        return this.rawClient.listCrmProducts(request).thenApply(response -> (ListCrmProductsResponse)response.body());
    }

    public CompletableFuture<ListCrmProductsResponse> listCrmProducts(ListCrmProductsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCrmProducts(request, requestOptions).thenApply(response -> (ListCrmProductsResponse)response.body());
    }

    public CompletableFuture<UpsertCrmProductResponse> upsertCrmProduct(CreateCrmProductRequestBody request) {
        return this.rawClient.upsertCrmProduct(request).thenApply(response -> (UpsertCrmProductResponse)response.body());
    }

    public CompletableFuture<UpsertCrmProductResponse> upsertCrmProduct(CreateCrmProductRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertCrmProduct(request, requestOptions).thenApply(response -> (UpsertCrmProductResponse)response.body());
    }
}

