/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.dataexports.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateDataExportRequestBody {
    private final String metadata;
    private final Map<String, Object> additionalProperties;

    private CreateDataExportRequestBody(String metadata, Map<String, Object> additionalProperties) {
        this.metadata = metadata;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="export_type")
    public String getExportType() {
        return "company-feature-usage";
    }

    @JsonProperty(value="metadata")
    public String getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="output_file_type")
    public String getOutputFileType() {
        return "csv";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateDataExportRequestBody && this.equalTo((CreateDataExportRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateDataExportRequestBody other) {
        return this.metadata.equals(other.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.metadata);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MetadataStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MetadataStage,
    _FinalStage {
        private String metadata;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateDataExportRequestBody other) {
            this.metadata(other.getMetadata());
            return this;
        }

        @Override
        @JsonSetter(value="metadata")
        public _FinalStage metadata(@NotNull String metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata must not be null");
            return this;
        }

        @Override
        public CreateDataExportRequestBody build() {
            return new CreateDataExportRequestBody(this.metadata, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateDataExportRequestBody build();
    }

    public static interface MetadataStage {
        public _FinalStage metadata(@NotNull String var1);

        public Builder from(CreateDataExportRequestBody var1);
    }
}

