/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.entitlements;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.entitlements.AsyncRawEntitlementsClient;
import com.schematic.api.resources.entitlements.requests.CountCompanyOverridesRequest;
import com.schematic.api.resources.entitlements.requests.CountFeatureCompaniesRequest;
import com.schematic.api.resources.entitlements.requests.CountFeatureUsageRequest;
import com.schematic.api.resources.entitlements.requests.CountFeatureUsersRequest;
import com.schematic.api.resources.entitlements.requests.CountPlanEntitlementsRequest;
import com.schematic.api.resources.entitlements.requests.CreateCompanyOverrideRequestBody;
import com.schematic.api.resources.entitlements.requests.CreatePlanEntitlementRequestBody;
import com.schematic.api.resources.entitlements.requests.GetFeatureUsageByCompanyRequest;
import com.schematic.api.resources.entitlements.requests.ListCompanyOverridesRequest;
import com.schematic.api.resources.entitlements.requests.ListFeatureCompaniesRequest;
import com.schematic.api.resources.entitlements.requests.ListFeatureUsageRequest;
import com.schematic.api.resources.entitlements.requests.ListFeatureUsersRequest;
import com.schematic.api.resources.entitlements.requests.ListPlanEntitlementsRequest;
import com.schematic.api.resources.entitlements.requests.UpdateCompanyOverrideRequestBody;
import com.schematic.api.resources.entitlements.requests.UpdatePlanEntitlementRequestBody;
import com.schematic.api.resources.entitlements.types.CountCompanyOverridesResponse;
import com.schematic.api.resources.entitlements.types.CountFeatureCompaniesResponse;
import com.schematic.api.resources.entitlements.types.CountFeatureUsageResponse;
import com.schematic.api.resources.entitlements.types.CountFeatureUsersResponse;
import com.schematic.api.resources.entitlements.types.CountPlanEntitlementsResponse;
import com.schematic.api.resources.entitlements.types.CreateCompanyOverrideResponse;
import com.schematic.api.resources.entitlements.types.CreatePlanEntitlementResponse;
import com.schematic.api.resources.entitlements.types.DeleteCompanyOverrideResponse;
import com.schematic.api.resources.entitlements.types.DeletePlanEntitlementResponse;
import com.schematic.api.resources.entitlements.types.GetCompanyOverrideResponse;
import com.schematic.api.resources.entitlements.types.GetFeatureUsageByCompanyResponse;
import com.schematic.api.resources.entitlements.types.GetPlanEntitlementResponse;
import com.schematic.api.resources.entitlements.types.ListCompanyOverridesResponse;
import com.schematic.api.resources.entitlements.types.ListFeatureCompaniesResponse;
import com.schematic.api.resources.entitlements.types.ListFeatureUsageResponse;
import com.schematic.api.resources.entitlements.types.ListFeatureUsersResponse;
import com.schematic.api.resources.entitlements.types.ListPlanEntitlementsResponse;
import com.schematic.api.resources.entitlements.types.UpdateCompanyOverrideResponse;
import com.schematic.api.resources.entitlements.types.UpdatePlanEntitlementResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncEntitlementsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawEntitlementsClient rawClient;

    public AsyncEntitlementsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawEntitlementsClient(clientOptions);
    }

    public AsyncRawEntitlementsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListCompanyOverridesResponse> listCompanyOverrides() {
        return this.rawClient.listCompanyOverrides().thenApply(response -> (ListCompanyOverridesResponse)response.body());
    }

    public CompletableFuture<ListCompanyOverridesResponse> listCompanyOverrides(ListCompanyOverridesRequest request) {
        return this.rawClient.listCompanyOverrides(request).thenApply(response -> (ListCompanyOverridesResponse)response.body());
    }

    public CompletableFuture<ListCompanyOverridesResponse> listCompanyOverrides(ListCompanyOverridesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompanyOverrides(request, requestOptions).thenApply(response -> (ListCompanyOverridesResponse)response.body());
    }

    public CompletableFuture<CreateCompanyOverrideResponse> createCompanyOverride(CreateCompanyOverrideRequestBody request) {
        return this.rawClient.createCompanyOverride(request).thenApply(response -> (CreateCompanyOverrideResponse)response.body());
    }

    public CompletableFuture<CreateCompanyOverrideResponse> createCompanyOverride(CreateCompanyOverrideRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createCompanyOverride(request, requestOptions).thenApply(response -> (CreateCompanyOverrideResponse)response.body());
    }

    public CompletableFuture<GetCompanyOverrideResponse> getCompanyOverride(String companyOverrideId) {
        return this.rawClient.getCompanyOverride(companyOverrideId).thenApply(response -> (GetCompanyOverrideResponse)response.body());
    }

    public CompletableFuture<GetCompanyOverrideResponse> getCompanyOverride(String companyOverrideId, RequestOptions requestOptions) {
        return this.rawClient.getCompanyOverride(companyOverrideId, requestOptions).thenApply(response -> (GetCompanyOverrideResponse)response.body());
    }

    public CompletableFuture<UpdateCompanyOverrideResponse> updateCompanyOverride(String companyOverrideId, UpdateCompanyOverrideRequestBody request) {
        return this.rawClient.updateCompanyOverride(companyOverrideId, request).thenApply(response -> (UpdateCompanyOverrideResponse)response.body());
    }

    public CompletableFuture<UpdateCompanyOverrideResponse> updateCompanyOverride(String companyOverrideId, UpdateCompanyOverrideRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateCompanyOverride(companyOverrideId, request, requestOptions).thenApply(response -> (UpdateCompanyOverrideResponse)response.body());
    }

    public CompletableFuture<DeleteCompanyOverrideResponse> deleteCompanyOverride(String companyOverrideId) {
        return this.rawClient.deleteCompanyOverride(companyOverrideId).thenApply(response -> (DeleteCompanyOverrideResponse)response.body());
    }

    public CompletableFuture<DeleteCompanyOverrideResponse> deleteCompanyOverride(String companyOverrideId, RequestOptions requestOptions) {
        return this.rawClient.deleteCompanyOverride(companyOverrideId, requestOptions).thenApply(response -> (DeleteCompanyOverrideResponse)response.body());
    }

    public CompletableFuture<CountCompanyOverridesResponse> countCompanyOverrides() {
        return this.rawClient.countCompanyOverrides().thenApply(response -> (CountCompanyOverridesResponse)response.body());
    }

    public CompletableFuture<CountCompanyOverridesResponse> countCompanyOverrides(CountCompanyOverridesRequest request) {
        return this.rawClient.countCompanyOverrides(request).thenApply(response -> (CountCompanyOverridesResponse)response.body());
    }

    public CompletableFuture<CountCompanyOverridesResponse> countCompanyOverrides(CountCompanyOverridesRequest request, RequestOptions requestOptions) {
        return this.rawClient.countCompanyOverrides(request, requestOptions).thenApply(response -> (CountCompanyOverridesResponse)response.body());
    }

    public CompletableFuture<ListFeatureCompaniesResponse> listFeatureCompanies(ListFeatureCompaniesRequest request) {
        return this.rawClient.listFeatureCompanies(request).thenApply(response -> (ListFeatureCompaniesResponse)response.body());
    }

    public CompletableFuture<ListFeatureCompaniesResponse> listFeatureCompanies(ListFeatureCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listFeatureCompanies(request, requestOptions).thenApply(response -> (ListFeatureCompaniesResponse)response.body());
    }

    public CompletableFuture<CountFeatureCompaniesResponse> countFeatureCompanies(CountFeatureCompaniesRequest request) {
        return this.rawClient.countFeatureCompanies(request).thenApply(response -> (CountFeatureCompaniesResponse)response.body());
    }

    public CompletableFuture<CountFeatureCompaniesResponse> countFeatureCompanies(CountFeatureCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.countFeatureCompanies(request, requestOptions).thenApply(response -> (CountFeatureCompaniesResponse)response.body());
    }

    public CompletableFuture<ListFeatureUsageResponse> listFeatureUsage() {
        return this.rawClient.listFeatureUsage().thenApply(response -> (ListFeatureUsageResponse)response.body());
    }

    public CompletableFuture<ListFeatureUsageResponse> listFeatureUsage(ListFeatureUsageRequest request) {
        return this.rawClient.listFeatureUsage(request).thenApply(response -> (ListFeatureUsageResponse)response.body());
    }

    public CompletableFuture<ListFeatureUsageResponse> listFeatureUsage(ListFeatureUsageRequest request, RequestOptions requestOptions) {
        return this.rawClient.listFeatureUsage(request, requestOptions).thenApply(response -> (ListFeatureUsageResponse)response.body());
    }

    public CompletableFuture<CountFeatureUsageResponse> countFeatureUsage() {
        return this.rawClient.countFeatureUsage().thenApply(response -> (CountFeatureUsageResponse)response.body());
    }

    public CompletableFuture<CountFeatureUsageResponse> countFeatureUsage(CountFeatureUsageRequest request) {
        return this.rawClient.countFeatureUsage(request).thenApply(response -> (CountFeatureUsageResponse)response.body());
    }

    public CompletableFuture<CountFeatureUsageResponse> countFeatureUsage(CountFeatureUsageRequest request, RequestOptions requestOptions) {
        return this.rawClient.countFeatureUsage(request, requestOptions).thenApply(response -> (CountFeatureUsageResponse)response.body());
    }

    public CompletableFuture<ListFeatureUsersResponse> listFeatureUsers(ListFeatureUsersRequest request) {
        return this.rawClient.listFeatureUsers(request).thenApply(response -> (ListFeatureUsersResponse)response.body());
    }

    public CompletableFuture<ListFeatureUsersResponse> listFeatureUsers(ListFeatureUsersRequest request, RequestOptions requestOptions) {
        return this.rawClient.listFeatureUsers(request, requestOptions).thenApply(response -> (ListFeatureUsersResponse)response.body());
    }

    public CompletableFuture<CountFeatureUsersResponse> countFeatureUsers(CountFeatureUsersRequest request) {
        return this.rawClient.countFeatureUsers(request).thenApply(response -> (CountFeatureUsersResponse)response.body());
    }

    public CompletableFuture<CountFeatureUsersResponse> countFeatureUsers(CountFeatureUsersRequest request, RequestOptions requestOptions) {
        return this.rawClient.countFeatureUsers(request, requestOptions).thenApply(response -> (CountFeatureUsersResponse)response.body());
    }

    public CompletableFuture<ListPlanEntitlementsResponse> listPlanEntitlements() {
        return this.rawClient.listPlanEntitlements().thenApply(response -> (ListPlanEntitlementsResponse)response.body());
    }

    public CompletableFuture<ListPlanEntitlementsResponse> listPlanEntitlements(ListPlanEntitlementsRequest request) {
        return this.rawClient.listPlanEntitlements(request).thenApply(response -> (ListPlanEntitlementsResponse)response.body());
    }

    public CompletableFuture<ListPlanEntitlementsResponse> listPlanEntitlements(ListPlanEntitlementsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listPlanEntitlements(request, requestOptions).thenApply(response -> (ListPlanEntitlementsResponse)response.body());
    }

    public CompletableFuture<CreatePlanEntitlementResponse> createPlanEntitlement(CreatePlanEntitlementRequestBody request) {
        return this.rawClient.createPlanEntitlement(request).thenApply(response -> (CreatePlanEntitlementResponse)response.body());
    }

    public CompletableFuture<CreatePlanEntitlementResponse> createPlanEntitlement(CreatePlanEntitlementRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createPlanEntitlement(request, requestOptions).thenApply(response -> (CreatePlanEntitlementResponse)response.body());
    }

    public CompletableFuture<GetPlanEntitlementResponse> getPlanEntitlement(String planEntitlementId) {
        return this.rawClient.getPlanEntitlement(planEntitlementId).thenApply(response -> (GetPlanEntitlementResponse)response.body());
    }

    public CompletableFuture<GetPlanEntitlementResponse> getPlanEntitlement(String planEntitlementId, RequestOptions requestOptions) {
        return this.rawClient.getPlanEntitlement(planEntitlementId, requestOptions).thenApply(response -> (GetPlanEntitlementResponse)response.body());
    }

    public CompletableFuture<UpdatePlanEntitlementResponse> updatePlanEntitlement(String planEntitlementId, UpdatePlanEntitlementRequestBody request) {
        return this.rawClient.updatePlanEntitlement(planEntitlementId, request).thenApply(response -> (UpdatePlanEntitlementResponse)response.body());
    }

    public CompletableFuture<UpdatePlanEntitlementResponse> updatePlanEntitlement(String planEntitlementId, UpdatePlanEntitlementRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updatePlanEntitlement(planEntitlementId, request, requestOptions).thenApply(response -> (UpdatePlanEntitlementResponse)response.body());
    }

    public CompletableFuture<DeletePlanEntitlementResponse> deletePlanEntitlement(String planEntitlementId) {
        return this.rawClient.deletePlanEntitlement(planEntitlementId).thenApply(response -> (DeletePlanEntitlementResponse)response.body());
    }

    public CompletableFuture<DeletePlanEntitlementResponse> deletePlanEntitlement(String planEntitlementId, RequestOptions requestOptions) {
        return this.rawClient.deletePlanEntitlement(planEntitlementId, requestOptions).thenApply(response -> (DeletePlanEntitlementResponse)response.body());
    }

    public CompletableFuture<CountPlanEntitlementsResponse> countPlanEntitlements() {
        return this.rawClient.countPlanEntitlements().thenApply(response -> (CountPlanEntitlementsResponse)response.body());
    }

    public CompletableFuture<CountPlanEntitlementsResponse> countPlanEntitlements(CountPlanEntitlementsRequest request) {
        return this.rawClient.countPlanEntitlements(request).thenApply(response -> (CountPlanEntitlementsResponse)response.body());
    }

    public CompletableFuture<CountPlanEntitlementsResponse> countPlanEntitlements(CountPlanEntitlementsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countPlanEntitlements(request, requestOptions).thenApply(response -> (CountPlanEntitlementsResponse)response.body());
    }

    public CompletableFuture<GetFeatureUsageByCompanyResponse> getFeatureUsageByCompany(GetFeatureUsageByCompanyRequest request) {
        return this.rawClient.getFeatureUsageByCompany(request).thenApply(response -> (GetFeatureUsageByCompanyResponse)response.body());
    }

    public CompletableFuture<GetFeatureUsageByCompanyResponse> getFeatureUsageByCompany(GetFeatureUsageByCompanyRequest request, RequestOptions requestOptions) {
        return this.rawClient.getFeatureUsageByCompany(request, requestOptions).thenApply(response -> (GetFeatureUsageByCompanyResponse)response.body());
    }
}

