/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.entitlements;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.schematic.api.core.BaseSchematicApiException;
import com.schematic.api.core.BaseSchematicException;
import com.schematic.api.core.BaseSchematicHttpResponse;
import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.MediaTypes;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.core.QueryStringMapper;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.errors.BadRequestError;
import com.schematic.api.errors.ForbiddenError;
import com.schematic.api.errors.InternalServerError;
import com.schematic.api.errors.NotFoundError;
import com.schematic.api.errors.UnauthorizedError;
import com.schematic.api.resources.entitlements.requests.CountCompanyOverridesRequest;
import com.schematic.api.resources.entitlements.requests.CountFeatureCompaniesRequest;
import com.schematic.api.resources.entitlements.requests.CountFeatureUsageRequest;
import com.schematic.api.resources.entitlements.requests.CountFeatureUsersRequest;
import com.schematic.api.resources.entitlements.requests.CountPlanEntitlementsRequest;
import com.schematic.api.resources.entitlements.requests.CreateCompanyOverrideRequestBody;
import com.schematic.api.resources.entitlements.requests.CreatePlanEntitlementRequestBody;
import com.schematic.api.resources.entitlements.requests.GetFeatureUsageByCompanyRequest;
import com.schematic.api.resources.entitlements.requests.ListCompanyOverridesRequest;
import com.schematic.api.resources.entitlements.requests.ListFeatureCompaniesRequest;
import com.schematic.api.resources.entitlements.requests.ListFeatureUsageRequest;
import com.schematic.api.resources.entitlements.requests.ListFeatureUsersRequest;
import com.schematic.api.resources.entitlements.requests.ListPlanEntitlementsRequest;
import com.schematic.api.resources.entitlements.requests.UpdateCompanyOverrideRequestBody;
import com.schematic.api.resources.entitlements.requests.UpdatePlanEntitlementRequestBody;
import com.schematic.api.resources.entitlements.types.CountCompanyOverridesResponse;
import com.schematic.api.resources.entitlements.types.CountFeatureCompaniesResponse;
import com.schematic.api.resources.entitlements.types.CountFeatureUsageResponse;
import com.schematic.api.resources.entitlements.types.CountFeatureUsersResponse;
import com.schematic.api.resources.entitlements.types.CountPlanEntitlementsResponse;
import com.schematic.api.resources.entitlements.types.CreateCompanyOverrideResponse;
import com.schematic.api.resources.entitlements.types.CreatePlanEntitlementResponse;
import com.schematic.api.resources.entitlements.types.DeleteCompanyOverrideResponse;
import com.schematic.api.resources.entitlements.types.DeletePlanEntitlementResponse;
import com.schematic.api.resources.entitlements.types.GetCompanyOverrideResponse;
import com.schematic.api.resources.entitlements.types.GetFeatureUsageByCompanyResponse;
import com.schematic.api.resources.entitlements.types.GetPlanEntitlementResponse;
import com.schematic.api.resources.entitlements.types.ListCompanyOverridesResponse;
import com.schematic.api.resources.entitlements.types.ListFeatureCompaniesResponse;
import com.schematic.api.resources.entitlements.types.ListFeatureUsageResponse;
import com.schematic.api.resources.entitlements.types.ListFeatureUsersResponse;
import com.schematic.api.resources.entitlements.types.ListPlanEntitlementsResponse;
import com.schematic.api.resources.entitlements.types.UpdateCompanyOverrideResponse;
import com.schematic.api.resources.entitlements.types.UpdatePlanEntitlementResponse;
import com.schematic.api.types.ApiError;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawEntitlementsClient {
    protected final ClientOptions clientOptions;

    public RawEntitlementsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public BaseSchematicHttpResponse<ListCompanyOverridesResponse> listCompanyOverrides() {
        return this.listCompanyOverrides(ListCompanyOverridesRequest.builder().build());
    }

    public BaseSchematicHttpResponse<ListCompanyOverridesResponse> listCompanyOverrides(ListCompanyOverridesRequest request) {
        return this.listCompanyOverrides(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListCompanyOverridesResponse> listCompanyOverrides(ListCompanyOverridesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("company-overrides");
        if (request.getCompanyId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "company_id", request.getCompanyId().get(), false);
        }
        if (request.getFeatureId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "feature_id", request.getFeatureId().get(), false);
        }
        if (request.getWithoutExpired().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "without_expired", request.getWithoutExpired().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getCompanyIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "company_ids", request.getCompanyIds().get(), true);
        }
        if (request.getFeatureIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "feature_ids", request.getFeatureIds().get(), true);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListCompanyOverridesResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListCompanyOverridesResponse>((ListCompanyOverridesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListCompanyOverridesResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<CreateCompanyOverrideResponse> createCompanyOverride(CreateCompanyOverrideRequestBody request) {
        return this.createCompanyOverride(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<CreateCompanyOverrideResponse> createCompanyOverride(CreateCompanyOverrideRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("company-overrides").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<CreateCompanyOverrideResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<CreateCompanyOverrideResponse>((CreateCompanyOverrideResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateCompanyOverrideResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<GetCompanyOverrideResponse> getCompanyOverride(String companyOverrideId) {
        return this.getCompanyOverride(companyOverrideId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<GetCompanyOverrideResponse> getCompanyOverride(String companyOverrideId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("company-overrides").addPathSegment(companyOverrideId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<GetCompanyOverrideResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<GetCompanyOverrideResponse>((GetCompanyOverrideResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetCompanyOverrideResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<UpdateCompanyOverrideResponse> updateCompanyOverride(String companyOverrideId, UpdateCompanyOverrideRequestBody request) {
        return this.updateCompanyOverride(companyOverrideId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<UpdateCompanyOverrideResponse> updateCompanyOverride(String companyOverrideId, UpdateCompanyOverrideRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("company-overrides").addPathSegment(companyOverrideId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<UpdateCompanyOverrideResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<UpdateCompanyOverrideResponse>((UpdateCompanyOverrideResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdateCompanyOverrideResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<DeleteCompanyOverrideResponse> deleteCompanyOverride(String companyOverrideId) {
        return this.deleteCompanyOverride(companyOverrideId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<DeleteCompanyOverrideResponse> deleteCompanyOverride(String companyOverrideId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("company-overrides").addPathSegment(companyOverrideId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<DeleteCompanyOverrideResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<DeleteCompanyOverrideResponse>((DeleteCompanyOverrideResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteCompanyOverrideResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<CountCompanyOverridesResponse> countCompanyOverrides() {
        return this.countCompanyOverrides(CountCompanyOverridesRequest.builder().build());
    }

    public BaseSchematicHttpResponse<CountCompanyOverridesResponse> countCompanyOverrides(CountCompanyOverridesRequest request) {
        return this.countCompanyOverrides(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<CountCompanyOverridesResponse> countCompanyOverrides(CountCompanyOverridesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("company-overrides/count");
        if (request.getCompanyId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "company_id", request.getCompanyId().get(), false);
        }
        if (request.getFeatureId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "feature_id", request.getFeatureId().get(), false);
        }
        if (request.getWithoutExpired().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "without_expired", request.getWithoutExpired().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getCompanyIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "company_ids", request.getCompanyIds().get(), true);
        }
        if (request.getFeatureIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "feature_ids", request.getFeatureIds().get(), true);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<CountCompanyOverridesResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<CountCompanyOverridesResponse>((CountCompanyOverridesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountCompanyOverridesResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<ListFeatureCompaniesResponse> listFeatureCompanies(ListFeatureCompaniesRequest request) {
        return this.listFeatureCompanies(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListFeatureCompaniesResponse> listFeatureCompanies(ListFeatureCompaniesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("feature-companies");
        QueryStringMapper.addQueryParameter(httpUrl, "feature_id", request.getFeatureId(), false);
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListFeatureCompaniesResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListFeatureCompaniesResponse>((ListFeatureCompaniesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListFeatureCompaniesResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<CountFeatureCompaniesResponse> countFeatureCompanies(CountFeatureCompaniesRequest request) {
        return this.countFeatureCompanies(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<CountFeatureCompaniesResponse> countFeatureCompanies(CountFeatureCompaniesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("feature-companies/count");
        QueryStringMapper.addQueryParameter(httpUrl, "feature_id", request.getFeatureId(), false);
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<CountFeatureCompaniesResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<CountFeatureCompaniesResponse>((CountFeatureCompaniesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountFeatureCompaniesResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<ListFeatureUsageResponse> listFeatureUsage() {
        return this.listFeatureUsage(ListFeatureUsageRequest.builder().build());
    }

    public BaseSchematicHttpResponse<ListFeatureUsageResponse> listFeatureUsage(ListFeatureUsageRequest request) {
        return this.listFeatureUsage(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListFeatureUsageResponse> listFeatureUsage(ListFeatureUsageRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("feature-usage");
        if (request.getCompanyId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "company_id", request.getCompanyId().get(), false);
        }
        if (request.getCompanyKeys().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "company_keys", request.getCompanyKeys().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getWithoutNegativeEntitlements().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "without_negative_entitlements", request.getWithoutNegativeEntitlements().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getFeatureIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "feature_ids", request.getFeatureIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListFeatureUsageResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListFeatureUsageResponse>((ListFeatureUsageResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListFeatureUsageResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<CountFeatureUsageResponse> countFeatureUsage() {
        return this.countFeatureUsage(CountFeatureUsageRequest.builder().build());
    }

    public BaseSchematicHttpResponse<CountFeatureUsageResponse> countFeatureUsage(CountFeatureUsageRequest request) {
        return this.countFeatureUsage(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<CountFeatureUsageResponse> countFeatureUsage(CountFeatureUsageRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("feature-usage/count");
        if (request.getCompanyId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "company_id", request.getCompanyId().get(), false);
        }
        if (request.getCompanyKeys().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "company_keys", request.getCompanyKeys().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getWithoutNegativeEntitlements().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "without_negative_entitlements", request.getWithoutNegativeEntitlements().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getFeatureIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "feature_ids", request.getFeatureIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<CountFeatureUsageResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<CountFeatureUsageResponse>((CountFeatureUsageResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountFeatureUsageResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<ListFeatureUsersResponse> listFeatureUsers(ListFeatureUsersRequest request) {
        return this.listFeatureUsers(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListFeatureUsersResponse> listFeatureUsers(ListFeatureUsersRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("feature-users");
        QueryStringMapper.addQueryParameter(httpUrl, "feature_id", request.getFeatureId(), false);
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListFeatureUsersResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListFeatureUsersResponse>((ListFeatureUsersResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListFeatureUsersResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<CountFeatureUsersResponse> countFeatureUsers(CountFeatureUsersRequest request) {
        return this.countFeatureUsers(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<CountFeatureUsersResponse> countFeatureUsers(CountFeatureUsersRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("feature-users/count");
        QueryStringMapper.addQueryParameter(httpUrl, "feature_id", request.getFeatureId(), false);
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<CountFeatureUsersResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<CountFeatureUsersResponse>((CountFeatureUsersResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountFeatureUsersResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<ListPlanEntitlementsResponse> listPlanEntitlements() {
        return this.listPlanEntitlements(ListPlanEntitlementsRequest.builder().build());
    }

    public BaseSchematicHttpResponse<ListPlanEntitlementsResponse> listPlanEntitlements(ListPlanEntitlementsRequest request) {
        return this.listPlanEntitlements(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListPlanEntitlementsResponse> listPlanEntitlements(ListPlanEntitlementsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plan-entitlements");
        if (request.getFeatureId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "feature_id", request.getFeatureId().get(), false);
        }
        if (request.getPlanId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "plan_id", request.getPlanId().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getWithMeteredProducts().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "with_metered_products", request.getWithMeteredProducts().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getFeatureIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "feature_ids", request.getFeatureIds().get(), true);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        if (request.getPlanIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "plan_ids", request.getPlanIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListPlanEntitlementsResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListPlanEntitlementsResponse>((ListPlanEntitlementsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListPlanEntitlementsResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<CreatePlanEntitlementResponse> createPlanEntitlement(CreatePlanEntitlementRequestBody request) {
        return this.createPlanEntitlement(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<CreatePlanEntitlementResponse> createPlanEntitlement(CreatePlanEntitlementRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plan-entitlements").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<CreatePlanEntitlementResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<CreatePlanEntitlementResponse>((CreatePlanEntitlementResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreatePlanEntitlementResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<GetPlanEntitlementResponse> getPlanEntitlement(String planEntitlementId) {
        return this.getPlanEntitlement(planEntitlementId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<GetPlanEntitlementResponse> getPlanEntitlement(String planEntitlementId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plan-entitlements").addPathSegment(planEntitlementId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<GetPlanEntitlementResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<GetPlanEntitlementResponse>((GetPlanEntitlementResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetPlanEntitlementResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<UpdatePlanEntitlementResponse> updatePlanEntitlement(String planEntitlementId, UpdatePlanEntitlementRequestBody request) {
        return this.updatePlanEntitlement(planEntitlementId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<UpdatePlanEntitlementResponse> updatePlanEntitlement(String planEntitlementId, UpdatePlanEntitlementRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plan-entitlements").addPathSegment(planEntitlementId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<UpdatePlanEntitlementResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<UpdatePlanEntitlementResponse>((UpdatePlanEntitlementResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdatePlanEntitlementResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<DeletePlanEntitlementResponse> deletePlanEntitlement(String planEntitlementId) {
        return this.deletePlanEntitlement(planEntitlementId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<DeletePlanEntitlementResponse> deletePlanEntitlement(String planEntitlementId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plan-entitlements").addPathSegment(planEntitlementId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<DeletePlanEntitlementResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<DeletePlanEntitlementResponse>((DeletePlanEntitlementResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeletePlanEntitlementResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<CountPlanEntitlementsResponse> countPlanEntitlements() {
        return this.countPlanEntitlements(CountPlanEntitlementsRequest.builder().build());
    }

    public BaseSchematicHttpResponse<CountPlanEntitlementsResponse> countPlanEntitlements(CountPlanEntitlementsRequest request) {
        return this.countPlanEntitlements(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<CountPlanEntitlementsResponse> countPlanEntitlements(CountPlanEntitlementsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plan-entitlements/count");
        if (request.getFeatureId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "feature_id", request.getFeatureId().get(), false);
        }
        if (request.getPlanId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "plan_id", request.getPlanId().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getWithMeteredProducts().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "with_metered_products", request.getWithMeteredProducts().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getFeatureIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "feature_ids", request.getFeatureIds().get(), true);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        if (request.getPlanIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "plan_ids", request.getPlanIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<CountPlanEntitlementsResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<CountPlanEntitlementsResponse>((CountPlanEntitlementsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountPlanEntitlementsResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<GetFeatureUsageByCompanyResponse> getFeatureUsageByCompany(GetFeatureUsageByCompanyRequest request) {
        return this.getFeatureUsageByCompany(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<GetFeatureUsageByCompanyResponse> getFeatureUsageByCompany(GetFeatureUsageByCompanyRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("usage-by-company");
        QueryStringMapper.addQueryParameter(httpUrl, "keys", request.getKeys(), false);
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<GetFeatureUsageByCompanyResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<GetFeatureUsageByCompanyResponse>((GetFeatureUsageByCompanyResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetFeatureUsageByCompanyResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }
}

