/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.entitlements.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CountCompanyOverridesRequest {
    private final Optional<List<String>> companyIds;
    private final Optional<List<String>> featureIds;
    private final Optional<List<String>> ids;
    private final Optional<String> companyId;
    private final Optional<String> featureId;
    private final Optional<Boolean> withoutExpired;
    private final Optional<String> q;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Map<String, Object> additionalProperties;

    private CountCompanyOverridesRequest(Optional<List<String>> companyIds, Optional<List<String>> featureIds, Optional<List<String>> ids, Optional<String> companyId, Optional<String> featureId, Optional<Boolean> withoutExpired, Optional<String> q, Optional<Integer> limit, Optional<Integer> offset, Map<String, Object> additionalProperties) {
        this.companyIds = companyIds;
        this.featureIds = featureIds;
        this.ids = ids;
        this.companyId = companyId;
        this.featureId = featureId;
        this.withoutExpired = withoutExpired;
        this.q = q;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_ids")
    public Optional<List<String>> getCompanyIds() {
        return this.companyIds;
    }

    @JsonProperty(value="feature_ids")
    public Optional<List<String>> getFeatureIds() {
        return this.featureIds;
    }

    @JsonProperty(value="ids")
    public Optional<List<String>> getIds() {
        return this.ids;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="feature_id")
    public Optional<String> getFeatureId() {
        return this.featureId;
    }

    @JsonProperty(value="without_expired")
    public Optional<Boolean> getWithoutExpired() {
        return this.withoutExpired;
    }

    @JsonProperty(value="q")
    public Optional<String> getQ() {
        return this.q;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CountCompanyOverridesRequest && this.equalTo((CountCompanyOverridesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CountCompanyOverridesRequest other) {
        return this.companyIds.equals(other.companyIds) && this.featureIds.equals(other.featureIds) && this.ids.equals(other.ids) && this.companyId.equals(other.companyId) && this.featureId.equals(other.featureId) && this.withoutExpired.equals(other.withoutExpired) && this.q.equals(other.q) && this.limit.equals(other.limit) && this.offset.equals(other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.companyIds, this.featureIds, this.ids, this.companyId, this.featureId, this.withoutExpired, this.q, this.limit, this.offset);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> companyIds = Optional.empty();
        private Optional<List<String>> featureIds = Optional.empty();
        private Optional<List<String>> ids = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        private Optional<String> featureId = Optional.empty();
        private Optional<Boolean> withoutExpired = Optional.empty();
        private Optional<String> q = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CountCompanyOverridesRequest other) {
            this.companyIds(other.getCompanyIds());
            this.featureIds(other.getFeatureIds());
            this.ids(other.getIds());
            this.companyId(other.getCompanyId());
            this.featureId(other.getFeatureId());
            this.withoutExpired(other.getWithoutExpired());
            this.q(other.getQ());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            return this;
        }

        @JsonSetter(value="company_ids", nulls=Nulls.SKIP)
        public Builder companyIds(Optional<List<String>> companyIds) {
            this.companyIds = companyIds;
            return this;
        }

        public Builder companyIds(List<String> companyIds) {
            this.companyIds = Optional.ofNullable(companyIds);
            return this;
        }

        public Builder companyIds(String companyIds) {
            this.companyIds = Optional.of(Collections.singletonList(companyIds));
            return this;
        }

        @JsonSetter(value="feature_ids", nulls=Nulls.SKIP)
        public Builder featureIds(Optional<List<String>> featureIds) {
            this.featureIds = featureIds;
            return this;
        }

        public Builder featureIds(List<String> featureIds) {
            this.featureIds = Optional.ofNullable(featureIds);
            return this;
        }

        public Builder featureIds(String featureIds) {
            this.featureIds = Optional.of(Collections.singletonList(featureIds));
            return this;
        }

        @JsonSetter(value="ids", nulls=Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        public Builder ids(String ids) {
            this.ids = Optional.of(Collections.singletonList(ids));
            return this;
        }

        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value="feature_id", nulls=Nulls.SKIP)
        public Builder featureId(Optional<String> featureId) {
            this.featureId = featureId;
            return this;
        }

        public Builder featureId(String featureId) {
            this.featureId = Optional.ofNullable(featureId);
            return this;
        }

        @JsonSetter(value="without_expired", nulls=Nulls.SKIP)
        public Builder withoutExpired(Optional<Boolean> withoutExpired) {
            this.withoutExpired = withoutExpired;
            return this;
        }

        public Builder withoutExpired(Boolean withoutExpired) {
            this.withoutExpired = Optional.ofNullable(withoutExpired);
            return this;
        }

        @JsonSetter(value="q", nulls=Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public CountCompanyOverridesRequest build() {
            return new CountCompanyOverridesRequest(this.companyIds, this.featureIds, this.ids, this.companyId, this.featureId, this.withoutExpired, this.q, this.limit, this.offset, this.additionalProperties);
        }
    }
}

