/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.entitlements.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CountFeatureUsageRequest {
    private final Optional<List<String>> featureIds;
    private final Optional<String> companyId;
    private final Optional<Map<String, String>> companyKeys;
    private final Optional<String> q;
    private final Optional<Boolean> withoutNegativeEntitlements;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Map<String, Object> additionalProperties;

    private CountFeatureUsageRequest(Optional<List<String>> featureIds, Optional<String> companyId, Optional<Map<String, String>> companyKeys, Optional<String> q, Optional<Boolean> withoutNegativeEntitlements, Optional<Integer> limit, Optional<Integer> offset, Map<String, Object> additionalProperties) {
        this.featureIds = featureIds;
        this.companyId = companyId;
        this.companyKeys = companyKeys;
        this.q = q;
        this.withoutNegativeEntitlements = withoutNegativeEntitlements;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="feature_ids")
    public Optional<List<String>> getFeatureIds() {
        return this.featureIds;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="company_keys")
    public Optional<Map<String, String>> getCompanyKeys() {
        return this.companyKeys;
    }

    @JsonProperty(value="q")
    public Optional<String> getQ() {
        return this.q;
    }

    @JsonProperty(value="without_negative_entitlements")
    public Optional<Boolean> getWithoutNegativeEntitlements() {
        return this.withoutNegativeEntitlements;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CountFeatureUsageRequest && this.equalTo((CountFeatureUsageRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CountFeatureUsageRequest other) {
        return this.featureIds.equals(other.featureIds) && this.companyId.equals(other.companyId) && this.companyKeys.equals(other.companyKeys) && this.q.equals(other.q) && this.withoutNegativeEntitlements.equals(other.withoutNegativeEntitlements) && this.limit.equals(other.limit) && this.offset.equals(other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.featureIds, this.companyId, this.companyKeys, this.q, this.withoutNegativeEntitlements, this.limit, this.offset);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<String>> featureIds = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        private Optional<Map<String, String>> companyKeys = Optional.empty();
        private Optional<String> q = Optional.empty();
        private Optional<Boolean> withoutNegativeEntitlements = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CountFeatureUsageRequest other) {
            this.featureIds(other.getFeatureIds());
            this.companyId(other.getCompanyId());
            this.companyKeys(other.getCompanyKeys());
            this.q(other.getQ());
            this.withoutNegativeEntitlements(other.getWithoutNegativeEntitlements());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            return this;
        }

        @JsonSetter(value="feature_ids", nulls=Nulls.SKIP)
        public Builder featureIds(Optional<List<String>> featureIds) {
            this.featureIds = featureIds;
            return this;
        }

        public Builder featureIds(List<String> featureIds) {
            this.featureIds = Optional.ofNullable(featureIds);
            return this;
        }

        public Builder featureIds(String featureIds) {
            this.featureIds = Optional.of(Collections.singletonList(featureIds));
            return this;
        }

        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value="company_keys", nulls=Nulls.SKIP)
        public Builder companyKeys(Optional<Map<String, String>> companyKeys) {
            this.companyKeys = companyKeys;
            return this;
        }

        public Builder companyKeys(Map<String, String> companyKeys) {
            this.companyKeys = Optional.ofNullable(companyKeys);
            return this;
        }

        @JsonSetter(value="q", nulls=Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @JsonSetter(value="without_negative_entitlements", nulls=Nulls.SKIP)
        public Builder withoutNegativeEntitlements(Optional<Boolean> withoutNegativeEntitlements) {
            this.withoutNegativeEntitlements = withoutNegativeEntitlements;
            return this;
        }

        public Builder withoutNegativeEntitlements(Boolean withoutNegativeEntitlements) {
            this.withoutNegativeEntitlements = Optional.ofNullable(withoutNegativeEntitlements);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public CountFeatureUsageRequest build() {
            return new CountFeatureUsageRequest(this.featureIds, this.companyId, this.companyKeys, this.q, this.withoutNegativeEntitlements, this.limit, this.offset, this.additionalProperties);
        }
    }
}

