/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.events.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.events.types.ListEventsRequestEventTypesItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListEventsRequest {
    private final Optional<List<ListEventsRequestEventTypesItem>> eventTypes;
    private final Optional<String> companyId;
    private final Optional<String> eventSubtype;
    private final Optional<String> flagId;
    private final Optional<String> userId;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Map<String, Object> additionalProperties;

    private ListEventsRequest(Optional<List<ListEventsRequestEventTypesItem>> eventTypes, Optional<String> companyId, Optional<String> eventSubtype, Optional<String> flagId, Optional<String> userId, Optional<Integer> limit, Optional<Integer> offset, Map<String, Object> additionalProperties) {
        this.eventTypes = eventTypes;
        this.companyId = companyId;
        this.eventSubtype = eventSubtype;
        this.flagId = flagId;
        this.userId = userId;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="event_types")
    public Optional<List<ListEventsRequestEventTypesItem>> getEventTypes() {
        return this.eventTypes;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="event_subtype")
    public Optional<String> getEventSubtype() {
        return this.eventSubtype;
    }

    @JsonProperty(value="flag_id")
    public Optional<String> getFlagId() {
        return this.flagId;
    }

    @JsonProperty(value="user_id")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListEventsRequest && this.equalTo((ListEventsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListEventsRequest other) {
        return this.eventTypes.equals(other.eventTypes) && this.companyId.equals(other.companyId) && this.eventSubtype.equals(other.eventSubtype) && this.flagId.equals(other.flagId) && this.userId.equals(other.userId) && this.limit.equals(other.limit) && this.offset.equals(other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.eventTypes, this.companyId, this.eventSubtype, this.flagId, this.userId, this.limit, this.offset);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<ListEventsRequestEventTypesItem>> eventTypes = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        private Optional<String> eventSubtype = Optional.empty();
        private Optional<String> flagId = Optional.empty();
        private Optional<String> userId = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListEventsRequest other) {
            this.eventTypes(other.getEventTypes());
            this.companyId(other.getCompanyId());
            this.eventSubtype(other.getEventSubtype());
            this.flagId(other.getFlagId());
            this.userId(other.getUserId());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            return this;
        }

        @JsonSetter(value="event_types", nulls=Nulls.SKIP)
        public Builder eventTypes(Optional<List<ListEventsRequestEventTypesItem>> eventTypes) {
            this.eventTypes = eventTypes;
            return this;
        }

        public Builder eventTypes(List<ListEventsRequestEventTypesItem> eventTypes) {
            this.eventTypes = Optional.ofNullable(eventTypes);
            return this;
        }

        public Builder eventTypes(ListEventsRequestEventTypesItem eventTypes) {
            this.eventTypes = Optional.of(Collections.singletonList(eventTypes));
            return this;
        }

        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value="event_subtype", nulls=Nulls.SKIP)
        public Builder eventSubtype(Optional<String> eventSubtype) {
            this.eventSubtype = eventSubtype;
            return this;
        }

        public Builder eventSubtype(String eventSubtype) {
            this.eventSubtype = Optional.ofNullable(eventSubtype);
            return this;
        }

        @JsonSetter(value="flag_id", nulls=Nulls.SKIP)
        public Builder flagId(Optional<String> flagId) {
            this.flagId = flagId;
            return this;
        }

        public Builder flagId(String flagId) {
            this.flagId = Optional.ofNullable(flagId);
            return this;
        }

        @JsonSetter(value="user_id", nulls=Nulls.SKIP)
        public Builder userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public ListEventsRequest build() {
            return new ListEventsRequest(this.eventTypes, this.companyId, this.eventSubtype, this.flagId, this.userId, this.limit, this.offset, this.additionalProperties);
        }
    }
}

