/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.features;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.features.AsyncRawFeaturesClient;
import com.schematic.api.resources.features.requests.CountFeaturesRequest;
import com.schematic.api.resources.features.requests.CountFlagsRequest;
import com.schematic.api.resources.features.requests.CreateFeatureRequestBody;
import com.schematic.api.resources.features.requests.ListFeaturesRequest;
import com.schematic.api.resources.features.requests.ListFlagsRequest;
import com.schematic.api.resources.features.requests.UpdateFeatureRequestBody;
import com.schematic.api.resources.features.requests.UpdateFlagRulesRequestBody;
import com.schematic.api.resources.features.types.CheckFlagResponse;
import com.schematic.api.resources.features.types.CheckFlagsResponse;
import com.schematic.api.resources.features.types.CountFeaturesResponse;
import com.schematic.api.resources.features.types.CountFlagsResponse;
import com.schematic.api.resources.features.types.CreateFeatureResponse;
import com.schematic.api.resources.features.types.CreateFlagResponse;
import com.schematic.api.resources.features.types.DeleteFeatureResponse;
import com.schematic.api.resources.features.types.DeleteFlagResponse;
import com.schematic.api.resources.features.types.GetFeatureResponse;
import com.schematic.api.resources.features.types.GetFlagResponse;
import com.schematic.api.resources.features.types.ListFeaturesResponse;
import com.schematic.api.resources.features.types.ListFlagsResponse;
import com.schematic.api.resources.features.types.UpdateFeatureResponse;
import com.schematic.api.resources.features.types.UpdateFlagResponse;
import com.schematic.api.resources.features.types.UpdateFlagRulesResponse;
import com.schematic.api.types.CheckFlagRequestBody;
import com.schematic.api.types.CreateFlagRequestBody;
import java.util.concurrent.CompletableFuture;

public class AsyncFeaturesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawFeaturesClient rawClient;

    public AsyncFeaturesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawFeaturesClient(clientOptions);
    }

    public AsyncRawFeaturesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListFeaturesResponse> listFeatures() {
        return this.rawClient.listFeatures().thenApply(response -> (ListFeaturesResponse)response.body());
    }

    public CompletableFuture<ListFeaturesResponse> listFeatures(ListFeaturesRequest request) {
        return this.rawClient.listFeatures(request).thenApply(response -> (ListFeaturesResponse)response.body());
    }

    public CompletableFuture<ListFeaturesResponse> listFeatures(ListFeaturesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listFeatures(request, requestOptions).thenApply(response -> (ListFeaturesResponse)response.body());
    }

    public CompletableFuture<CreateFeatureResponse> createFeature(CreateFeatureRequestBody request) {
        return this.rawClient.createFeature(request).thenApply(response -> (CreateFeatureResponse)response.body());
    }

    public CompletableFuture<CreateFeatureResponse> createFeature(CreateFeatureRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createFeature(request, requestOptions).thenApply(response -> (CreateFeatureResponse)response.body());
    }

    public CompletableFuture<GetFeatureResponse> getFeature(String featureId) {
        return this.rawClient.getFeature(featureId).thenApply(response -> (GetFeatureResponse)response.body());
    }

    public CompletableFuture<GetFeatureResponse> getFeature(String featureId, RequestOptions requestOptions) {
        return this.rawClient.getFeature(featureId, requestOptions).thenApply(response -> (GetFeatureResponse)response.body());
    }

    public CompletableFuture<UpdateFeatureResponse> updateFeature(String featureId) {
        return this.rawClient.updateFeature(featureId).thenApply(response -> (UpdateFeatureResponse)response.body());
    }

    public CompletableFuture<UpdateFeatureResponse> updateFeature(String featureId, UpdateFeatureRequestBody request) {
        return this.rawClient.updateFeature(featureId, request).thenApply(response -> (UpdateFeatureResponse)response.body());
    }

    public CompletableFuture<UpdateFeatureResponse> updateFeature(String featureId, UpdateFeatureRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateFeature(featureId, request, requestOptions).thenApply(response -> (UpdateFeatureResponse)response.body());
    }

    public CompletableFuture<DeleteFeatureResponse> deleteFeature(String featureId) {
        return this.rawClient.deleteFeature(featureId).thenApply(response -> (DeleteFeatureResponse)response.body());
    }

    public CompletableFuture<DeleteFeatureResponse> deleteFeature(String featureId, RequestOptions requestOptions) {
        return this.rawClient.deleteFeature(featureId, requestOptions).thenApply(response -> (DeleteFeatureResponse)response.body());
    }

    public CompletableFuture<CountFeaturesResponse> countFeatures() {
        return this.rawClient.countFeatures().thenApply(response -> (CountFeaturesResponse)response.body());
    }

    public CompletableFuture<CountFeaturesResponse> countFeatures(CountFeaturesRequest request) {
        return this.rawClient.countFeatures(request).thenApply(response -> (CountFeaturesResponse)response.body());
    }

    public CompletableFuture<CountFeaturesResponse> countFeatures(CountFeaturesRequest request, RequestOptions requestOptions) {
        return this.rawClient.countFeatures(request, requestOptions).thenApply(response -> (CountFeaturesResponse)response.body());
    }

    public CompletableFuture<ListFlagsResponse> listFlags() {
        return this.rawClient.listFlags().thenApply(response -> (ListFlagsResponse)response.body());
    }

    public CompletableFuture<ListFlagsResponse> listFlags(ListFlagsRequest request) {
        return this.rawClient.listFlags(request).thenApply(response -> (ListFlagsResponse)response.body());
    }

    public CompletableFuture<ListFlagsResponse> listFlags(ListFlagsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listFlags(request, requestOptions).thenApply(response -> (ListFlagsResponse)response.body());
    }

    public CompletableFuture<CreateFlagResponse> createFlag(CreateFlagRequestBody request) {
        return this.rawClient.createFlag(request).thenApply(response -> (CreateFlagResponse)response.body());
    }

    public CompletableFuture<CreateFlagResponse> createFlag(CreateFlagRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createFlag(request, requestOptions).thenApply(response -> (CreateFlagResponse)response.body());
    }

    public CompletableFuture<GetFlagResponse> getFlag(String flagId) {
        return this.rawClient.getFlag(flagId).thenApply(response -> (GetFlagResponse)response.body());
    }

    public CompletableFuture<GetFlagResponse> getFlag(String flagId, RequestOptions requestOptions) {
        return this.rawClient.getFlag(flagId, requestOptions).thenApply(response -> (GetFlagResponse)response.body());
    }

    public CompletableFuture<UpdateFlagResponse> updateFlag(String flagId, CreateFlagRequestBody request) {
        return this.rawClient.updateFlag(flagId, request).thenApply(response -> (UpdateFlagResponse)response.body());
    }

    public CompletableFuture<UpdateFlagResponse> updateFlag(String flagId, CreateFlagRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateFlag(flagId, request, requestOptions).thenApply(response -> (UpdateFlagResponse)response.body());
    }

    public CompletableFuture<DeleteFlagResponse> deleteFlag(String flagId) {
        return this.rawClient.deleteFlag(flagId).thenApply(response -> (DeleteFlagResponse)response.body());
    }

    public CompletableFuture<DeleteFlagResponse> deleteFlag(String flagId, RequestOptions requestOptions) {
        return this.rawClient.deleteFlag(flagId, requestOptions).thenApply(response -> (DeleteFlagResponse)response.body());
    }

    public CompletableFuture<UpdateFlagRulesResponse> updateFlagRules(String flagId, UpdateFlagRulesRequestBody request) {
        return this.rawClient.updateFlagRules(flagId, request).thenApply(response -> (UpdateFlagRulesResponse)response.body());
    }

    public CompletableFuture<UpdateFlagRulesResponse> updateFlagRules(String flagId, UpdateFlagRulesRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateFlagRules(flagId, request, requestOptions).thenApply(response -> (UpdateFlagRulesResponse)response.body());
    }

    public CompletableFuture<CheckFlagResponse> checkFlag(String key) {
        return this.rawClient.checkFlag(key).thenApply(response -> (CheckFlagResponse)response.body());
    }

    public CompletableFuture<CheckFlagResponse> checkFlag(String key, CheckFlagRequestBody request) {
        return this.rawClient.checkFlag(key, request).thenApply(response -> (CheckFlagResponse)response.body());
    }

    public CompletableFuture<CheckFlagResponse> checkFlag(String key, CheckFlagRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.checkFlag(key, request, requestOptions).thenApply(response -> (CheckFlagResponse)response.body());
    }

    public CompletableFuture<CheckFlagsResponse> checkFlags() {
        return this.rawClient.checkFlags().thenApply(response -> (CheckFlagsResponse)response.body());
    }

    public CompletableFuture<CheckFlagsResponse> checkFlags(CheckFlagRequestBody request) {
        return this.rawClient.checkFlags(request).thenApply(response -> (CheckFlagsResponse)response.body());
    }

    public CompletableFuture<CheckFlagsResponse> checkFlags(CheckFlagRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.checkFlags(request, requestOptions).thenApply(response -> (CheckFlagsResponse)response.body());
    }

    public CompletableFuture<CountFlagsResponse> countFlags() {
        return this.rawClient.countFlags().thenApply(response -> (CountFlagsResponse)response.body());
    }

    public CompletableFuture<CountFlagsResponse> countFlags(CountFlagsRequest request) {
        return this.rawClient.countFlags(request).thenApply(response -> (CountFlagsResponse)response.body());
    }

    public CompletableFuture<CountFlagsResponse> countFlags(CountFlagsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countFlags(request, requestOptions).thenApply(response -> (CountFlagsResponse)response.body());
    }
}

