/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.plangroups;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.plangroups.RawPlangroupsClient;
import com.schematic.api.resources.plangroups.requests.CreatePlanGroupRequestBody;
import com.schematic.api.resources.plangroups.requests.UpdatePlanGroupRequestBody;
import com.schematic.api.resources.plangroups.types.CreatePlanGroupResponse;
import com.schematic.api.resources.plangroups.types.GetPlanGroupResponse;
import com.schematic.api.resources.plangroups.types.UpdatePlanGroupResponse;

public class PlangroupsClient {
    protected final ClientOptions clientOptions;
    private final RawPlangroupsClient rawClient;

    public PlangroupsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawPlangroupsClient(clientOptions);
    }

    public RawPlangroupsClient withRawResponse() {
        return this.rawClient;
    }

    public GetPlanGroupResponse getPlanGroup() {
        return this.rawClient.getPlanGroup().body();
    }

    public GetPlanGroupResponse getPlanGroup(RequestOptions requestOptions) {
        return this.rawClient.getPlanGroup(requestOptions).body();
    }

    public CreatePlanGroupResponse createPlanGroup(CreatePlanGroupRequestBody request) {
        return this.rawClient.createPlanGroup(request).body();
    }

    public CreatePlanGroupResponse createPlanGroup(CreatePlanGroupRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createPlanGroup(request, requestOptions).body();
    }

    public UpdatePlanGroupResponse updatePlanGroup(String planGroupId, UpdatePlanGroupRequestBody request) {
        return this.rawClient.updatePlanGroup(planGroupId, request).body();
    }

    public UpdatePlanGroupResponse updatePlanGroup(String planGroupId, UpdatePlanGroupRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updatePlanGroup(planGroupId, request, requestOptions).body();
    }
}

