/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.plangroups.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CompatiblePlans;
import com.schematic.api.types.CustomPlanConfig;
import com.schematic.api.types.OrderedPlansInGroup;
import com.schematic.api.types.PlanGroupBundleOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdatePlanGroupRequestBody {
    private final Optional<List<CompatiblePlans>> addOnCompatibilities;
    private final List<String> addOnIds;
    private final boolean checkoutCollectAddress;
    private final boolean checkoutCollectEmail;
    private final boolean checkoutCollectPhone;
    private final Optional<CustomPlanConfig> customPlanConfig;
    private final Optional<String> customPlanId;
    private final boolean enableTaxCollection;
    private final Optional<String> fallbackPlanId;
    private final Optional<String> initialPlanId;
    private final Optional<String> initialPlanPriceId;
    private final List<OrderedPlansInGroup> orderedAddOns;
    private final List<PlanGroupBundleOrder> orderedBundleList;
    private final List<OrderedPlansInGroup> orderedPlans;
    private final boolean preventDowngradesWhenOverLimit;
    private final boolean showCredits;
    private final boolean showPeriodToggle;
    private final boolean showZeroPriceAsFree;
    private final boolean syncCustomerBillingDetailsForTax;
    private final Optional<Integer> trialDays;
    private final Optional<String> trialExpiryPlanId;
    private final Optional<String> trialExpiryPlanPriceId;
    private final Optional<Boolean> trialPaymentMethodRequired;
    private final Map<String, Object> additionalProperties;

    private UpdatePlanGroupRequestBody(Optional<List<CompatiblePlans>> addOnCompatibilities, List<String> addOnIds, boolean checkoutCollectAddress, boolean checkoutCollectEmail, boolean checkoutCollectPhone, Optional<CustomPlanConfig> customPlanConfig, Optional<String> customPlanId, boolean enableTaxCollection, Optional<String> fallbackPlanId, Optional<String> initialPlanId, Optional<String> initialPlanPriceId, List<OrderedPlansInGroup> orderedAddOns, List<PlanGroupBundleOrder> orderedBundleList, List<OrderedPlansInGroup> orderedPlans, boolean preventDowngradesWhenOverLimit, boolean showCredits, boolean showPeriodToggle, boolean showZeroPriceAsFree, boolean syncCustomerBillingDetailsForTax, Optional<Integer> trialDays, Optional<String> trialExpiryPlanId, Optional<String> trialExpiryPlanPriceId, Optional<Boolean> trialPaymentMethodRequired, Map<String, Object> additionalProperties) {
        this.addOnCompatibilities = addOnCompatibilities;
        this.addOnIds = addOnIds;
        this.checkoutCollectAddress = checkoutCollectAddress;
        this.checkoutCollectEmail = checkoutCollectEmail;
        this.checkoutCollectPhone = checkoutCollectPhone;
        this.customPlanConfig = customPlanConfig;
        this.customPlanId = customPlanId;
        this.enableTaxCollection = enableTaxCollection;
        this.fallbackPlanId = fallbackPlanId;
        this.initialPlanId = initialPlanId;
        this.initialPlanPriceId = initialPlanPriceId;
        this.orderedAddOns = orderedAddOns;
        this.orderedBundleList = orderedBundleList;
        this.orderedPlans = orderedPlans;
        this.preventDowngradesWhenOverLimit = preventDowngradesWhenOverLimit;
        this.showCredits = showCredits;
        this.showPeriodToggle = showPeriodToggle;
        this.showZeroPriceAsFree = showZeroPriceAsFree;
        this.syncCustomerBillingDetailsForTax = syncCustomerBillingDetailsForTax;
        this.trialDays = trialDays;
        this.trialExpiryPlanId = trialExpiryPlanId;
        this.trialExpiryPlanPriceId = trialExpiryPlanPriceId;
        this.trialPaymentMethodRequired = trialPaymentMethodRequired;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="add_on_compatibilities")
    public Optional<List<CompatiblePlans>> getAddOnCompatibilities() {
        return this.addOnCompatibilities;
    }

    @JsonProperty(value="add_on_ids")
    public List<String> getAddOnIds() {
        return this.addOnIds;
    }

    @JsonProperty(value="checkout_collect_address")
    public boolean getCheckoutCollectAddress() {
        return this.checkoutCollectAddress;
    }

    @JsonProperty(value="checkout_collect_email")
    public boolean getCheckoutCollectEmail() {
        return this.checkoutCollectEmail;
    }

    @JsonProperty(value="checkout_collect_phone")
    public boolean getCheckoutCollectPhone() {
        return this.checkoutCollectPhone;
    }

    @JsonProperty(value="custom_plan_config")
    public Optional<CustomPlanConfig> getCustomPlanConfig() {
        return this.customPlanConfig;
    }

    @JsonProperty(value="custom_plan_id")
    public Optional<String> getCustomPlanId() {
        return this.customPlanId;
    }

    @JsonProperty(value="enable_tax_collection")
    public boolean getEnableTaxCollection() {
        return this.enableTaxCollection;
    }

    @JsonProperty(value="fallback_plan_id")
    public Optional<String> getFallbackPlanId() {
        return this.fallbackPlanId;
    }

    @JsonProperty(value="initial_plan_id")
    public Optional<String> getInitialPlanId() {
        return this.initialPlanId;
    }

    @JsonProperty(value="initial_plan_price_id")
    public Optional<String> getInitialPlanPriceId() {
        return this.initialPlanPriceId;
    }

    @JsonProperty(value="ordered_add_ons")
    public List<OrderedPlansInGroup> getOrderedAddOns() {
        return this.orderedAddOns;
    }

    @JsonProperty(value="ordered_bundle_list")
    public List<PlanGroupBundleOrder> getOrderedBundleList() {
        return this.orderedBundleList;
    }

    @JsonProperty(value="ordered_plans")
    public List<OrderedPlansInGroup> getOrderedPlans() {
        return this.orderedPlans;
    }

    @JsonProperty(value="prevent_downgrades_when_over_limit")
    public boolean getPreventDowngradesWhenOverLimit() {
        return this.preventDowngradesWhenOverLimit;
    }

    @JsonProperty(value="show_credits")
    public boolean getShowCredits() {
        return this.showCredits;
    }

    @JsonProperty(value="show_period_toggle")
    public boolean getShowPeriodToggle() {
        return this.showPeriodToggle;
    }

    @JsonProperty(value="show_zero_price_as_free")
    public boolean getShowZeroPriceAsFree() {
        return this.showZeroPriceAsFree;
    }

    @JsonProperty(value="sync_customer_billing_details_for_tax")
    public boolean getSyncCustomerBillingDetailsForTax() {
        return this.syncCustomerBillingDetailsForTax;
    }

    @JsonProperty(value="trial_days")
    public Optional<Integer> getTrialDays() {
        return this.trialDays;
    }

    @JsonProperty(value="trial_expiry_plan_id")
    public Optional<String> getTrialExpiryPlanId() {
        return this.trialExpiryPlanId;
    }

    @JsonProperty(value="trial_expiry_plan_price_id")
    public Optional<String> getTrialExpiryPlanPriceId() {
        return this.trialExpiryPlanPriceId;
    }

    @JsonProperty(value="trial_payment_method_required")
    public Optional<Boolean> getTrialPaymentMethodRequired() {
        return this.trialPaymentMethodRequired;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdatePlanGroupRequestBody && this.equalTo((UpdatePlanGroupRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdatePlanGroupRequestBody other) {
        return this.addOnCompatibilities.equals(other.addOnCompatibilities) && this.addOnIds.equals(other.addOnIds) && this.checkoutCollectAddress == other.checkoutCollectAddress && this.checkoutCollectEmail == other.checkoutCollectEmail && this.checkoutCollectPhone == other.checkoutCollectPhone && this.customPlanConfig.equals(other.customPlanConfig) && this.customPlanId.equals(other.customPlanId) && this.enableTaxCollection == other.enableTaxCollection && this.fallbackPlanId.equals(other.fallbackPlanId) && this.initialPlanId.equals(other.initialPlanId) && this.initialPlanPriceId.equals(other.initialPlanPriceId) && this.orderedAddOns.equals(other.orderedAddOns) && this.orderedBundleList.equals(other.orderedBundleList) && this.orderedPlans.equals(other.orderedPlans) && this.preventDowngradesWhenOverLimit == other.preventDowngradesWhenOverLimit && this.showCredits == other.showCredits && this.showPeriodToggle == other.showPeriodToggle && this.showZeroPriceAsFree == other.showZeroPriceAsFree && this.syncCustomerBillingDetailsForTax == other.syncCustomerBillingDetailsForTax && this.trialDays.equals(other.trialDays) && this.trialExpiryPlanId.equals(other.trialExpiryPlanId) && this.trialExpiryPlanPriceId.equals(other.trialExpiryPlanPriceId) && this.trialPaymentMethodRequired.equals(other.trialPaymentMethodRequired);
    }

    public int hashCode() {
        return Objects.hash(this.addOnCompatibilities, this.addOnIds, this.checkoutCollectAddress, this.checkoutCollectEmail, this.checkoutCollectPhone, this.customPlanConfig, this.customPlanId, this.enableTaxCollection, this.fallbackPlanId, this.initialPlanId, this.initialPlanPriceId, this.orderedAddOns, this.orderedBundleList, this.orderedPlans, this.preventDowngradesWhenOverLimit, this.showCredits, this.showPeriodToggle, this.showZeroPriceAsFree, this.syncCustomerBillingDetailsForTax, this.trialDays, this.trialExpiryPlanId, this.trialExpiryPlanPriceId, this.trialPaymentMethodRequired);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CheckoutCollectAddressStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CheckoutCollectAddressStage,
    CheckoutCollectEmailStage,
    CheckoutCollectPhoneStage,
    EnableTaxCollectionStage,
    PreventDowngradesWhenOverLimitStage,
    ShowCreditsStage,
    ShowPeriodToggleStage,
    ShowZeroPriceAsFreeStage,
    SyncCustomerBillingDetailsForTaxStage,
    _FinalStage {
        private boolean checkoutCollectAddress;
        private boolean checkoutCollectEmail;
        private boolean checkoutCollectPhone;
        private boolean enableTaxCollection;
        private boolean preventDowngradesWhenOverLimit;
        private boolean showCredits;
        private boolean showPeriodToggle;
        private boolean showZeroPriceAsFree;
        private boolean syncCustomerBillingDetailsForTax;
        private Optional<Boolean> trialPaymentMethodRequired = Optional.empty();
        private Optional<String> trialExpiryPlanPriceId = Optional.empty();
        private Optional<String> trialExpiryPlanId = Optional.empty();
        private Optional<Integer> trialDays = Optional.empty();
        private List<OrderedPlansInGroup> orderedPlans = new ArrayList<OrderedPlansInGroup>();
        private List<PlanGroupBundleOrder> orderedBundleList = new ArrayList<PlanGroupBundleOrder>();
        private List<OrderedPlansInGroup> orderedAddOns = new ArrayList<OrderedPlansInGroup>();
        private Optional<String> initialPlanPriceId = Optional.empty();
        private Optional<String> initialPlanId = Optional.empty();
        private Optional<String> fallbackPlanId = Optional.empty();
        private Optional<String> customPlanId = Optional.empty();
        private Optional<CustomPlanConfig> customPlanConfig = Optional.empty();
        private List<String> addOnIds = new ArrayList<String>();
        private Optional<List<CompatiblePlans>> addOnCompatibilities = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdatePlanGroupRequestBody other) {
            this.addOnCompatibilities(other.getAddOnCompatibilities());
            this.addOnIds(other.getAddOnIds());
            this.checkoutCollectAddress(other.getCheckoutCollectAddress());
            this.checkoutCollectEmail(other.getCheckoutCollectEmail());
            this.checkoutCollectPhone(other.getCheckoutCollectPhone());
            this.customPlanConfig(other.getCustomPlanConfig());
            this.customPlanId(other.getCustomPlanId());
            this.enableTaxCollection(other.getEnableTaxCollection());
            this.fallbackPlanId(other.getFallbackPlanId());
            this.initialPlanId(other.getInitialPlanId());
            this.initialPlanPriceId(other.getInitialPlanPriceId());
            this.orderedAddOns(other.getOrderedAddOns());
            this.orderedBundleList(other.getOrderedBundleList());
            this.orderedPlans(other.getOrderedPlans());
            this.preventDowngradesWhenOverLimit(other.getPreventDowngradesWhenOverLimit());
            this.showCredits(other.getShowCredits());
            this.showPeriodToggle(other.getShowPeriodToggle());
            this.showZeroPriceAsFree(other.getShowZeroPriceAsFree());
            this.syncCustomerBillingDetailsForTax(other.getSyncCustomerBillingDetailsForTax());
            this.trialDays(other.getTrialDays());
            this.trialExpiryPlanId(other.getTrialExpiryPlanId());
            this.trialExpiryPlanPriceId(other.getTrialExpiryPlanPriceId());
            this.trialPaymentMethodRequired(other.getTrialPaymentMethodRequired());
            return this;
        }

        @Override
        @JsonSetter(value="checkout_collect_address")
        public CheckoutCollectEmailStage checkoutCollectAddress(boolean checkoutCollectAddress) {
            this.checkoutCollectAddress = checkoutCollectAddress;
            return this;
        }

        @Override
        @JsonSetter(value="checkout_collect_email")
        public CheckoutCollectPhoneStage checkoutCollectEmail(boolean checkoutCollectEmail) {
            this.checkoutCollectEmail = checkoutCollectEmail;
            return this;
        }

        @Override
        @JsonSetter(value="checkout_collect_phone")
        public EnableTaxCollectionStage checkoutCollectPhone(boolean checkoutCollectPhone) {
            this.checkoutCollectPhone = checkoutCollectPhone;
            return this;
        }

        @Override
        @JsonSetter(value="enable_tax_collection")
        public PreventDowngradesWhenOverLimitStage enableTaxCollection(boolean enableTaxCollection) {
            this.enableTaxCollection = enableTaxCollection;
            return this;
        }

        @Override
        @JsonSetter(value="prevent_downgrades_when_over_limit")
        public ShowCreditsStage preventDowngradesWhenOverLimit(boolean preventDowngradesWhenOverLimit) {
            this.preventDowngradesWhenOverLimit = preventDowngradesWhenOverLimit;
            return this;
        }

        @Override
        @JsonSetter(value="show_credits")
        public ShowPeriodToggleStage showCredits(boolean showCredits) {
            this.showCredits = showCredits;
            return this;
        }

        @Override
        @JsonSetter(value="show_period_toggle")
        public ShowZeroPriceAsFreeStage showPeriodToggle(boolean showPeriodToggle) {
            this.showPeriodToggle = showPeriodToggle;
            return this;
        }

        @Override
        @JsonSetter(value="show_zero_price_as_free")
        public SyncCustomerBillingDetailsForTaxStage showZeroPriceAsFree(boolean showZeroPriceAsFree) {
            this.showZeroPriceAsFree = showZeroPriceAsFree;
            return this;
        }

        @Override
        @JsonSetter(value="sync_customer_billing_details_for_tax")
        public _FinalStage syncCustomerBillingDetailsForTax(boolean syncCustomerBillingDetailsForTax) {
            this.syncCustomerBillingDetailsForTax = syncCustomerBillingDetailsForTax;
            return this;
        }

        @Override
        public _FinalStage trialPaymentMethodRequired(Boolean trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = Optional.ofNullable(trialPaymentMethodRequired);
            return this;
        }

        @Override
        @JsonSetter(value="trial_payment_method_required", nulls=Nulls.SKIP)
        public _FinalStage trialPaymentMethodRequired(Optional<Boolean> trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = trialPaymentMethodRequired;
            return this;
        }

        @Override
        public _FinalStage trialExpiryPlanPriceId(String trialExpiryPlanPriceId) {
            this.trialExpiryPlanPriceId = Optional.ofNullable(trialExpiryPlanPriceId);
            return this;
        }

        @Override
        @JsonSetter(value="trial_expiry_plan_price_id", nulls=Nulls.SKIP)
        public _FinalStage trialExpiryPlanPriceId(Optional<String> trialExpiryPlanPriceId) {
            this.trialExpiryPlanPriceId = trialExpiryPlanPriceId;
            return this;
        }

        @Override
        public _FinalStage trialExpiryPlanId(String trialExpiryPlanId) {
            this.trialExpiryPlanId = Optional.ofNullable(trialExpiryPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="trial_expiry_plan_id", nulls=Nulls.SKIP)
        public _FinalStage trialExpiryPlanId(Optional<String> trialExpiryPlanId) {
            this.trialExpiryPlanId = trialExpiryPlanId;
            return this;
        }

        @Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @Override
        @JsonSetter(value="trial_days", nulls=Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @Override
        public _FinalStage addAllOrderedPlans(List<OrderedPlansInGroup> orderedPlans) {
            if (orderedPlans != null) {
                this.orderedPlans.addAll(orderedPlans);
            }
            return this;
        }

        @Override
        public _FinalStage addOrderedPlans(OrderedPlansInGroup orderedPlans) {
            this.orderedPlans.add(orderedPlans);
            return this;
        }

        @Override
        @JsonSetter(value="ordered_plans", nulls=Nulls.SKIP)
        public _FinalStage orderedPlans(List<OrderedPlansInGroup> orderedPlans) {
            this.orderedPlans.clear();
            if (orderedPlans != null) {
                this.orderedPlans.addAll(orderedPlans);
            }
            return this;
        }

        @Override
        public _FinalStage addAllOrderedBundleList(List<PlanGroupBundleOrder> orderedBundleList) {
            if (orderedBundleList != null) {
                this.orderedBundleList.addAll(orderedBundleList);
            }
            return this;
        }

        @Override
        public _FinalStage addOrderedBundleList(PlanGroupBundleOrder orderedBundleList) {
            this.orderedBundleList.add(orderedBundleList);
            return this;
        }

        @Override
        @JsonSetter(value="ordered_bundle_list", nulls=Nulls.SKIP)
        public _FinalStage orderedBundleList(List<PlanGroupBundleOrder> orderedBundleList) {
            this.orderedBundleList.clear();
            if (orderedBundleList != null) {
                this.orderedBundleList.addAll(orderedBundleList);
            }
            return this;
        }

        @Override
        public _FinalStage addAllOrderedAddOns(List<OrderedPlansInGroup> orderedAddOns) {
            if (orderedAddOns != null) {
                this.orderedAddOns.addAll(orderedAddOns);
            }
            return this;
        }

        @Override
        public _FinalStage addOrderedAddOns(OrderedPlansInGroup orderedAddOns) {
            this.orderedAddOns.add(orderedAddOns);
            return this;
        }

        @Override
        @JsonSetter(value="ordered_add_ons", nulls=Nulls.SKIP)
        public _FinalStage orderedAddOns(List<OrderedPlansInGroup> orderedAddOns) {
            this.orderedAddOns.clear();
            if (orderedAddOns != null) {
                this.orderedAddOns.addAll(orderedAddOns);
            }
            return this;
        }

        @Override
        public _FinalStage initialPlanPriceId(String initialPlanPriceId) {
            this.initialPlanPriceId = Optional.ofNullable(initialPlanPriceId);
            return this;
        }

        @Override
        @JsonSetter(value="initial_plan_price_id", nulls=Nulls.SKIP)
        public _FinalStage initialPlanPriceId(Optional<String> initialPlanPriceId) {
            this.initialPlanPriceId = initialPlanPriceId;
            return this;
        }

        @Override
        public _FinalStage initialPlanId(String initialPlanId) {
            this.initialPlanId = Optional.ofNullable(initialPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="initial_plan_id", nulls=Nulls.SKIP)
        public _FinalStage initialPlanId(Optional<String> initialPlanId) {
            this.initialPlanId = initialPlanId;
            return this;
        }

        @Override
        public _FinalStage fallbackPlanId(String fallbackPlanId) {
            this.fallbackPlanId = Optional.ofNullable(fallbackPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="fallback_plan_id", nulls=Nulls.SKIP)
        public _FinalStage fallbackPlanId(Optional<String> fallbackPlanId) {
            this.fallbackPlanId = fallbackPlanId;
            return this;
        }

        @Override
        public _FinalStage customPlanId(String customPlanId) {
            this.customPlanId = Optional.ofNullable(customPlanId);
            return this;
        }

        @Override
        @JsonSetter(value="custom_plan_id", nulls=Nulls.SKIP)
        public _FinalStage customPlanId(Optional<String> customPlanId) {
            this.customPlanId = customPlanId;
            return this;
        }

        @Override
        public _FinalStage customPlanConfig(CustomPlanConfig customPlanConfig) {
            this.customPlanConfig = Optional.ofNullable(customPlanConfig);
            return this;
        }

        @Override
        @JsonSetter(value="custom_plan_config", nulls=Nulls.SKIP)
        public _FinalStage customPlanConfig(Optional<CustomPlanConfig> customPlanConfig) {
            this.customPlanConfig = customPlanConfig;
            return this;
        }

        @Override
        public _FinalStage addAllAddOnIds(List<String> addOnIds) {
            if (addOnIds != null) {
                this.addOnIds.addAll(addOnIds);
            }
            return this;
        }

        @Override
        public _FinalStage addAddOnIds(String addOnIds) {
            this.addOnIds.add(addOnIds);
            return this;
        }

        @Override
        @JsonSetter(value="add_on_ids", nulls=Nulls.SKIP)
        public _FinalStage addOnIds(List<String> addOnIds) {
            this.addOnIds.clear();
            if (addOnIds != null) {
                this.addOnIds.addAll(addOnIds);
            }
            return this;
        }

        @Override
        public _FinalStage addOnCompatibilities(List<CompatiblePlans> addOnCompatibilities) {
            this.addOnCompatibilities = Optional.ofNullable(addOnCompatibilities);
            return this;
        }

        @Override
        @JsonSetter(value="add_on_compatibilities", nulls=Nulls.SKIP)
        public _FinalStage addOnCompatibilities(Optional<List<CompatiblePlans>> addOnCompatibilities) {
            this.addOnCompatibilities = addOnCompatibilities;
            return this;
        }

        @Override
        public UpdatePlanGroupRequestBody build() {
            return new UpdatePlanGroupRequestBody(this.addOnCompatibilities, this.addOnIds, this.checkoutCollectAddress, this.checkoutCollectEmail, this.checkoutCollectPhone, this.customPlanConfig, this.customPlanId, this.enableTaxCollection, this.fallbackPlanId, this.initialPlanId, this.initialPlanPriceId, this.orderedAddOns, this.orderedBundleList, this.orderedPlans, this.preventDowngradesWhenOverLimit, this.showCredits, this.showPeriodToggle, this.showZeroPriceAsFree, this.syncCustomerBillingDetailsForTax, this.trialDays, this.trialExpiryPlanId, this.trialExpiryPlanPriceId, this.trialPaymentMethodRequired, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdatePlanGroupRequestBody build();

        public _FinalStage addOnCompatibilities(Optional<List<CompatiblePlans>> var1);

        public _FinalStage addOnCompatibilities(List<CompatiblePlans> var1);

        public _FinalStage addOnIds(List<String> var1);

        public _FinalStage addAddOnIds(String var1);

        public _FinalStage addAllAddOnIds(List<String> var1);

        public _FinalStage customPlanConfig(Optional<CustomPlanConfig> var1);

        public _FinalStage customPlanConfig(CustomPlanConfig var1);

        public _FinalStage customPlanId(Optional<String> var1);

        public _FinalStage customPlanId(String var1);

        public _FinalStage fallbackPlanId(Optional<String> var1);

        public _FinalStage fallbackPlanId(String var1);

        public _FinalStage initialPlanId(Optional<String> var1);

        public _FinalStage initialPlanId(String var1);

        public _FinalStage initialPlanPriceId(Optional<String> var1);

        public _FinalStage initialPlanPriceId(String var1);

        public _FinalStage orderedAddOns(List<OrderedPlansInGroup> var1);

        public _FinalStage addOrderedAddOns(OrderedPlansInGroup var1);

        public _FinalStage addAllOrderedAddOns(List<OrderedPlansInGroup> var1);

        public _FinalStage orderedBundleList(List<PlanGroupBundleOrder> var1);

        public _FinalStage addOrderedBundleList(PlanGroupBundleOrder var1);

        public _FinalStage addAllOrderedBundleList(List<PlanGroupBundleOrder> var1);

        public _FinalStage orderedPlans(List<OrderedPlansInGroup> var1);

        public _FinalStage addOrderedPlans(OrderedPlansInGroup var1);

        public _FinalStage addAllOrderedPlans(List<OrderedPlansInGroup> var1);

        public _FinalStage trialDays(Optional<Integer> var1);

        public _FinalStage trialDays(Integer var1);

        public _FinalStage trialExpiryPlanId(Optional<String> var1);

        public _FinalStage trialExpiryPlanId(String var1);

        public _FinalStage trialExpiryPlanPriceId(Optional<String> var1);

        public _FinalStage trialExpiryPlanPriceId(String var1);

        public _FinalStage trialPaymentMethodRequired(Optional<Boolean> var1);

        public _FinalStage trialPaymentMethodRequired(Boolean var1);
    }

    public static interface SyncCustomerBillingDetailsForTaxStage {
        public _FinalStage syncCustomerBillingDetailsForTax(boolean var1);
    }

    public static interface ShowZeroPriceAsFreeStage {
        public SyncCustomerBillingDetailsForTaxStage showZeroPriceAsFree(boolean var1);
    }

    public static interface ShowPeriodToggleStage {
        public ShowZeroPriceAsFreeStage showPeriodToggle(boolean var1);
    }

    public static interface ShowCreditsStage {
        public ShowPeriodToggleStage showCredits(boolean var1);
    }

    public static interface PreventDowngradesWhenOverLimitStage {
        public ShowCreditsStage preventDowngradesWhenOverLimit(boolean var1);
    }

    public static interface EnableTaxCollectionStage {
        public PreventDowngradesWhenOverLimitStage enableTaxCollection(boolean var1);
    }

    public static interface CheckoutCollectPhoneStage {
        public EnableTaxCollectionStage checkoutCollectPhone(boolean var1);
    }

    public static interface CheckoutCollectEmailStage {
        public CheckoutCollectPhoneStage checkoutCollectEmail(boolean var1);
    }

    public static interface CheckoutCollectAddressStage {
        public CheckoutCollectEmailStage checkoutCollectAddress(boolean var1);

        public Builder from(UpdatePlanGroupRequestBody var1);
    }
}

