/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.plans;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.plans.AsyncRawPlansClient;
import com.schematic.api.resources.plans.requests.CountPlansRequest;
import com.schematic.api.resources.plans.requests.CreatePlanRequestBody;
import com.schematic.api.resources.plans.requests.ListPlanIssuesRequest;
import com.schematic.api.resources.plans.requests.ListPlansRequest;
import com.schematic.api.resources.plans.requests.UpdateCompanyPlansRequestBody;
import com.schematic.api.resources.plans.requests.UpdatePlanRequestBody;
import com.schematic.api.resources.plans.requests.UpsertBillingProductRequestBody;
import com.schematic.api.resources.plans.types.CountPlansResponse;
import com.schematic.api.resources.plans.types.CreatePlanResponse;
import com.schematic.api.resources.plans.types.DeletePlanResponse;
import com.schematic.api.resources.plans.types.GetPlanResponse;
import com.schematic.api.resources.plans.types.ListPlanIssuesResponse;
import com.schematic.api.resources.plans.types.ListPlansResponse;
import com.schematic.api.resources.plans.types.UpdateCompanyPlansResponse;
import com.schematic.api.resources.plans.types.UpdatePlanResponse;
import com.schematic.api.resources.plans.types.UpsertBillingProductPlanResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncPlansClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawPlansClient rawClient;

    public AsyncPlansClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawPlansClient(clientOptions);
    }

    public AsyncRawPlansClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<UpdateCompanyPlansResponse> updateCompanyPlans(String companyPlanId, UpdateCompanyPlansRequestBody request) {
        return this.rawClient.updateCompanyPlans(companyPlanId, request).thenApply(response -> (UpdateCompanyPlansResponse)response.body());
    }

    public CompletableFuture<UpdateCompanyPlansResponse> updateCompanyPlans(String companyPlanId, UpdateCompanyPlansRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateCompanyPlans(companyPlanId, request, requestOptions).thenApply(response -> (UpdateCompanyPlansResponse)response.body());
    }

    public CompletableFuture<ListPlansResponse> listPlans() {
        return this.rawClient.listPlans().thenApply(response -> (ListPlansResponse)response.body());
    }

    public CompletableFuture<ListPlansResponse> listPlans(ListPlansRequest request) {
        return this.rawClient.listPlans(request).thenApply(response -> (ListPlansResponse)response.body());
    }

    public CompletableFuture<ListPlansResponse> listPlans(ListPlansRequest request, RequestOptions requestOptions) {
        return this.rawClient.listPlans(request, requestOptions).thenApply(response -> (ListPlansResponse)response.body());
    }

    public CompletableFuture<CreatePlanResponse> createPlan(CreatePlanRequestBody request) {
        return this.rawClient.createPlan(request).thenApply(response -> (CreatePlanResponse)response.body());
    }

    public CompletableFuture<CreatePlanResponse> createPlan(CreatePlanRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createPlan(request, requestOptions).thenApply(response -> (CreatePlanResponse)response.body());
    }

    public CompletableFuture<GetPlanResponse> getPlan(String planId) {
        return this.rawClient.getPlan(planId).thenApply(response -> (GetPlanResponse)response.body());
    }

    public CompletableFuture<GetPlanResponse> getPlan(String planId, RequestOptions requestOptions) {
        return this.rawClient.getPlan(planId, requestOptions).thenApply(response -> (GetPlanResponse)response.body());
    }

    public CompletableFuture<UpdatePlanResponse> updatePlan(String planId, UpdatePlanRequestBody request) {
        return this.rawClient.updatePlan(planId, request).thenApply(response -> (UpdatePlanResponse)response.body());
    }

    public CompletableFuture<UpdatePlanResponse> updatePlan(String planId, UpdatePlanRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updatePlan(planId, request, requestOptions).thenApply(response -> (UpdatePlanResponse)response.body());
    }

    public CompletableFuture<DeletePlanResponse> deletePlan(String planId) {
        return this.rawClient.deletePlan(planId).thenApply(response -> (DeletePlanResponse)response.body());
    }

    public CompletableFuture<DeletePlanResponse> deletePlan(String planId, RequestOptions requestOptions) {
        return this.rawClient.deletePlan(planId, requestOptions).thenApply(response -> (DeletePlanResponse)response.body());
    }

    public CompletableFuture<UpsertBillingProductPlanResponse> upsertBillingProductPlan(String planId, UpsertBillingProductRequestBody request) {
        return this.rawClient.upsertBillingProductPlan(planId, request).thenApply(response -> (UpsertBillingProductPlanResponse)response.body());
    }

    public CompletableFuture<UpsertBillingProductPlanResponse> upsertBillingProductPlan(String planId, UpsertBillingProductRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.upsertBillingProductPlan(planId, request, requestOptions).thenApply(response -> (UpsertBillingProductPlanResponse)response.body());
    }

    public CompletableFuture<CountPlansResponse> countPlans() {
        return this.rawClient.countPlans().thenApply(response -> (CountPlansResponse)response.body());
    }

    public CompletableFuture<CountPlansResponse> countPlans(CountPlansRequest request) {
        return this.rawClient.countPlans(request).thenApply(response -> (CountPlansResponse)response.body());
    }

    public CompletableFuture<CountPlansResponse> countPlans(CountPlansRequest request, RequestOptions requestOptions) {
        return this.rawClient.countPlans(request, requestOptions).thenApply(response -> (CountPlansResponse)response.body());
    }

    public CompletableFuture<ListPlanIssuesResponse> listPlanIssues(ListPlanIssuesRequest request) {
        return this.rawClient.listPlanIssues(request).thenApply(response -> (ListPlanIssuesResponse)response.body());
    }

    public CompletableFuture<ListPlanIssuesResponse> listPlanIssues(ListPlanIssuesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listPlanIssues(request, requestOptions).thenApply(response -> (ListPlanIssuesResponse)response.body());
    }
}

