/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.plans;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.schematic.api.core.BaseSchematicApiException;
import com.schematic.api.core.BaseSchematicException;
import com.schematic.api.core.BaseSchematicHttpResponse;
import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.MediaTypes;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.core.QueryStringMapper;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.errors.BadRequestError;
import com.schematic.api.errors.ForbiddenError;
import com.schematic.api.errors.InternalServerError;
import com.schematic.api.errors.NotFoundError;
import com.schematic.api.errors.UnauthorizedError;
import com.schematic.api.resources.plans.requests.CountPlansRequest;
import com.schematic.api.resources.plans.requests.CreatePlanRequestBody;
import com.schematic.api.resources.plans.requests.ListPlanIssuesRequest;
import com.schematic.api.resources.plans.requests.ListPlansRequest;
import com.schematic.api.resources.plans.requests.UpdateCompanyPlansRequestBody;
import com.schematic.api.resources.plans.requests.UpdatePlanRequestBody;
import com.schematic.api.resources.plans.requests.UpsertBillingProductRequestBody;
import com.schematic.api.resources.plans.types.CountPlansResponse;
import com.schematic.api.resources.plans.types.CreatePlanResponse;
import com.schematic.api.resources.plans.types.DeletePlanResponse;
import com.schematic.api.resources.plans.types.GetPlanResponse;
import com.schematic.api.resources.plans.types.ListPlanIssuesResponse;
import com.schematic.api.resources.plans.types.ListPlansResponse;
import com.schematic.api.resources.plans.types.UpdateCompanyPlansResponse;
import com.schematic.api.resources.plans.types.UpdatePlanResponse;
import com.schematic.api.resources.plans.types.UpsertBillingProductPlanResponse;
import com.schematic.api.types.ApiError;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawPlansClient {
    protected final ClientOptions clientOptions;

    public RawPlansClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public BaseSchematicHttpResponse<UpdateCompanyPlansResponse> updateCompanyPlans(String companyPlanId, UpdateCompanyPlansRequestBody request) {
        return this.updateCompanyPlans(companyPlanId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<UpdateCompanyPlansResponse> updateCompanyPlans(String companyPlanId, UpdateCompanyPlansRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("company-plans").addPathSegment(companyPlanId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<UpdateCompanyPlansResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<UpdateCompanyPlansResponse>((UpdateCompanyPlansResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdateCompanyPlansResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<ListPlansResponse> listPlans() {
        return this.listPlans(ListPlansRequest.builder().build());
    }

    public BaseSchematicHttpResponse<ListPlansResponse> listPlans(ListPlansRequest request) {
        return this.listPlans(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListPlansResponse> listPlans(ListPlansRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plans");
        if (request.getCompanyId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "company_id", request.getCompanyId().get(), false);
        }
        if (request.getForFallbackPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "for_fallback_plan", request.getForFallbackPlan().get(), false);
        }
        if (request.getForInitialPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "for_initial_plan", request.getForInitialPlan().get(), false);
        }
        if (request.getForTrialExpiryPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "for_trial_expiry_plan", request.getForTrialExpiryPlan().get(), false);
        }
        if (request.getHasProductId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "has_product_id", request.getHasProductId().get(), false);
        }
        if (request.getPlanType().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "plan_type", request.getPlanType().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getRequiresPaymentMethod().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "requires_payment_method", request.getRequiresPaymentMethod().get(), false);
        }
        if (request.getWithoutEntitlementFor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "without_entitlement_for", request.getWithoutEntitlementFor().get(), false);
        }
        if (request.getWithoutProductId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "without_product_id", request.getWithoutProductId().get(), false);
        }
        if (request.getWithoutPaidProductId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "without_paid_product_id", request.getWithoutPaidProductId().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListPlansResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListPlansResponse>((ListPlansResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListPlansResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<CreatePlanResponse> createPlan(CreatePlanRequestBody request) {
        return this.createPlan(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<CreatePlanResponse> createPlan(CreatePlanRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plans").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<CreatePlanResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<CreatePlanResponse>((CreatePlanResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreatePlanResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<GetPlanResponse> getPlan(String planId) {
        return this.getPlan(planId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<GetPlanResponse> getPlan(String planId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plans").addPathSegment(planId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<GetPlanResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<GetPlanResponse>((GetPlanResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetPlanResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<UpdatePlanResponse> updatePlan(String planId, UpdatePlanRequestBody request) {
        return this.updatePlan(planId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<UpdatePlanResponse> updatePlan(String planId, UpdatePlanRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plans").addPathSegment(planId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<UpdatePlanResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<UpdatePlanResponse>((UpdatePlanResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdatePlanResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<DeletePlanResponse> deletePlan(String planId) {
        return this.deletePlan(planId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<DeletePlanResponse> deletePlan(String planId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plans").addPathSegment(planId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<DeletePlanResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<DeletePlanResponse>((DeletePlanResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeletePlanResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<UpsertBillingProductPlanResponse> upsertBillingProductPlan(String planId, UpsertBillingProductRequestBody request) {
        return this.upsertBillingProductPlan(planId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<UpsertBillingProductPlanResponse> upsertBillingProductPlan(String planId, UpsertBillingProductRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plans").addPathSegment(planId).addPathSegments("billing_products").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<UpsertBillingProductPlanResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<UpsertBillingProductPlanResponse>((UpsertBillingProductPlanResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpsertBillingProductPlanResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<CountPlansResponse> countPlans() {
        return this.countPlans(CountPlansRequest.builder().build());
    }

    public BaseSchematicHttpResponse<CountPlansResponse> countPlans(CountPlansRequest request) {
        return this.countPlans(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<CountPlansResponse> countPlans(CountPlansRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plans/count");
        if (request.getCompanyId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "company_id", request.getCompanyId().get(), false);
        }
        if (request.getForFallbackPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "for_fallback_plan", request.getForFallbackPlan().get(), false);
        }
        if (request.getForInitialPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "for_initial_plan", request.getForInitialPlan().get(), false);
        }
        if (request.getForTrialExpiryPlan().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "for_trial_expiry_plan", request.getForTrialExpiryPlan().get(), false);
        }
        if (request.getHasProductId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "has_product_id", request.getHasProductId().get(), false);
        }
        if (request.getPlanType().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "plan_type", request.getPlanType().get(), false);
        }
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getRequiresPaymentMethod().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "requires_payment_method", request.getRequiresPaymentMethod().get(), false);
        }
        if (request.getWithoutEntitlementFor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "without_entitlement_for", request.getWithoutEntitlementFor().get(), false);
        }
        if (request.getWithoutProductId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "without_product_id", request.getWithoutProductId().get(), false);
        }
        if (request.getWithoutPaidProductId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "without_paid_product_id", request.getWithoutPaidProductId().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<CountPlansResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<CountPlansResponse>((CountPlansResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountPlansResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<ListPlanIssuesResponse> listPlanIssues(ListPlanIssuesRequest request) {
        return this.listPlanIssues(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListPlanIssuesResponse> listPlanIssues(ListPlanIssuesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("plans/issues");
        QueryStringMapper.addQueryParameter(httpUrl, "plan_id", request.getPlanId(), false);
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListPlanIssuesResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListPlanIssuesResponse>((ListPlanIssuesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListPlanIssuesResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }
}

