/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.plans.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.plans.types.CreatePlanRequestBodyPlanType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreatePlanRequestBody {
    private final String description;
    private final Optional<String> icon;
    private final String name;
    private final CreatePlanRequestBodyPlanType planType;
    private final Map<String, Object> additionalProperties;

    private CreatePlanRequestBody(String description, Optional<String> icon, String name, CreatePlanRequestBodyPlanType planType, Map<String, Object> additionalProperties) {
        this.description = description;
        this.icon = icon;
        this.name = name;
        this.planType = planType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="icon")
    public Optional<String> getIcon() {
        return this.icon;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="plan_type")
    public CreatePlanRequestBodyPlanType getPlanType() {
        return this.planType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreatePlanRequestBody && this.equalTo((CreatePlanRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreatePlanRequestBody other) {
        return this.description.equals(other.description) && this.icon.equals(other.icon) && this.name.equals(other.name) && this.planType.equals(other.planType);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.icon, this.name, this.planType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DescriptionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DescriptionStage,
    NameStage,
    PlanTypeStage,
    _FinalStage {
        private String description;
        private String name;
        private CreatePlanRequestBodyPlanType planType;
        private Optional<String> icon = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreatePlanRequestBody other) {
            this.description(other.getDescription());
            this.icon(other.getIcon());
            this.name(other.getName());
            this.planType(other.getPlanType());
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public NameStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PlanTypeStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="plan_type")
        public _FinalStage planType(@NotNull CreatePlanRequestBodyPlanType planType) {
            this.planType = Objects.requireNonNull(planType, "planType must not be null");
            return this;
        }

        @Override
        public _FinalStage icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        @Override
        @JsonSetter(value="icon", nulls=Nulls.SKIP)
        public _FinalStage icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public CreatePlanRequestBody build() {
            return new CreatePlanRequestBody(this.description, this.icon, this.name, this.planType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreatePlanRequestBody build();

        public _FinalStage icon(Optional<String> var1);

        public _FinalStage icon(String var1);
    }

    public static interface PlanTypeStage {
        public _FinalStage planType(@NotNull CreatePlanRequestBodyPlanType var1);
    }

    public static interface NameStage {
        public PlanTypeStage name(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public NameStage description(@NotNull String var1);

        public Builder from(CreatePlanRequestBody var1);
    }
}

