/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.plans.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.plans.types.UpsertBillingProductRequestBodyChargeType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpsertBillingProductRequestBody {
    private final Optional<String> billingProductId;
    private final UpsertBillingProductRequestBodyChargeType chargeType;
    private final Optional<String> currency;
    private final boolean isTrialable;
    private final Optional<Integer> monthlyPrice;
    private final Optional<String> monthlyPriceId;
    private final Optional<Integer> oneTimePrice;
    private final Optional<String> oneTimePriceId;
    private final Optional<Integer> trialDays;
    private final Optional<Integer> yearlyPrice;
    private final Optional<String> yearlyPriceId;
    private final Map<String, Object> additionalProperties;

    private UpsertBillingProductRequestBody(Optional<String> billingProductId, UpsertBillingProductRequestBodyChargeType chargeType, Optional<String> currency, boolean isTrialable, Optional<Integer> monthlyPrice, Optional<String> monthlyPriceId, Optional<Integer> oneTimePrice, Optional<String> oneTimePriceId, Optional<Integer> trialDays, Optional<Integer> yearlyPrice, Optional<String> yearlyPriceId, Map<String, Object> additionalProperties) {
        this.billingProductId = billingProductId;
        this.chargeType = chargeType;
        this.currency = currency;
        this.isTrialable = isTrialable;
        this.monthlyPrice = monthlyPrice;
        this.monthlyPriceId = monthlyPriceId;
        this.oneTimePrice = oneTimePrice;
        this.oneTimePriceId = oneTimePriceId;
        this.trialDays = trialDays;
        this.yearlyPrice = yearlyPrice;
        this.yearlyPriceId = yearlyPriceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="billing_product_id")
    public Optional<String> getBillingProductId() {
        return this.billingProductId;
    }

    @JsonProperty(value="charge_type")
    public UpsertBillingProductRequestBodyChargeType getChargeType() {
        return this.chargeType;
    }

    @JsonProperty(value="currency")
    public Optional<String> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="is_trialable")
    public boolean getIsTrialable() {
        return this.isTrialable;
    }

    @JsonProperty(value="monthly_price")
    public Optional<Integer> getMonthlyPrice() {
        return this.monthlyPrice;
    }

    @JsonProperty(value="monthly_price_id")
    public Optional<String> getMonthlyPriceId() {
        return this.monthlyPriceId;
    }

    @JsonProperty(value="one_time_price")
    public Optional<Integer> getOneTimePrice() {
        return this.oneTimePrice;
    }

    @JsonProperty(value="one_time_price_id")
    public Optional<String> getOneTimePriceId() {
        return this.oneTimePriceId;
    }

    @JsonProperty(value="trial_days")
    public Optional<Integer> getTrialDays() {
        return this.trialDays;
    }

    @JsonProperty(value="yearly_price")
    public Optional<Integer> getYearlyPrice() {
        return this.yearlyPrice;
    }

    @JsonProperty(value="yearly_price_id")
    public Optional<String> getYearlyPriceId() {
        return this.yearlyPriceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpsertBillingProductRequestBody && this.equalTo((UpsertBillingProductRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpsertBillingProductRequestBody other) {
        return this.billingProductId.equals(other.billingProductId) && this.chargeType.equals(other.chargeType) && this.currency.equals(other.currency) && this.isTrialable == other.isTrialable && this.monthlyPrice.equals(other.monthlyPrice) && this.monthlyPriceId.equals(other.monthlyPriceId) && this.oneTimePrice.equals(other.oneTimePrice) && this.oneTimePriceId.equals(other.oneTimePriceId) && this.trialDays.equals(other.trialDays) && this.yearlyPrice.equals(other.yearlyPrice) && this.yearlyPriceId.equals(other.yearlyPriceId);
    }

    public int hashCode() {
        return Objects.hash(this.billingProductId, this.chargeType, this.currency, this.isTrialable, this.monthlyPrice, this.monthlyPriceId, this.oneTimePrice, this.oneTimePriceId, this.trialDays, this.yearlyPrice, this.yearlyPriceId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ChargeTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ChargeTypeStage,
    IsTrialableStage,
    _FinalStage {
        private UpsertBillingProductRequestBodyChargeType chargeType;
        private boolean isTrialable;
        private Optional<String> yearlyPriceId = Optional.empty();
        private Optional<Integer> yearlyPrice = Optional.empty();
        private Optional<Integer> trialDays = Optional.empty();
        private Optional<String> oneTimePriceId = Optional.empty();
        private Optional<Integer> oneTimePrice = Optional.empty();
        private Optional<String> monthlyPriceId = Optional.empty();
        private Optional<Integer> monthlyPrice = Optional.empty();
        private Optional<String> currency = Optional.empty();
        private Optional<String> billingProductId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpsertBillingProductRequestBody other) {
            this.billingProductId(other.getBillingProductId());
            this.chargeType(other.getChargeType());
            this.currency(other.getCurrency());
            this.isTrialable(other.getIsTrialable());
            this.monthlyPrice(other.getMonthlyPrice());
            this.monthlyPriceId(other.getMonthlyPriceId());
            this.oneTimePrice(other.getOneTimePrice());
            this.oneTimePriceId(other.getOneTimePriceId());
            this.trialDays(other.getTrialDays());
            this.yearlyPrice(other.getYearlyPrice());
            this.yearlyPriceId(other.getYearlyPriceId());
            return this;
        }

        @Override
        @JsonSetter(value="charge_type")
        public IsTrialableStage chargeType(@NotNull UpsertBillingProductRequestBodyChargeType chargeType) {
            this.chargeType = Objects.requireNonNull(chargeType, "chargeType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_trialable")
        public _FinalStage isTrialable(boolean isTrialable) {
            this.isTrialable = isTrialable;
            return this;
        }

        @Override
        public _FinalStage yearlyPriceId(String yearlyPriceId) {
            this.yearlyPriceId = Optional.ofNullable(yearlyPriceId);
            return this;
        }

        @Override
        @JsonSetter(value="yearly_price_id", nulls=Nulls.SKIP)
        public _FinalStage yearlyPriceId(Optional<String> yearlyPriceId) {
            this.yearlyPriceId = yearlyPriceId;
            return this;
        }

        @Override
        public _FinalStage yearlyPrice(Integer yearlyPrice) {
            this.yearlyPrice = Optional.ofNullable(yearlyPrice);
            return this;
        }

        @Override
        @JsonSetter(value="yearly_price", nulls=Nulls.SKIP)
        public _FinalStage yearlyPrice(Optional<Integer> yearlyPrice) {
            this.yearlyPrice = yearlyPrice;
            return this;
        }

        @Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @Override
        @JsonSetter(value="trial_days", nulls=Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @Override
        public _FinalStage oneTimePriceId(String oneTimePriceId) {
            this.oneTimePriceId = Optional.ofNullable(oneTimePriceId);
            return this;
        }

        @Override
        @JsonSetter(value="one_time_price_id", nulls=Nulls.SKIP)
        public _FinalStage oneTimePriceId(Optional<String> oneTimePriceId) {
            this.oneTimePriceId = oneTimePriceId;
            return this;
        }

        @Override
        public _FinalStage oneTimePrice(Integer oneTimePrice) {
            this.oneTimePrice = Optional.ofNullable(oneTimePrice);
            return this;
        }

        @Override
        @JsonSetter(value="one_time_price", nulls=Nulls.SKIP)
        public _FinalStage oneTimePrice(Optional<Integer> oneTimePrice) {
            this.oneTimePrice = oneTimePrice;
            return this;
        }

        @Override
        public _FinalStage monthlyPriceId(String monthlyPriceId) {
            this.monthlyPriceId = Optional.ofNullable(monthlyPriceId);
            return this;
        }

        @Override
        @JsonSetter(value="monthly_price_id", nulls=Nulls.SKIP)
        public _FinalStage monthlyPriceId(Optional<String> monthlyPriceId) {
            this.monthlyPriceId = monthlyPriceId;
            return this;
        }

        @Override
        public _FinalStage monthlyPrice(Integer monthlyPrice) {
            this.monthlyPrice = Optional.ofNullable(monthlyPrice);
            return this;
        }

        @Override
        @JsonSetter(value="monthly_price", nulls=Nulls.SKIP)
        public _FinalStage monthlyPrice(Optional<Integer> monthlyPrice) {
            this.monthlyPrice = monthlyPrice;
            return this;
        }

        @Override
        public _FinalStage currency(String currency) {
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        @Override
        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public _FinalStage currency(Optional<String> currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public _FinalStage billingProductId(String billingProductId) {
            this.billingProductId = Optional.ofNullable(billingProductId);
            return this;
        }

        @Override
        @JsonSetter(value="billing_product_id", nulls=Nulls.SKIP)
        public _FinalStage billingProductId(Optional<String> billingProductId) {
            this.billingProductId = billingProductId;
            return this;
        }

        @Override
        public UpsertBillingProductRequestBody build() {
            return new UpsertBillingProductRequestBody(this.billingProductId, this.chargeType, this.currency, this.isTrialable, this.monthlyPrice, this.monthlyPriceId, this.oneTimePrice, this.oneTimePriceId, this.trialDays, this.yearlyPrice, this.yearlyPriceId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpsertBillingProductRequestBody build();

        public _FinalStage billingProductId(Optional<String> var1);

        public _FinalStage billingProductId(String var1);

        public _FinalStage currency(Optional<String> var1);

        public _FinalStage currency(String var1);

        public _FinalStage monthlyPrice(Optional<Integer> var1);

        public _FinalStage monthlyPrice(Integer var1);

        public _FinalStage monthlyPriceId(Optional<String> var1);

        public _FinalStage monthlyPriceId(String var1);

        public _FinalStage oneTimePrice(Optional<Integer> var1);

        public _FinalStage oneTimePrice(Integer var1);

        public _FinalStage oneTimePriceId(Optional<String> var1);

        public _FinalStage oneTimePriceId(String var1);

        public _FinalStage trialDays(Optional<Integer> var1);

        public _FinalStage trialDays(Integer var1);

        public _FinalStage yearlyPrice(Optional<Integer> var1);

        public _FinalStage yearlyPrice(Integer var1);

        public _FinalStage yearlyPriceId(Optional<String> var1);

        public _FinalStage yearlyPriceId(String var1);
    }

    public static interface IsTrialableStage {
        public _FinalStage isTrialable(boolean var1);
    }

    public static interface ChargeTypeStage {
        public IsTrialableStage chargeType(@NotNull UpsertBillingProductRequestBodyChargeType var1);

        public Builder from(UpsertBillingProductRequestBody var1);
    }
}

