/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.webhooks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.schematic.api.core.BaseSchematicApiException;
import com.schematic.api.core.BaseSchematicException;
import com.schematic.api.core.BaseSchematicHttpResponse;
import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.MediaTypes;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.core.QueryStringMapper;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.errors.BadRequestError;
import com.schematic.api.errors.ForbiddenError;
import com.schematic.api.errors.InternalServerError;
import com.schematic.api.errors.NotFoundError;
import com.schematic.api.errors.UnauthorizedError;
import com.schematic.api.resources.webhooks.requests.CountWebhookEventsRequest;
import com.schematic.api.resources.webhooks.requests.CountWebhooksRequest;
import com.schematic.api.resources.webhooks.requests.CreateWebhookRequestBody;
import com.schematic.api.resources.webhooks.requests.ListWebhookEventsRequest;
import com.schematic.api.resources.webhooks.requests.ListWebhooksRequest;
import com.schematic.api.resources.webhooks.requests.UpdateWebhookRequestBody;
import com.schematic.api.resources.webhooks.types.CountWebhookEventsResponse;
import com.schematic.api.resources.webhooks.types.CountWebhooksResponse;
import com.schematic.api.resources.webhooks.types.CreateWebhookResponse;
import com.schematic.api.resources.webhooks.types.DeleteWebhookResponse;
import com.schematic.api.resources.webhooks.types.GetWebhookEventResponse;
import com.schematic.api.resources.webhooks.types.GetWebhookResponse;
import com.schematic.api.resources.webhooks.types.ListWebhookEventsResponse;
import com.schematic.api.resources.webhooks.types.ListWebhooksResponse;
import com.schematic.api.resources.webhooks.types.UpdateWebhookResponse;
import com.schematic.api.types.ApiError;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawWebhooksClient {
    protected final ClientOptions clientOptions;

    public RawWebhooksClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public BaseSchematicHttpResponse<ListWebhookEventsResponse> listWebhookEvents() {
        return this.listWebhookEvents(ListWebhookEventsRequest.builder().build());
    }

    public BaseSchematicHttpResponse<ListWebhookEventsResponse> listWebhookEvents(ListWebhookEventsRequest request) {
        return this.listWebhookEvents(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListWebhookEventsResponse> listWebhookEvents(ListWebhookEventsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhook-events");
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getWebhookId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "webhook_id", request.getWebhookId().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListWebhookEventsResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListWebhookEventsResponse>((ListWebhookEventsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListWebhookEventsResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<GetWebhookEventResponse> getWebhookEvent(String webhookEventId) {
        return this.getWebhookEvent(webhookEventId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<GetWebhookEventResponse> getWebhookEvent(String webhookEventId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhook-events").addPathSegment(webhookEventId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<GetWebhookEventResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<GetWebhookEventResponse>((GetWebhookEventResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetWebhookEventResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<CountWebhookEventsResponse> countWebhookEvents() {
        return this.countWebhookEvents(CountWebhookEventsRequest.builder().build());
    }

    public BaseSchematicHttpResponse<CountWebhookEventsResponse> countWebhookEvents(CountWebhookEventsRequest request) {
        return this.countWebhookEvents(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<CountWebhookEventsResponse> countWebhookEvents(CountWebhookEventsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhook-events/count");
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getWebhookId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "webhook_id", request.getWebhookId().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        if (request.getIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "ids", request.getIds().get(), true);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<CountWebhookEventsResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<CountWebhookEventsResponse>((CountWebhookEventsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountWebhookEventsResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<ListWebhooksResponse> listWebhooks() {
        return this.listWebhooks(ListWebhooksRequest.builder().build());
    }

    public BaseSchematicHttpResponse<ListWebhooksResponse> listWebhooks(ListWebhooksRequest request) {
        return this.listWebhooks(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<ListWebhooksResponse> listWebhooks(ListWebhooksRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhooks");
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<ListWebhooksResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<ListWebhooksResponse>((ListWebhooksResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListWebhooksResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<CreateWebhookResponse> createWebhook(CreateWebhookRequestBody request) {
        return this.createWebhook(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<CreateWebhookResponse> createWebhook(CreateWebhookRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhooks").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<CreateWebhookResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<CreateWebhookResponse>((CreateWebhookResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateWebhookResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<GetWebhookResponse> getWebhook(String webhookId) {
        return this.getWebhook(webhookId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<GetWebhookResponse> getWebhook(String webhookId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhooks").addPathSegment(webhookId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<GetWebhookResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<GetWebhookResponse>((GetWebhookResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetWebhookResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<UpdateWebhookResponse> updateWebhook(String webhookId) {
        return this.updateWebhook(webhookId, UpdateWebhookRequestBody.builder().build());
    }

    public BaseSchematicHttpResponse<UpdateWebhookResponse> updateWebhook(String webhookId, UpdateWebhookRequestBody request) {
        return this.updateWebhook(webhookId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<UpdateWebhookResponse> updateWebhook(String webhookId, UpdateWebhookRequestBody request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhooks").addPathSegment(webhookId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new BaseSchematicException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<UpdateWebhookResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<UpdateWebhookResponse>((UpdateWebhookResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdateWebhookResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<DeleteWebhookResponse> deleteWebhook(String webhookId) {
        return this.deleteWebhook(webhookId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<DeleteWebhookResponse> deleteWebhook(String webhookId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhooks").addPathSegment(webhookId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<DeleteWebhookResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<DeleteWebhookResponse>((DeleteWebhookResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteWebhookResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }

    public BaseSchematicHttpResponse<CountWebhooksResponse> countWebhooks() {
        return this.countWebhooks(CountWebhooksRequest.builder().build());
    }

    public BaseSchematicHttpResponse<CountWebhooksResponse> countWebhooks(CountWebhooksRequest request) {
        return this.countWebhooks(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseSchematicHttpResponse<CountWebhooksResponse> countWebhooks(CountWebhooksRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("webhooks/count");
        if (request.getQ().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "q", request.getQ().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getOffset().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offset", request.getOffset().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                BaseSchematicHttpResponse<CountWebhooksResponse> baseSchematicHttpResponse = new BaseSchematicHttpResponse<CountWebhooksResponse>((CountWebhooksResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CountWebhooksResponse.class), response);
                return baseSchematicHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 403: {
                        throw new ForbiddenError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 404: {
                        throw new NotFoundError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                    case 500: {
                        throw new InternalServerError((ApiError)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ApiError.class), response);
                    }
                }
                throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new BaseSchematicApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new BaseSchematicException("Network error executing HTTP request", e);
        }
    }
}

