/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.webhooks;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.webhooks.RawWebhooksClient;
import com.schematic.api.resources.webhooks.requests.CountWebhookEventsRequest;
import com.schematic.api.resources.webhooks.requests.CountWebhooksRequest;
import com.schematic.api.resources.webhooks.requests.CreateWebhookRequestBody;
import com.schematic.api.resources.webhooks.requests.ListWebhookEventsRequest;
import com.schematic.api.resources.webhooks.requests.ListWebhooksRequest;
import com.schematic.api.resources.webhooks.requests.UpdateWebhookRequestBody;
import com.schematic.api.resources.webhooks.types.CountWebhookEventsResponse;
import com.schematic.api.resources.webhooks.types.CountWebhooksResponse;
import com.schematic.api.resources.webhooks.types.CreateWebhookResponse;
import com.schematic.api.resources.webhooks.types.DeleteWebhookResponse;
import com.schematic.api.resources.webhooks.types.GetWebhookEventResponse;
import com.schematic.api.resources.webhooks.types.GetWebhookResponse;
import com.schematic.api.resources.webhooks.types.ListWebhookEventsResponse;
import com.schematic.api.resources.webhooks.types.ListWebhooksResponse;
import com.schematic.api.resources.webhooks.types.UpdateWebhookResponse;

public class WebhooksClient {
    protected final ClientOptions clientOptions;
    private final RawWebhooksClient rawClient;

    public WebhooksClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawWebhooksClient(clientOptions);
    }

    public RawWebhooksClient withRawResponse() {
        return this.rawClient;
    }

    public ListWebhookEventsResponse listWebhookEvents() {
        return this.rawClient.listWebhookEvents().body();
    }

    public ListWebhookEventsResponse listWebhookEvents(ListWebhookEventsRequest request) {
        return this.rawClient.listWebhookEvents(request).body();
    }

    public ListWebhookEventsResponse listWebhookEvents(ListWebhookEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listWebhookEvents(request, requestOptions).body();
    }

    public GetWebhookEventResponse getWebhookEvent(String webhookEventId) {
        return this.rawClient.getWebhookEvent(webhookEventId).body();
    }

    public GetWebhookEventResponse getWebhookEvent(String webhookEventId, RequestOptions requestOptions) {
        return this.rawClient.getWebhookEvent(webhookEventId, requestOptions).body();
    }

    public CountWebhookEventsResponse countWebhookEvents() {
        return this.rawClient.countWebhookEvents().body();
    }

    public CountWebhookEventsResponse countWebhookEvents(CountWebhookEventsRequest request) {
        return this.rawClient.countWebhookEvents(request).body();
    }

    public CountWebhookEventsResponse countWebhookEvents(CountWebhookEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countWebhookEvents(request, requestOptions).body();
    }

    public ListWebhooksResponse listWebhooks() {
        return this.rawClient.listWebhooks().body();
    }

    public ListWebhooksResponse listWebhooks(ListWebhooksRequest request) {
        return this.rawClient.listWebhooks(request).body();
    }

    public ListWebhooksResponse listWebhooks(ListWebhooksRequest request, RequestOptions requestOptions) {
        return this.rawClient.listWebhooks(request, requestOptions).body();
    }

    public CreateWebhookResponse createWebhook(CreateWebhookRequestBody request) {
        return this.rawClient.createWebhook(request).body();
    }

    public CreateWebhookResponse createWebhook(CreateWebhookRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createWebhook(request, requestOptions).body();
    }

    public GetWebhookResponse getWebhook(String webhookId) {
        return this.rawClient.getWebhook(webhookId).body();
    }

    public GetWebhookResponse getWebhook(String webhookId, RequestOptions requestOptions) {
        return this.rawClient.getWebhook(webhookId, requestOptions).body();
    }

    public UpdateWebhookResponse updateWebhook(String webhookId) {
        return this.rawClient.updateWebhook(webhookId).body();
    }

    public UpdateWebhookResponse updateWebhook(String webhookId, UpdateWebhookRequestBody request) {
        return this.rawClient.updateWebhook(webhookId, request).body();
    }

    public UpdateWebhookResponse updateWebhook(String webhookId, UpdateWebhookRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateWebhook(webhookId, request, requestOptions).body();
    }

    public DeleteWebhookResponse deleteWebhook(String webhookId) {
        return this.rawClient.deleteWebhook(webhookId).body();
    }

    public DeleteWebhookResponse deleteWebhook(String webhookId, RequestOptions requestOptions) {
        return this.rawClient.deleteWebhook(webhookId, requestOptions).body();
    }

    public CountWebhooksResponse countWebhooks() {
        return this.rawClient.countWebhooks().body();
    }

    public CountWebhooksResponse countWebhooks(CountWebhooksRequest request) {
        return this.rawClient.countWebhooks(request).body();
    }

    public CountWebhooksResponse countWebhooks(CountWebhooksRequest request, RequestOptions requestOptions) {
        return this.rawClient.countWebhooks(request, requestOptions).body();
    }
}

