/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.webhooks.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.webhooks.types.CreateWebhookRequestBodyRequestTypesItem;
import com.schematic.api.types.CreditTriggerConfig;
import com.schematic.api.types.EntitlementTriggerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateWebhookRequestBody {
    private final Optional<List<CreditTriggerConfig>> creditTriggerConfigs;
    private final Optional<List<EntitlementTriggerConfig>> entitlementTriggerConfigs;
    private final String name;
    private final List<CreateWebhookRequestBodyRequestTypesItem> requestTypes;
    private final String url;
    private final Map<String, Object> additionalProperties;

    private CreateWebhookRequestBody(Optional<List<CreditTriggerConfig>> creditTriggerConfigs, Optional<List<EntitlementTriggerConfig>> entitlementTriggerConfigs, String name, List<CreateWebhookRequestBodyRequestTypesItem> requestTypes, String url, Map<String, Object> additionalProperties) {
        this.creditTriggerConfigs = creditTriggerConfigs;
        this.entitlementTriggerConfigs = entitlementTriggerConfigs;
        this.name = name;
        this.requestTypes = requestTypes;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="credit_trigger_configs")
    public Optional<List<CreditTriggerConfig>> getCreditTriggerConfigs() {
        return this.creditTriggerConfigs;
    }

    @JsonProperty(value="entitlement_trigger_configs")
    public Optional<List<EntitlementTriggerConfig>> getEntitlementTriggerConfigs() {
        return this.entitlementTriggerConfigs;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="request_types")
    public List<CreateWebhookRequestBodyRequestTypesItem> getRequestTypes() {
        return this.requestTypes;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateWebhookRequestBody && this.equalTo((CreateWebhookRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateWebhookRequestBody other) {
        return this.creditTriggerConfigs.equals(other.creditTriggerConfigs) && this.entitlementTriggerConfigs.equals(other.entitlementTriggerConfigs) && this.name.equals(other.name) && this.requestTypes.equals(other.requestTypes) && this.url.equals(other.url);
    }

    public int hashCode() {
        return Objects.hash(this.creditTriggerConfigs, this.entitlementTriggerConfigs, this.name, this.requestTypes, this.url);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    UrlStage,
    _FinalStage {
        private String name;
        private String url;
        private List<CreateWebhookRequestBodyRequestTypesItem> requestTypes = new ArrayList<CreateWebhookRequestBodyRequestTypesItem>();
        private Optional<List<EntitlementTriggerConfig>> entitlementTriggerConfigs = Optional.empty();
        private Optional<List<CreditTriggerConfig>> creditTriggerConfigs = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateWebhookRequestBody other) {
            this.creditTriggerConfigs(other.getCreditTriggerConfigs());
            this.entitlementTriggerConfigs(other.getEntitlementTriggerConfigs());
            this.name(other.getName());
            this.requestTypes(other.getRequestTypes());
            this.url(other.getUrl());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public UrlStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllRequestTypes(List<CreateWebhookRequestBodyRequestTypesItem> requestTypes) {
            if (requestTypes != null) {
                this.requestTypes.addAll(requestTypes);
            }
            return this;
        }

        @Override
        public _FinalStage addRequestTypes(CreateWebhookRequestBodyRequestTypesItem requestTypes) {
            this.requestTypes.add(requestTypes);
            return this;
        }

        @Override
        @JsonSetter(value="request_types", nulls=Nulls.SKIP)
        public _FinalStage requestTypes(List<CreateWebhookRequestBodyRequestTypesItem> requestTypes) {
            this.requestTypes.clear();
            if (requestTypes != null) {
                this.requestTypes.addAll(requestTypes);
            }
            return this;
        }

        @Override
        public _FinalStage entitlementTriggerConfigs(List<EntitlementTriggerConfig> entitlementTriggerConfigs) {
            this.entitlementTriggerConfigs = Optional.ofNullable(entitlementTriggerConfigs);
            return this;
        }

        @Override
        @JsonSetter(value="entitlement_trigger_configs", nulls=Nulls.SKIP)
        public _FinalStage entitlementTriggerConfigs(Optional<List<EntitlementTriggerConfig>> entitlementTriggerConfigs) {
            this.entitlementTriggerConfigs = entitlementTriggerConfigs;
            return this;
        }

        @Override
        public _FinalStage creditTriggerConfigs(List<CreditTriggerConfig> creditTriggerConfigs) {
            this.creditTriggerConfigs = Optional.ofNullable(creditTriggerConfigs);
            return this;
        }

        @Override
        @JsonSetter(value="credit_trigger_configs", nulls=Nulls.SKIP)
        public _FinalStage creditTriggerConfigs(Optional<List<CreditTriggerConfig>> creditTriggerConfigs) {
            this.creditTriggerConfigs = creditTriggerConfigs;
            return this;
        }

        @Override
        public CreateWebhookRequestBody build() {
            return new CreateWebhookRequestBody(this.creditTriggerConfigs, this.entitlementTriggerConfigs, this.name, this.requestTypes, this.url, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateWebhookRequestBody build();

        public _FinalStage creditTriggerConfigs(Optional<List<CreditTriggerConfig>> var1);

        public _FinalStage creditTriggerConfigs(List<CreditTriggerConfig> var1);

        public _FinalStage entitlementTriggerConfigs(Optional<List<EntitlementTriggerConfig>> var1);

        public _FinalStage entitlementTriggerConfigs(List<EntitlementTriggerConfig> var1);

        public _FinalStage requestTypes(List<CreateWebhookRequestBodyRequestTypesItem> var1);

        public _FinalStage addRequestTypes(CreateWebhookRequestBodyRequestTypesItem var1);

        public _FinalStage addAllRequestTypes(List<CreateWebhookRequestBodyRequestTypesItem> var1);
    }

    public static interface UrlStage {
        public _FinalStage url(@NotNull String var1);
    }

    public static interface NameStage {
        public UrlStage name(@NotNull String var1);

        public Builder from(CreateWebhookRequestBody var1);
    }
}

