/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ApiKeyResponseData {
    private final OffsetDateTime createdAt;
    private final Optional<String> description;
    private final Optional<String> environmentId;
    private final String id;
    private final Optional<OffsetDateTime> lastUsedAt;
    private final String name;
    private final List<String> scopes;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private ApiKeyResponseData(OffsetDateTime createdAt, Optional<String> description, Optional<String> environmentId, String id, Optional<OffsetDateTime> lastUsedAt, String name, List<String> scopes, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.description = description;
        this.environmentId = environmentId;
        this.id = id;
        this.lastUsedAt = lastUsedAt;
        this.name = name;
        this.scopes = scopes;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="environment_id")
    public Optional<String> getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="last_used_at")
    public Optional<OffsetDateTime> getLastUsedAt() {
        return this.lastUsedAt;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="scopes")
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ApiKeyResponseData && this.equalTo((ApiKeyResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ApiKeyResponseData other) {
        return this.createdAt.equals(other.createdAt) && this.description.equals(other.description) && this.environmentId.equals(other.environmentId) && this.id.equals(other.id) && this.lastUsedAt.equals(other.lastUsedAt) && this.name.equals(other.name) && this.scopes.equals(other.scopes) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.description, this.environmentId, this.id, this.lastUsedAt, this.name, this.scopes, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    IdStage,
    NameStage,
    UpdatedAtStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String id;
        private String name;
        private OffsetDateTime updatedAt;
        private List<String> scopes = new ArrayList<String>();
        private Optional<OffsetDateTime> lastUsedAt = Optional.empty();
        private Optional<String> environmentId = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ApiKeyResponseData other) {
            this.createdAt(other.getCreatedAt());
            this.description(other.getDescription());
            this.environmentId(other.getEnvironmentId());
            this.id(other.getId());
            this.lastUsedAt(other.getLastUsedAt());
            this.name(other.getName());
            this.scopes(other.getScopes());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public IdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllScopes(List<String> scopes) {
            if (scopes != null) {
                this.scopes.addAll(scopes);
            }
            return this;
        }

        @Override
        public _FinalStage addScopes(String scopes) {
            this.scopes.add(scopes);
            return this;
        }

        @Override
        @JsonSetter(value="scopes", nulls=Nulls.SKIP)
        public _FinalStage scopes(List<String> scopes) {
            this.scopes.clear();
            if (scopes != null) {
                this.scopes.addAll(scopes);
            }
            return this;
        }

        @Override
        public _FinalStage lastUsedAt(OffsetDateTime lastUsedAt) {
            this.lastUsedAt = Optional.ofNullable(lastUsedAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_used_at", nulls=Nulls.SKIP)
        public _FinalStage lastUsedAt(Optional<OffsetDateTime> lastUsedAt) {
            this.lastUsedAt = lastUsedAt;
            return this;
        }

        @Override
        public _FinalStage environmentId(String environmentId) {
            this.environmentId = Optional.ofNullable(environmentId);
            return this;
        }

        @Override
        @JsonSetter(value="environment_id", nulls=Nulls.SKIP)
        public _FinalStage environmentId(Optional<String> environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public ApiKeyResponseData build() {
            return new ApiKeyResponseData(this.createdAt, this.description, this.environmentId, this.id, this.lastUsedAt, this.name, this.scopes, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ApiKeyResponseData build();

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage environmentId(Optional<String> var1);

        public _FinalStage environmentId(String var1);

        public _FinalStage lastUsedAt(Optional<OffsetDateTime> var1);

        public _FinalStage lastUsedAt(OffsetDateTime var1);

        public _FinalStage scopes(List<String> var1);

        public _FinalStage addScopes(String var1);

        public _FinalStage addAllScopes(List<String> var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface NameStage {
        public UpdatedAtStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public IdStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(ApiKeyResponseData var1);
    }
}

