/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingCouponResponseData {
    private final String accountId;
    private final Optional<Integer> amountOff;
    private final Optional<String> currency;
    private final Optional<String> duration;
    private final Optional<Integer> durationInMonths;
    private final String environmentId;
    private final String externalId;
    private final String id;
    private final boolean isActive;
    private final Optional<Integer> maxRedemptions;
    private final Map<String, JsonNode> metadata;
    private final String name;
    private final Optional<Double> percentOff;
    private final int timesRedeemed;
    private final Optional<OffsetDateTime> validFrom;
    private final Optional<OffsetDateTime> validUntil;
    private final Map<String, Object> additionalProperties;

    private BillingCouponResponseData(String accountId, Optional<Integer> amountOff, Optional<String> currency, Optional<String> duration, Optional<Integer> durationInMonths, String environmentId, String externalId, String id, boolean isActive, Optional<Integer> maxRedemptions, Map<String, JsonNode> metadata, String name, Optional<Double> percentOff, int timesRedeemed, Optional<OffsetDateTime> validFrom, Optional<OffsetDateTime> validUntil, Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.amountOff = amountOff;
        this.currency = currency;
        this.duration = duration;
        this.durationInMonths = durationInMonths;
        this.environmentId = environmentId;
        this.externalId = externalId;
        this.id = id;
        this.isActive = isActive;
        this.maxRedemptions = maxRedemptions;
        this.metadata = metadata;
        this.name = name;
        this.percentOff = percentOff;
        this.timesRedeemed = timesRedeemed;
        this.validFrom = validFrom;
        this.validUntil = validUntil;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_id")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="amount_off")
    public Optional<Integer> getAmountOff() {
        return this.amountOff;
    }

    @JsonProperty(value="currency")
    public Optional<String> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="duration")
    public Optional<String> getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration_in_months")
    public Optional<Integer> getDurationInMonths() {
        return this.durationInMonths;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="is_active")
    public boolean getIsActive() {
        return this.isActive;
    }

    @JsonProperty(value="max_redemptions")
    public Optional<Integer> getMaxRedemptions() {
        return this.maxRedemptions;
    }

    @JsonProperty(value="metadata")
    public Map<String, JsonNode> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="percent_off")
    public Optional<Double> getPercentOff() {
        return this.percentOff;
    }

    @JsonProperty(value="times_redeemed")
    public int getTimesRedeemed() {
        return this.timesRedeemed;
    }

    @JsonProperty(value="valid_from")
    public Optional<OffsetDateTime> getValidFrom() {
        return this.validFrom;
    }

    @JsonProperty(value="valid_until")
    public Optional<OffsetDateTime> getValidUntil() {
        return this.validUntil;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingCouponResponseData && this.equalTo((BillingCouponResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingCouponResponseData other) {
        return this.accountId.equals(other.accountId) && this.amountOff.equals(other.amountOff) && this.currency.equals(other.currency) && this.duration.equals(other.duration) && this.durationInMonths.equals(other.durationInMonths) && this.environmentId.equals(other.environmentId) && this.externalId.equals(other.externalId) && this.id.equals(other.id) && this.isActive == other.isActive && this.maxRedemptions.equals(other.maxRedemptions) && this.metadata.equals(other.metadata) && this.name.equals(other.name) && this.percentOff.equals(other.percentOff) && this.timesRedeemed == other.timesRedeemed && this.validFrom.equals(other.validFrom) && this.validUntil.equals(other.validUntil);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.amountOff, this.currency, this.duration, this.durationInMonths, this.environmentId, this.externalId, this.id, this.isActive, this.maxRedemptions, this.metadata, this.name, this.percentOff, this.timesRedeemed, this.validFrom, this.validUntil);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccountIdStage,
    EnvironmentIdStage,
    ExternalIdStage,
    IdStage,
    IsActiveStage,
    NameStage,
    TimesRedeemedStage,
    _FinalStage {
        private String accountId;
        private String environmentId;
        private String externalId;
        private String id;
        private boolean isActive;
        private String name;
        private int timesRedeemed;
        private Optional<OffsetDateTime> validUntil = Optional.empty();
        private Optional<OffsetDateTime> validFrom = Optional.empty();
        private Optional<Double> percentOff = Optional.empty();
        private Map<String, JsonNode> metadata = new LinkedHashMap<String, JsonNode>();
        private Optional<Integer> maxRedemptions = Optional.empty();
        private Optional<Integer> durationInMonths = Optional.empty();
        private Optional<String> duration = Optional.empty();
        private Optional<String> currency = Optional.empty();
        private Optional<Integer> amountOff = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingCouponResponseData other) {
            this.accountId(other.getAccountId());
            this.amountOff(other.getAmountOff());
            this.currency(other.getCurrency());
            this.duration(other.getDuration());
            this.durationInMonths(other.getDurationInMonths());
            this.environmentId(other.getEnvironmentId());
            this.externalId(other.getExternalId());
            this.id(other.getId());
            this.isActive(other.getIsActive());
            this.maxRedemptions(other.getMaxRedemptions());
            this.metadata(other.getMetadata());
            this.name(other.getName());
            this.percentOff(other.getPercentOff());
            this.timesRedeemed(other.getTimesRedeemed());
            this.validFrom(other.getValidFrom());
            this.validUntil(other.getValidUntil());
            return this;
        }

        @Override
        @JsonSetter(value="account_id")
        public EnvironmentIdStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public ExternalIdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_id")
        public IdStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public IsActiveStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_active")
        public NameStage isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public TimesRedeemedStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="times_redeemed")
        public _FinalStage timesRedeemed(int timesRedeemed) {
            this.timesRedeemed = timesRedeemed;
            return this;
        }

        @Override
        public _FinalStage validUntil(OffsetDateTime validUntil) {
            this.validUntil = Optional.ofNullable(validUntil);
            return this;
        }

        @Override
        @JsonSetter(value="valid_until", nulls=Nulls.SKIP)
        public _FinalStage validUntil(Optional<OffsetDateTime> validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        @Override
        public _FinalStage validFrom(OffsetDateTime validFrom) {
            this.validFrom = Optional.ofNullable(validFrom);
            return this;
        }

        @Override
        @JsonSetter(value="valid_from", nulls=Nulls.SKIP)
        public _FinalStage validFrom(Optional<OffsetDateTime> validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        @Override
        public _FinalStage percentOff(Double percentOff) {
            this.percentOff = Optional.ofNullable(percentOff);
            return this;
        }

        @Override
        @JsonSetter(value="percent_off", nulls=Nulls.SKIP)
        public _FinalStage percentOff(Optional<Double> percentOff) {
            this.percentOff = percentOff;
            return this;
        }

        @Override
        public _FinalStage metadata(String key, JsonNode value) {
            this.metadata.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllMetadata(Map<String, JsonNode> metadata) {
            if (metadata != null) {
                this.metadata.putAll(metadata);
            }
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Map<String, JsonNode> metadata) {
            this.metadata.clear();
            if (metadata != null) {
                this.metadata.putAll(metadata);
            }
            return this;
        }

        @Override
        public _FinalStage maxRedemptions(Integer maxRedemptions) {
            this.maxRedemptions = Optional.ofNullable(maxRedemptions);
            return this;
        }

        @Override
        @JsonSetter(value="max_redemptions", nulls=Nulls.SKIP)
        public _FinalStage maxRedemptions(Optional<Integer> maxRedemptions) {
            this.maxRedemptions = maxRedemptions;
            return this;
        }

        @Override
        public _FinalStage durationInMonths(Integer durationInMonths) {
            this.durationInMonths = Optional.ofNullable(durationInMonths);
            return this;
        }

        @Override
        @JsonSetter(value="duration_in_months", nulls=Nulls.SKIP)
        public _FinalStage durationInMonths(Optional<Integer> durationInMonths) {
            this.durationInMonths = durationInMonths;
            return this;
        }

        @Override
        public _FinalStage duration(String duration) {
            this.duration = Optional.ofNullable(duration);
            return this;
        }

        @Override
        @JsonSetter(value="duration", nulls=Nulls.SKIP)
        public _FinalStage duration(Optional<String> duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public _FinalStage currency(String currency) {
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        @Override
        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public _FinalStage currency(Optional<String> currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public _FinalStage amountOff(Integer amountOff) {
            this.amountOff = Optional.ofNullable(amountOff);
            return this;
        }

        @Override
        @JsonSetter(value="amount_off", nulls=Nulls.SKIP)
        public _FinalStage amountOff(Optional<Integer> amountOff) {
            this.amountOff = amountOff;
            return this;
        }

        @Override
        public BillingCouponResponseData build() {
            return new BillingCouponResponseData(this.accountId, this.amountOff, this.currency, this.duration, this.durationInMonths, this.environmentId, this.externalId, this.id, this.isActive, this.maxRedemptions, this.metadata, this.name, this.percentOff, this.timesRedeemed, this.validFrom, this.validUntil, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingCouponResponseData build();

        public _FinalStage amountOff(Optional<Integer> var1);

        public _FinalStage amountOff(Integer var1);

        public _FinalStage currency(Optional<String> var1);

        public _FinalStage currency(String var1);

        public _FinalStage duration(Optional<String> var1);

        public _FinalStage duration(String var1);

        public _FinalStage durationInMonths(Optional<Integer> var1);

        public _FinalStage durationInMonths(Integer var1);

        public _FinalStage maxRedemptions(Optional<Integer> var1);

        public _FinalStage maxRedemptions(Integer var1);

        public _FinalStage metadata(Map<String, JsonNode> var1);

        public _FinalStage putAllMetadata(Map<String, JsonNode> var1);

        public _FinalStage metadata(String var1, JsonNode var2);

        public _FinalStage percentOff(Optional<Double> var1);

        public _FinalStage percentOff(Double var1);

        public _FinalStage validFrom(Optional<OffsetDateTime> var1);

        public _FinalStage validFrom(OffsetDateTime var1);

        public _FinalStage validUntil(Optional<OffsetDateTime> var1);

        public _FinalStage validUntil(OffsetDateTime var1);
    }

    public static interface TimesRedeemedStage {
        public _FinalStage timesRedeemed(int var1);
    }

    public static interface NameStage {
        public TimesRedeemedStage name(@NotNull String var1);
    }

    public static interface IsActiveStage {
        public NameStage isActive(boolean var1);
    }

    public static interface IdStage {
        public IsActiveStage id(@NotNull String var1);
    }

    public static interface ExternalIdStage {
        public IdStage externalId(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public ExternalIdStage environmentId(@NotNull String var1);
    }

    public static interface AccountIdStage {
        public EnvironmentIdStage accountId(@NotNull String var1);

        public Builder from(BillingCouponResponseData var1);
    }
}

