/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingProductPriceResponseData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingCreditBundleView {
    private final Optional<String> billingInvoiceId;
    private final String bundleType;
    private final OffsetDateTime createdAt;
    private final Optional<String> creditDescription;
    private final Optional<String> creditIcon;
    private final String creditId;
    private final String creditName;
    private final String expiryType;
    private final String expiryUnit;
    private final Optional<Integer> expiryUnitCount;
    private final boolean hasGrants;
    private final String id;
    private final String name;
    private final Optional<String> pluralName;
    private final Optional<BillingProductPriceResponseData> price;
    private final Optional<Integer> quantity;
    private final Optional<String> singularName;
    private final String status;
    private final Optional<BillingProductPriceResponseData> unitPrice;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private BillingCreditBundleView(Optional<String> billingInvoiceId, String bundleType, OffsetDateTime createdAt, Optional<String> creditDescription, Optional<String> creditIcon, String creditId, String creditName, String expiryType, String expiryUnit, Optional<Integer> expiryUnitCount, boolean hasGrants, String id, String name, Optional<String> pluralName, Optional<BillingProductPriceResponseData> price, Optional<Integer> quantity, Optional<String> singularName, String status, Optional<BillingProductPriceResponseData> unitPrice, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.billingInvoiceId = billingInvoiceId;
        this.bundleType = bundleType;
        this.createdAt = createdAt;
        this.creditDescription = creditDescription;
        this.creditIcon = creditIcon;
        this.creditId = creditId;
        this.creditName = creditName;
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.hasGrants = hasGrants;
        this.id = id;
        this.name = name;
        this.pluralName = pluralName;
        this.price = price;
        this.quantity = quantity;
        this.singularName = singularName;
        this.status = status;
        this.unitPrice = unitPrice;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="billing_invoice_id")
    public Optional<String> getBillingInvoiceId() {
        return this.billingInvoiceId;
    }

    @JsonProperty(value="bundle_type")
    public String getBundleType() {
        return this.bundleType;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="credit_description")
    public Optional<String> getCreditDescription() {
        return this.creditDescription;
    }

    @JsonProperty(value="credit_icon")
    public Optional<String> getCreditIcon() {
        return this.creditIcon;
    }

    @JsonProperty(value="credit_id")
    public String getCreditId() {
        return this.creditId;
    }

    @JsonProperty(value="credit_name")
    public String getCreditName() {
        return this.creditName;
    }

    @JsonProperty(value="expiry_type")
    public String getExpiryType() {
        return this.expiryType;
    }

    @JsonProperty(value="expiry_unit")
    public String getExpiryUnit() {
        return this.expiryUnit;
    }

    @JsonProperty(value="expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return this.expiryUnitCount;
    }

    @JsonProperty(value="has_grants")
    public boolean getHasGrants() {
        return this.hasGrants;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="plural_name")
    public Optional<String> getPluralName() {
        return this.pluralName;
    }

    @JsonProperty(value="price")
    public Optional<BillingProductPriceResponseData> getPrice() {
        return this.price;
    }

    @JsonProperty(value="quantity")
    public Optional<Integer> getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="singular_name")
    public Optional<String> getSingularName() {
        return this.singularName;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="unit_price")
    public Optional<BillingProductPriceResponseData> getUnitPrice() {
        return this.unitPrice;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingCreditBundleView && this.equalTo((BillingCreditBundleView)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingCreditBundleView other) {
        return this.billingInvoiceId.equals(other.billingInvoiceId) && this.bundleType.equals(other.bundleType) && this.createdAt.equals(other.createdAt) && this.creditDescription.equals(other.creditDescription) && this.creditIcon.equals(other.creditIcon) && this.creditId.equals(other.creditId) && this.creditName.equals(other.creditName) && this.expiryType.equals(other.expiryType) && this.expiryUnit.equals(other.expiryUnit) && this.expiryUnitCount.equals(other.expiryUnitCount) && this.hasGrants == other.hasGrants && this.id.equals(other.id) && this.name.equals(other.name) && this.pluralName.equals(other.pluralName) && this.price.equals(other.price) && this.quantity.equals(other.quantity) && this.singularName.equals(other.singularName) && this.status.equals(other.status) && this.unitPrice.equals(other.unitPrice) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.billingInvoiceId, this.bundleType, this.createdAt, this.creditDescription, this.creditIcon, this.creditId, this.creditName, this.expiryType, this.expiryUnit, this.expiryUnitCount, this.hasGrants, this.id, this.name, this.pluralName, this.price, this.quantity, this.singularName, this.status, this.unitPrice, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BundleTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BundleTypeStage,
    CreatedAtStage,
    CreditIdStage,
    CreditNameStage,
    ExpiryTypeStage,
    ExpiryUnitStage,
    HasGrantsStage,
    IdStage,
    NameStage,
    StatusStage,
    UpdatedAtStage,
    _FinalStage {
        private String bundleType;
        private OffsetDateTime createdAt;
        private String creditId;
        private String creditName;
        private String expiryType;
        private String expiryUnit;
        private boolean hasGrants;
        private String id;
        private String name;
        private String status;
        private OffsetDateTime updatedAt;
        private Optional<BillingProductPriceResponseData> unitPrice = Optional.empty();
        private Optional<String> singularName = Optional.empty();
        private Optional<Integer> quantity = Optional.empty();
        private Optional<BillingProductPriceResponseData> price = Optional.empty();
        private Optional<String> pluralName = Optional.empty();
        private Optional<Integer> expiryUnitCount = Optional.empty();
        private Optional<String> creditIcon = Optional.empty();
        private Optional<String> creditDescription = Optional.empty();
        private Optional<String> billingInvoiceId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingCreditBundleView other) {
            this.billingInvoiceId(other.getBillingInvoiceId());
            this.bundleType(other.getBundleType());
            this.createdAt(other.getCreatedAt());
            this.creditDescription(other.getCreditDescription());
            this.creditIcon(other.getCreditIcon());
            this.creditId(other.getCreditId());
            this.creditName(other.getCreditName());
            this.expiryType(other.getExpiryType());
            this.expiryUnit(other.getExpiryUnit());
            this.expiryUnitCount(other.getExpiryUnitCount());
            this.hasGrants(other.getHasGrants());
            this.id(other.getId());
            this.name(other.getName());
            this.pluralName(other.getPluralName());
            this.price(other.getPrice());
            this.quantity(other.getQuantity());
            this.singularName(other.getSingularName());
            this.status(other.getStatus());
            this.unitPrice(other.getUnitPrice());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="bundle_type")
        public CreatedAtStage bundleType(@NotNull String bundleType) {
            this.bundleType = Objects.requireNonNull(bundleType, "bundleType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public CreditIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="credit_id")
        public CreditNameStage creditId(@NotNull String creditId) {
            this.creditId = Objects.requireNonNull(creditId, "creditId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="credit_name")
        public ExpiryTypeStage creditName(@NotNull String creditName) {
            this.creditName = Objects.requireNonNull(creditName, "creditName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="expiry_type")
        public ExpiryUnitStage expiryType(@NotNull String expiryType) {
            this.expiryType = Objects.requireNonNull(expiryType, "expiryType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="expiry_unit")
        public HasGrantsStage expiryUnit(@NotNull String expiryUnit) {
            this.expiryUnit = Objects.requireNonNull(expiryUnit, "expiryUnit must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="has_grants")
        public IdStage hasGrants(boolean hasGrants) {
            this.hasGrants = hasGrants;
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public StatusStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public UpdatedAtStage status(@NotNull String status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage unitPrice(BillingProductPriceResponseData unitPrice) {
            this.unitPrice = Optional.ofNullable(unitPrice);
            return this;
        }

        @Override
        @JsonSetter(value="unit_price", nulls=Nulls.SKIP)
        public _FinalStage unitPrice(Optional<BillingProductPriceResponseData> unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        @Override
        public _FinalStage singularName(String singularName) {
            this.singularName = Optional.ofNullable(singularName);
            return this;
        }

        @Override
        @JsonSetter(value="singular_name", nulls=Nulls.SKIP)
        public _FinalStage singularName(Optional<String> singularName) {
            this.singularName = singularName;
            return this;
        }

        @Override
        public _FinalStage quantity(Integer quantity) {
            this.quantity = Optional.ofNullable(quantity);
            return this;
        }

        @Override
        @JsonSetter(value="quantity", nulls=Nulls.SKIP)
        public _FinalStage quantity(Optional<Integer> quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public _FinalStage price(BillingProductPriceResponseData price) {
            this.price = Optional.ofNullable(price);
            return this;
        }

        @Override
        @JsonSetter(value="price", nulls=Nulls.SKIP)
        public _FinalStage price(Optional<BillingProductPriceResponseData> price) {
            this.price = price;
            return this;
        }

        @Override
        public _FinalStage pluralName(String pluralName) {
            this.pluralName = Optional.ofNullable(pluralName);
            return this;
        }

        @Override
        @JsonSetter(value="plural_name", nulls=Nulls.SKIP)
        public _FinalStage pluralName(Optional<String> pluralName) {
            this.pluralName = pluralName;
            return this;
        }

        @Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_unit_count", nulls=Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @Override
        public _FinalStage creditIcon(String creditIcon) {
            this.creditIcon = Optional.ofNullable(creditIcon);
            return this;
        }

        @Override
        @JsonSetter(value="credit_icon", nulls=Nulls.SKIP)
        public _FinalStage creditIcon(Optional<String> creditIcon) {
            this.creditIcon = creditIcon;
            return this;
        }

        @Override
        public _FinalStage creditDescription(String creditDescription) {
            this.creditDescription = Optional.ofNullable(creditDescription);
            return this;
        }

        @Override
        @JsonSetter(value="credit_description", nulls=Nulls.SKIP)
        public _FinalStage creditDescription(Optional<String> creditDescription) {
            this.creditDescription = creditDescription;
            return this;
        }

        @Override
        public _FinalStage billingInvoiceId(String billingInvoiceId) {
            this.billingInvoiceId = Optional.ofNullable(billingInvoiceId);
            return this;
        }

        @Override
        @JsonSetter(value="billing_invoice_id", nulls=Nulls.SKIP)
        public _FinalStage billingInvoiceId(Optional<String> billingInvoiceId) {
            this.billingInvoiceId = billingInvoiceId;
            return this;
        }

        @Override
        public BillingCreditBundleView build() {
            return new BillingCreditBundleView(this.billingInvoiceId, this.bundleType, this.createdAt, this.creditDescription, this.creditIcon, this.creditId, this.creditName, this.expiryType, this.expiryUnit, this.expiryUnitCount, this.hasGrants, this.id, this.name, this.pluralName, this.price, this.quantity, this.singularName, this.status, this.unitPrice, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingCreditBundleView build();

        public _FinalStage billingInvoiceId(Optional<String> var1);

        public _FinalStage billingInvoiceId(String var1);

        public _FinalStage creditDescription(Optional<String> var1);

        public _FinalStage creditDescription(String var1);

        public _FinalStage creditIcon(Optional<String> var1);

        public _FinalStage creditIcon(String var1);

        public _FinalStage expiryUnitCount(Optional<Integer> var1);

        public _FinalStage expiryUnitCount(Integer var1);

        public _FinalStage pluralName(Optional<String> var1);

        public _FinalStage pluralName(String var1);

        public _FinalStage price(Optional<BillingProductPriceResponseData> var1);

        public _FinalStage price(BillingProductPriceResponseData var1);

        public _FinalStage quantity(Optional<Integer> var1);

        public _FinalStage quantity(Integer var1);

        public _FinalStage singularName(Optional<String> var1);

        public _FinalStage singularName(String var1);

        public _FinalStage unitPrice(Optional<BillingProductPriceResponseData> var1);

        public _FinalStage unitPrice(BillingProductPriceResponseData var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface StatusStage {
        public UpdatedAtStage status(@NotNull String var1);
    }

    public static interface NameStage {
        public StatusStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface HasGrantsStage {
        public IdStage hasGrants(boolean var1);
    }

    public static interface ExpiryUnitStage {
        public HasGrantsStage expiryUnit(@NotNull String var1);
    }

    public static interface ExpiryTypeStage {
        public ExpiryUnitStage expiryType(@NotNull String var1);
    }

    public static interface CreditNameStage {
        public ExpiryTypeStage creditName(@NotNull String var1);
    }

    public static interface CreditIdStage {
        public CreditNameStage creditId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public CreditIdStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface BundleTypeStage {
        public CreatedAtStage bundleType(@NotNull String var1);

        public Builder from(BillingCreditBundleView var1);
    }
}

