/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingPriceResponseData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingCreditGrantResponseData {
    private final String companyId;
    private final String companyName;
    private final OffsetDateTime createdAt;
    private final Optional<String> creditIcon;
    private final String creditId;
    private final String creditName;
    private final Optional<OffsetDateTime> expiresAt;
    private final String grantReason;
    private final String id;
    private final Optional<String> planId;
    private final Optional<String> planName;
    private final Optional<BillingPriceResponseData> price;
    private final int quantity;
    private final double quantityRemaining;
    private final double quantityUsed;
    private final String sourceLabel;
    private final OffsetDateTime updatedAt;
    private final Optional<OffsetDateTime> validFrom;
    private final Optional<OffsetDateTime> zeroedOutDate;
    private final Optional<String> zeroedOutReason;
    private final Map<String, Object> additionalProperties;

    private BillingCreditGrantResponseData(String companyId, String companyName, OffsetDateTime createdAt, Optional<String> creditIcon, String creditId, String creditName, Optional<OffsetDateTime> expiresAt, String grantReason, String id, Optional<String> planId, Optional<String> planName, Optional<BillingPriceResponseData> price, int quantity, double quantityRemaining, double quantityUsed, String sourceLabel, OffsetDateTime updatedAt, Optional<OffsetDateTime> validFrom, Optional<OffsetDateTime> zeroedOutDate, Optional<String> zeroedOutReason, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.companyName = companyName;
        this.createdAt = createdAt;
        this.creditIcon = creditIcon;
        this.creditId = creditId;
        this.creditName = creditName;
        this.expiresAt = expiresAt;
        this.grantReason = grantReason;
        this.id = id;
        this.planId = planId;
        this.planName = planName;
        this.price = price;
        this.quantity = quantity;
        this.quantityRemaining = quantityRemaining;
        this.quantityUsed = quantityUsed;
        this.sourceLabel = sourceLabel;
        this.updatedAt = updatedAt;
        this.validFrom = validFrom;
        this.zeroedOutDate = zeroedOutDate;
        this.zeroedOutReason = zeroedOutReason;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="company_name")
    public String getCompanyName() {
        return this.companyName;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="credit_icon")
    public Optional<String> getCreditIcon() {
        return this.creditIcon;
    }

    @JsonProperty(value="credit_id")
    public String getCreditId() {
        return this.creditId;
    }

    @JsonProperty(value="credit_name")
    public String getCreditName() {
        return this.creditName;
    }

    @JsonProperty(value="expires_at")
    public Optional<OffsetDateTime> getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="grant_reason")
    public String getGrantReason() {
        return this.grantReason;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="plan_id")
    public Optional<String> getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="plan_name")
    public Optional<String> getPlanName() {
        return this.planName;
    }

    @JsonProperty(value="price")
    public Optional<BillingPriceResponseData> getPrice() {
        return this.price;
    }

    @JsonProperty(value="quantity")
    public int getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity_remaining")
    public double getQuantityRemaining() {
        return this.quantityRemaining;
    }

    @JsonProperty(value="quantity_used")
    public double getQuantityUsed() {
        return this.quantityUsed;
    }

    @JsonProperty(value="source_label")
    public String getSourceLabel() {
        return this.sourceLabel;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="valid_from")
    public Optional<OffsetDateTime> getValidFrom() {
        return this.validFrom;
    }

    @JsonProperty(value="zeroed_out_date")
    public Optional<OffsetDateTime> getZeroedOutDate() {
        return this.zeroedOutDate;
    }

    @JsonProperty(value="zeroed_out_reason")
    public Optional<String> getZeroedOutReason() {
        return this.zeroedOutReason;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingCreditGrantResponseData && this.equalTo((BillingCreditGrantResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingCreditGrantResponseData other) {
        return this.companyId.equals(other.companyId) && this.companyName.equals(other.companyName) && this.createdAt.equals(other.createdAt) && this.creditIcon.equals(other.creditIcon) && this.creditId.equals(other.creditId) && this.creditName.equals(other.creditName) && this.expiresAt.equals(other.expiresAt) && this.grantReason.equals(other.grantReason) && this.id.equals(other.id) && this.planId.equals(other.planId) && this.planName.equals(other.planName) && this.price.equals(other.price) && this.quantity == other.quantity && this.quantityRemaining == other.quantityRemaining && this.quantityUsed == other.quantityUsed && this.sourceLabel.equals(other.sourceLabel) && this.updatedAt.equals(other.updatedAt) && this.validFrom.equals(other.validFrom) && this.zeroedOutDate.equals(other.zeroedOutDate) && this.zeroedOutReason.equals(other.zeroedOutReason);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.companyName, this.createdAt, this.creditIcon, this.creditId, this.creditName, this.expiresAt, this.grantReason, this.id, this.planId, this.planName, this.price, this.quantity, this.quantityRemaining, this.quantityUsed, this.sourceLabel, this.updatedAt, this.validFrom, this.zeroedOutDate, this.zeroedOutReason);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CompanyIdStage,
    CompanyNameStage,
    CreatedAtStage,
    CreditIdStage,
    CreditNameStage,
    GrantReasonStage,
    IdStage,
    QuantityStage,
    QuantityRemainingStage,
    QuantityUsedStage,
    SourceLabelStage,
    UpdatedAtStage,
    _FinalStage {
        private String companyId;
        private String companyName;
        private OffsetDateTime createdAt;
        private String creditId;
        private String creditName;
        private String grantReason;
        private String id;
        private int quantity;
        private double quantityRemaining;
        private double quantityUsed;
        private String sourceLabel;
        private OffsetDateTime updatedAt;
        private Optional<String> zeroedOutReason = Optional.empty();
        private Optional<OffsetDateTime> zeroedOutDate = Optional.empty();
        private Optional<OffsetDateTime> validFrom = Optional.empty();
        private Optional<BillingPriceResponseData> price = Optional.empty();
        private Optional<String> planName = Optional.empty();
        private Optional<String> planId = Optional.empty();
        private Optional<OffsetDateTime> expiresAt = Optional.empty();
        private Optional<String> creditIcon = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingCreditGrantResponseData other) {
            this.companyId(other.getCompanyId());
            this.companyName(other.getCompanyName());
            this.createdAt(other.getCreatedAt());
            this.creditIcon(other.getCreditIcon());
            this.creditId(other.getCreditId());
            this.creditName(other.getCreditName());
            this.expiresAt(other.getExpiresAt());
            this.grantReason(other.getGrantReason());
            this.id(other.getId());
            this.planId(other.getPlanId());
            this.planName(other.getPlanName());
            this.price(other.getPrice());
            this.quantity(other.getQuantity());
            this.quantityRemaining(other.getQuantityRemaining());
            this.quantityUsed(other.getQuantityUsed());
            this.sourceLabel(other.getSourceLabel());
            this.updatedAt(other.getUpdatedAt());
            this.validFrom(other.getValidFrom());
            this.zeroedOutDate(other.getZeroedOutDate());
            this.zeroedOutReason(other.getZeroedOutReason());
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public CompanyNameStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="company_name")
        public CreatedAtStage companyName(@NotNull String companyName) {
            this.companyName = Objects.requireNonNull(companyName, "companyName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public CreditIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="credit_id")
        public CreditNameStage creditId(@NotNull String creditId) {
            this.creditId = Objects.requireNonNull(creditId, "creditId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="credit_name")
        public GrantReasonStage creditName(@NotNull String creditName) {
            this.creditName = Objects.requireNonNull(creditName, "creditName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="grant_reason")
        public IdStage grantReason(@NotNull String grantReason) {
            this.grantReason = Objects.requireNonNull(grantReason, "grantReason must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public QuantityStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public QuantityRemainingStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        @JsonSetter(value="quantity_remaining")
        public QuantityUsedStage quantityRemaining(double quantityRemaining) {
            this.quantityRemaining = quantityRemaining;
            return this;
        }

        @Override
        @JsonSetter(value="quantity_used")
        public SourceLabelStage quantityUsed(double quantityUsed) {
            this.quantityUsed = quantityUsed;
            return this;
        }

        @Override
        @JsonSetter(value="source_label")
        public UpdatedAtStage sourceLabel(@NotNull String sourceLabel) {
            this.sourceLabel = Objects.requireNonNull(sourceLabel, "sourceLabel must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage zeroedOutReason(String zeroedOutReason) {
            this.zeroedOutReason = Optional.ofNullable(zeroedOutReason);
            return this;
        }

        @Override
        @JsonSetter(value="zeroed_out_reason", nulls=Nulls.SKIP)
        public _FinalStage zeroedOutReason(Optional<String> zeroedOutReason) {
            this.zeroedOutReason = zeroedOutReason;
            return this;
        }

        @Override
        public _FinalStage zeroedOutDate(OffsetDateTime zeroedOutDate) {
            this.zeroedOutDate = Optional.ofNullable(zeroedOutDate);
            return this;
        }

        @Override
        @JsonSetter(value="zeroed_out_date", nulls=Nulls.SKIP)
        public _FinalStage zeroedOutDate(Optional<OffsetDateTime> zeroedOutDate) {
            this.zeroedOutDate = zeroedOutDate;
            return this;
        }

        @Override
        public _FinalStage validFrom(OffsetDateTime validFrom) {
            this.validFrom = Optional.ofNullable(validFrom);
            return this;
        }

        @Override
        @JsonSetter(value="valid_from", nulls=Nulls.SKIP)
        public _FinalStage validFrom(Optional<OffsetDateTime> validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        @Override
        public _FinalStage price(BillingPriceResponseData price) {
            this.price = Optional.ofNullable(price);
            return this;
        }

        @Override
        @JsonSetter(value="price", nulls=Nulls.SKIP)
        public _FinalStage price(Optional<BillingPriceResponseData> price) {
            this.price = price;
            return this;
        }

        @Override
        public _FinalStage planName(String planName) {
            this.planName = Optional.ofNullable(planName);
            return this;
        }

        @Override
        @JsonSetter(value="plan_name", nulls=Nulls.SKIP)
        public _FinalStage planName(Optional<String> planName) {
            this.planName = planName;
            return this;
        }

        @Override
        public _FinalStage planId(String planId) {
            this.planId = Optional.ofNullable(planId);
            return this;
        }

        @Override
        @JsonSetter(value="plan_id", nulls=Nulls.SKIP)
        public _FinalStage planId(Optional<String> planId) {
            this.planId = planId;
            return this;
        }

        @Override
        public _FinalStage expiresAt(OffsetDateTime expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        @Override
        @JsonSetter(value="expires_at", nulls=Nulls.SKIP)
        public _FinalStage expiresAt(Optional<OffsetDateTime> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public _FinalStage creditIcon(String creditIcon) {
            this.creditIcon = Optional.ofNullable(creditIcon);
            return this;
        }

        @Override
        @JsonSetter(value="credit_icon", nulls=Nulls.SKIP)
        public _FinalStage creditIcon(Optional<String> creditIcon) {
            this.creditIcon = creditIcon;
            return this;
        }

        @Override
        public BillingCreditGrantResponseData build() {
            return new BillingCreditGrantResponseData(this.companyId, this.companyName, this.createdAt, this.creditIcon, this.creditId, this.creditName, this.expiresAt, this.grantReason, this.id, this.planId, this.planName, this.price, this.quantity, this.quantityRemaining, this.quantityUsed, this.sourceLabel, this.updatedAt, this.validFrom, this.zeroedOutDate, this.zeroedOutReason, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingCreditGrantResponseData build();

        public _FinalStage creditIcon(Optional<String> var1);

        public _FinalStage creditIcon(String var1);

        public _FinalStage expiresAt(Optional<OffsetDateTime> var1);

        public _FinalStage expiresAt(OffsetDateTime var1);

        public _FinalStage planId(Optional<String> var1);

        public _FinalStage planId(String var1);

        public _FinalStage planName(Optional<String> var1);

        public _FinalStage planName(String var1);

        public _FinalStage price(Optional<BillingPriceResponseData> var1);

        public _FinalStage price(BillingPriceResponseData var1);

        public _FinalStage validFrom(Optional<OffsetDateTime> var1);

        public _FinalStage validFrom(OffsetDateTime var1);

        public _FinalStage zeroedOutDate(Optional<OffsetDateTime> var1);

        public _FinalStage zeroedOutDate(OffsetDateTime var1);

        public _FinalStage zeroedOutReason(Optional<String> var1);

        public _FinalStage zeroedOutReason(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface SourceLabelStage {
        public UpdatedAtStage sourceLabel(@NotNull String var1);
    }

    public static interface QuantityUsedStage {
        public SourceLabelStage quantityUsed(double var1);
    }

    public static interface QuantityRemainingStage {
        public QuantityUsedStage quantityRemaining(double var1);
    }

    public static interface QuantityStage {
        public QuantityRemainingStage quantity(int var1);
    }

    public static interface IdStage {
        public QuantityStage id(@NotNull String var1);
    }

    public static interface GrantReasonStage {
        public IdStage grantReason(@NotNull String var1);
    }

    public static interface CreditNameStage {
        public GrantReasonStage creditName(@NotNull String var1);
    }

    public static interface CreditIdStage {
        public CreditNameStage creditId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public CreditIdStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface CompanyNameStage {
        public CreatedAtStage companyName(@NotNull String var1);
    }

    public static interface CompanyIdStage {
        public CompanyNameStage companyId(@NotNull String var1);

        public Builder from(BillingCreditGrantResponseData var1);
    }
}

