/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingCreditLedgerResponseData {
    private final Optional<String> description;
    private final Optional<String> icon;
    private final String id;
    private final String name;
    private final Optional<String> pluralName;
    private final Optional<String> singularName;
    private final Map<String, Object> additionalProperties;

    private BillingCreditLedgerResponseData(Optional<String> description, Optional<String> icon, String id, String name, Optional<String> pluralName, Optional<String> singularName, Map<String, Object> additionalProperties) {
        this.description = description;
        this.icon = icon;
        this.id = id;
        this.name = name;
        this.pluralName = pluralName;
        this.singularName = singularName;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="icon")
    public Optional<String> getIcon() {
        return this.icon;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="plural_name")
    public Optional<String> getPluralName() {
        return this.pluralName;
    }

    @JsonProperty(value="singular_name")
    public Optional<String> getSingularName() {
        return this.singularName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingCreditLedgerResponseData && this.equalTo((BillingCreditLedgerResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingCreditLedgerResponseData other) {
        return this.description.equals(other.description) && this.icon.equals(other.icon) && this.id.equals(other.id) && this.name.equals(other.name) && this.pluralName.equals(other.pluralName) && this.singularName.equals(other.singularName);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.icon, this.id, this.name, this.pluralName, this.singularName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    _FinalStage {
        private String id;
        private String name;
        private Optional<String> singularName = Optional.empty();
        private Optional<String> pluralName = Optional.empty();
        private Optional<String> icon = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingCreditLedgerResponseData other) {
            this.description(other.getDescription());
            this.icon(other.getIcon());
            this.id(other.getId());
            this.name(other.getName());
            this.pluralName(other.getPluralName());
            this.singularName(other.getSingularName());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage singularName(String singularName) {
            this.singularName = Optional.ofNullable(singularName);
            return this;
        }

        @Override
        @JsonSetter(value="singular_name", nulls=Nulls.SKIP)
        public _FinalStage singularName(Optional<String> singularName) {
            this.singularName = singularName;
            return this;
        }

        @Override
        public _FinalStage pluralName(String pluralName) {
            this.pluralName = Optional.ofNullable(pluralName);
            return this;
        }

        @Override
        @JsonSetter(value="plural_name", nulls=Nulls.SKIP)
        public _FinalStage pluralName(Optional<String> pluralName) {
            this.pluralName = pluralName;
            return this;
        }

        @Override
        public _FinalStage icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        @Override
        @JsonSetter(value="icon", nulls=Nulls.SKIP)
        public _FinalStage icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public BillingCreditLedgerResponseData build() {
            return new BillingCreditLedgerResponseData(this.description, this.icon, this.id, this.name, this.pluralName, this.singularName, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingCreditLedgerResponseData build();

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage icon(Optional<String> var1);

        public _FinalStage icon(String var1);

        public _FinalStage pluralName(Optional<String> var1);

        public _FinalStage pluralName(String var1);

        public _FinalStage singularName(Optional<String> var1);

        public _FinalStage singularName(String var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(BillingCreditLedgerResponseData var1);
    }
}

