/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingPriceResponseData;
import com.schematic.api.types.BillingProductResponseData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingCreditResponseData {
    private final String burnStrategy;
    private final OffsetDateTime createdAt;
    private final String defaultExpiryUnit;
    private final Optional<Integer> defaultExpiryUnitCount;
    private final String defaultRolloverPolicy;
    private final String description;
    private final Optional<String> icon;
    private final String id;
    private final String name;
    private final Optional<String> pluralName;
    private final Optional<BillingPriceResponseData> price;
    private final Optional<BillingProductResponseData> product;
    private final Optional<String> singularName;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private BillingCreditResponseData(String burnStrategy, OffsetDateTime createdAt, String defaultExpiryUnit, Optional<Integer> defaultExpiryUnitCount, String defaultRolloverPolicy, String description, Optional<String> icon, String id, String name, Optional<String> pluralName, Optional<BillingPriceResponseData> price, Optional<BillingProductResponseData> product, Optional<String> singularName, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.burnStrategy = burnStrategy;
        this.createdAt = createdAt;
        this.defaultExpiryUnit = defaultExpiryUnit;
        this.defaultExpiryUnitCount = defaultExpiryUnitCount;
        this.defaultRolloverPolicy = defaultRolloverPolicy;
        this.description = description;
        this.icon = icon;
        this.id = id;
        this.name = name;
        this.pluralName = pluralName;
        this.price = price;
        this.product = product;
        this.singularName = singularName;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="burn_strategy")
    public String getBurnStrategy() {
        return this.burnStrategy;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="default_expiry_unit")
    public String getDefaultExpiryUnit() {
        return this.defaultExpiryUnit;
    }

    @JsonProperty(value="default_expiry_unit_count")
    public Optional<Integer> getDefaultExpiryUnitCount() {
        return this.defaultExpiryUnitCount;
    }

    @JsonProperty(value="default_rollover_policy")
    public String getDefaultRolloverPolicy() {
        return this.defaultRolloverPolicy;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="icon")
    public Optional<String> getIcon() {
        return this.icon;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="plural_name")
    public Optional<String> getPluralName() {
        return this.pluralName;
    }

    @JsonProperty(value="price")
    public Optional<BillingPriceResponseData> getPrice() {
        return this.price;
    }

    @JsonProperty(value="product")
    public Optional<BillingProductResponseData> getProduct() {
        return this.product;
    }

    @JsonProperty(value="singular_name")
    public Optional<String> getSingularName() {
        return this.singularName;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingCreditResponseData && this.equalTo((BillingCreditResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingCreditResponseData other) {
        return this.burnStrategy.equals(other.burnStrategy) && this.createdAt.equals(other.createdAt) && this.defaultExpiryUnit.equals(other.defaultExpiryUnit) && this.defaultExpiryUnitCount.equals(other.defaultExpiryUnitCount) && this.defaultRolloverPolicy.equals(other.defaultRolloverPolicy) && this.description.equals(other.description) && this.icon.equals(other.icon) && this.id.equals(other.id) && this.name.equals(other.name) && this.pluralName.equals(other.pluralName) && this.price.equals(other.price) && this.product.equals(other.product) && this.singularName.equals(other.singularName) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.burnStrategy, this.createdAt, this.defaultExpiryUnit, this.defaultExpiryUnitCount, this.defaultRolloverPolicy, this.description, this.icon, this.id, this.name, this.pluralName, this.price, this.product, this.singularName, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BurnStrategyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BurnStrategyStage,
    CreatedAtStage,
    DefaultExpiryUnitStage,
    DefaultRolloverPolicyStage,
    DescriptionStage,
    IdStage,
    NameStage,
    UpdatedAtStage,
    _FinalStage {
        private String burnStrategy;
        private OffsetDateTime createdAt;
        private String defaultExpiryUnit;
        private String defaultRolloverPolicy;
        private String description;
        private String id;
        private String name;
        private OffsetDateTime updatedAt;
        private Optional<String> singularName = Optional.empty();
        private Optional<BillingProductResponseData> product = Optional.empty();
        private Optional<BillingPriceResponseData> price = Optional.empty();
        private Optional<String> pluralName = Optional.empty();
        private Optional<String> icon = Optional.empty();
        private Optional<Integer> defaultExpiryUnitCount = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingCreditResponseData other) {
            this.burnStrategy(other.getBurnStrategy());
            this.createdAt(other.getCreatedAt());
            this.defaultExpiryUnit(other.getDefaultExpiryUnit());
            this.defaultExpiryUnitCount(other.getDefaultExpiryUnitCount());
            this.defaultRolloverPolicy(other.getDefaultRolloverPolicy());
            this.description(other.getDescription());
            this.icon(other.getIcon());
            this.id(other.getId());
            this.name(other.getName());
            this.pluralName(other.getPluralName());
            this.price(other.getPrice());
            this.product(other.getProduct());
            this.singularName(other.getSingularName());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="burn_strategy")
        public CreatedAtStage burnStrategy(@NotNull String burnStrategy) {
            this.burnStrategy = Objects.requireNonNull(burnStrategy, "burnStrategy must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public DefaultExpiryUnitStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="default_expiry_unit")
        public DefaultRolloverPolicyStage defaultExpiryUnit(@NotNull String defaultExpiryUnit) {
            this.defaultExpiryUnit = Objects.requireNonNull(defaultExpiryUnit, "defaultExpiryUnit must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="default_rollover_policy")
        public DescriptionStage defaultRolloverPolicy(@NotNull String defaultRolloverPolicy) {
            this.defaultRolloverPolicy = Objects.requireNonNull(defaultRolloverPolicy, "defaultRolloverPolicy must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public IdStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage singularName(String singularName) {
            this.singularName = Optional.ofNullable(singularName);
            return this;
        }

        @Override
        @JsonSetter(value="singular_name", nulls=Nulls.SKIP)
        public _FinalStage singularName(Optional<String> singularName) {
            this.singularName = singularName;
            return this;
        }

        @Override
        public _FinalStage product(BillingProductResponseData product) {
            this.product = Optional.ofNullable(product);
            return this;
        }

        @Override
        @JsonSetter(value="product", nulls=Nulls.SKIP)
        public _FinalStage product(Optional<BillingProductResponseData> product) {
            this.product = product;
            return this;
        }

        @Override
        public _FinalStage price(BillingPriceResponseData price) {
            this.price = Optional.ofNullable(price);
            return this;
        }

        @Override
        @JsonSetter(value="price", nulls=Nulls.SKIP)
        public _FinalStage price(Optional<BillingPriceResponseData> price) {
            this.price = price;
            return this;
        }

        @Override
        public _FinalStage pluralName(String pluralName) {
            this.pluralName = Optional.ofNullable(pluralName);
            return this;
        }

        @Override
        @JsonSetter(value="plural_name", nulls=Nulls.SKIP)
        public _FinalStage pluralName(Optional<String> pluralName) {
            this.pluralName = pluralName;
            return this;
        }

        @Override
        public _FinalStage icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        @Override
        @JsonSetter(value="icon", nulls=Nulls.SKIP)
        public _FinalStage icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public _FinalStage defaultExpiryUnitCount(Integer defaultExpiryUnitCount) {
            this.defaultExpiryUnitCount = Optional.ofNullable(defaultExpiryUnitCount);
            return this;
        }

        @Override
        @JsonSetter(value="default_expiry_unit_count", nulls=Nulls.SKIP)
        public _FinalStage defaultExpiryUnitCount(Optional<Integer> defaultExpiryUnitCount) {
            this.defaultExpiryUnitCount = defaultExpiryUnitCount;
            return this;
        }

        @Override
        public BillingCreditResponseData build() {
            return new BillingCreditResponseData(this.burnStrategy, this.createdAt, this.defaultExpiryUnit, this.defaultExpiryUnitCount, this.defaultRolloverPolicy, this.description, this.icon, this.id, this.name, this.pluralName, this.price, this.product, this.singularName, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingCreditResponseData build();

        public _FinalStage defaultExpiryUnitCount(Optional<Integer> var1);

        public _FinalStage defaultExpiryUnitCount(Integer var1);

        public _FinalStage icon(Optional<String> var1);

        public _FinalStage icon(String var1);

        public _FinalStage pluralName(Optional<String> var1);

        public _FinalStage pluralName(String var1);

        public _FinalStage price(Optional<BillingPriceResponseData> var1);

        public _FinalStage price(BillingPriceResponseData var1);

        public _FinalStage product(Optional<BillingProductResponseData> var1);

        public _FinalStage product(BillingProductResponseData var1);

        public _FinalStage singularName(Optional<String> var1);

        public _FinalStage singularName(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface NameStage {
        public UpdatedAtStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public IdStage description(@NotNull String var1);
    }

    public static interface DefaultRolloverPolicyStage {
        public DescriptionStage defaultRolloverPolicy(@NotNull String var1);
    }

    public static interface DefaultExpiryUnitStage {
        public DefaultRolloverPolicyStage defaultExpiryUnit(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public DefaultExpiryUnitStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface BurnStrategyStage {
        public CreatedAtStage burnStrategy(@NotNull String var1);

        public Builder from(BillingCreditResponseData var1);
    }
}

