/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingCustomerSubscription {
    private final String currency;
    private final Optional<OffsetDateTime> expiredAt;
    private final String interval;
    private final boolean meteredUsage;
    private final int perUnitPrice;
    private final int totalPrice;
    private final Map<String, Object> additionalProperties;

    private BillingCustomerSubscription(String currency, Optional<OffsetDateTime> expiredAt, String interval, boolean meteredUsage, int perUnitPrice, int totalPrice, Map<String, Object> additionalProperties) {
        this.currency = currency;
        this.expiredAt = expiredAt;
        this.interval = interval;
        this.meteredUsage = meteredUsage;
        this.perUnitPrice = perUnitPrice;
        this.totalPrice = totalPrice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="expired_at")
    public Optional<OffsetDateTime> getExpiredAt() {
        return this.expiredAt;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="metered_usage")
    public boolean getMeteredUsage() {
        return this.meteredUsage;
    }

    @JsonProperty(value="per_unit_price")
    public int getPerUnitPrice() {
        return this.perUnitPrice;
    }

    @JsonProperty(value="total_price")
    public int getTotalPrice() {
        return this.totalPrice;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingCustomerSubscription && this.equalTo((BillingCustomerSubscription)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingCustomerSubscription other) {
        return this.currency.equals(other.currency) && this.expiredAt.equals(other.expiredAt) && this.interval.equals(other.interval) && this.meteredUsage == other.meteredUsage && this.perUnitPrice == other.perUnitPrice && this.totalPrice == other.totalPrice;
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.expiredAt, this.interval, this.meteredUsage, this.perUnitPrice, this.totalPrice);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CurrencyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CurrencyStage,
    IntervalStage,
    MeteredUsageStage,
    PerUnitPriceStage,
    TotalPriceStage,
    _FinalStage {
        private String currency;
        private String interval;
        private boolean meteredUsage;
        private int perUnitPrice;
        private int totalPrice;
        private Optional<OffsetDateTime> expiredAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingCustomerSubscription other) {
            this.currency(other.getCurrency());
            this.expiredAt(other.getExpiredAt());
            this.interval(other.getInterval());
            this.meteredUsage(other.getMeteredUsage());
            this.perUnitPrice(other.getPerUnitPrice());
            this.totalPrice(other.getTotalPrice());
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public IntervalStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="interval")
        public MeteredUsageStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="metered_usage")
        public PerUnitPriceStage meteredUsage(boolean meteredUsage) {
            this.meteredUsage = meteredUsage;
            return this;
        }

        @Override
        @JsonSetter(value="per_unit_price")
        public TotalPriceStage perUnitPrice(int perUnitPrice) {
            this.perUnitPrice = perUnitPrice;
            return this;
        }

        @Override
        @JsonSetter(value="total_price")
        public _FinalStage totalPrice(int totalPrice) {
            this.totalPrice = totalPrice;
            return this;
        }

        @Override
        public _FinalStage expiredAt(OffsetDateTime expiredAt) {
            this.expiredAt = Optional.ofNullable(expiredAt);
            return this;
        }

        @Override
        @JsonSetter(value="expired_at", nulls=Nulls.SKIP)
        public _FinalStage expiredAt(Optional<OffsetDateTime> expiredAt) {
            this.expiredAt = expiredAt;
            return this;
        }

        @Override
        public BillingCustomerSubscription build() {
            return new BillingCustomerSubscription(this.currency, this.expiredAt, this.interval, this.meteredUsage, this.perUnitPrice, this.totalPrice, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingCustomerSubscription build();

        public _FinalStage expiredAt(Optional<OffsetDateTime> var1);

        public _FinalStage expiredAt(OffsetDateTime var1);
    }

    public static interface TotalPriceStage {
        public _FinalStage totalPrice(int var1);
    }

    public static interface PerUnitPriceStage {
        public TotalPriceStage perUnitPrice(int var1);
    }

    public static interface MeteredUsageStage {
        public PerUnitPriceStage meteredUsage(boolean var1);
    }

    public static interface IntervalStage {
        public MeteredUsageStage interval(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public IntervalStage currency(@NotNull String var1);

        public Builder from(BillingCustomerSubscription var1);
    }
}

