/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingPlanCreditGrantResponseData {
    private final OffsetDateTime createdAt;
    private final int creditAmount;
    private final String creditId;
    private final String creditName;
    private final Optional<String> creditPluralName;
    private final Optional<String> creditSingularName;
    private final Optional<String> expiryType;
    private final Optional<String> expiryUnit;
    private final Optional<Integer> expiryUnitCount;
    private final String id;
    private final String planId;
    private final String planName;
    private final String resetCadence;
    private final String resetStart;
    private final Optional<String> resetType;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private BillingPlanCreditGrantResponseData(OffsetDateTime createdAt, int creditAmount, String creditId, String creditName, Optional<String> creditPluralName, Optional<String> creditSingularName, Optional<String> expiryType, Optional<String> expiryUnit, Optional<Integer> expiryUnitCount, String id, String planId, String planName, String resetCadence, String resetStart, Optional<String> resetType, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.creditAmount = creditAmount;
        this.creditId = creditId;
        this.creditName = creditName;
        this.creditPluralName = creditPluralName;
        this.creditSingularName = creditSingularName;
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.id = id;
        this.planId = planId;
        this.planName = planName;
        this.resetCadence = resetCadence;
        this.resetStart = resetStart;
        this.resetType = resetType;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="credit_amount")
    public int getCreditAmount() {
        return this.creditAmount;
    }

    @JsonProperty(value="credit_id")
    public String getCreditId() {
        return this.creditId;
    }

    @JsonProperty(value="credit_name")
    public String getCreditName() {
        return this.creditName;
    }

    @JsonProperty(value="credit_plural_name")
    public Optional<String> getCreditPluralName() {
        return this.creditPluralName;
    }

    @JsonProperty(value="credit_singular_name")
    public Optional<String> getCreditSingularName() {
        return this.creditSingularName;
    }

    @JsonProperty(value="expiry_type")
    public Optional<String> getExpiryType() {
        return this.expiryType;
    }

    @JsonProperty(value="expiry_unit")
    public Optional<String> getExpiryUnit() {
        return this.expiryUnit;
    }

    @JsonProperty(value="expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return this.expiryUnitCount;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="plan_id")
    public String getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="plan_name")
    public String getPlanName() {
        return this.planName;
    }

    @JsonProperty(value="reset_cadence")
    public String getResetCadence() {
        return this.resetCadence;
    }

    @JsonProperty(value="reset_start")
    public String getResetStart() {
        return this.resetStart;
    }

    @JsonProperty(value="reset_type")
    public Optional<String> getResetType() {
        return this.resetType;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingPlanCreditGrantResponseData && this.equalTo((BillingPlanCreditGrantResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingPlanCreditGrantResponseData other) {
        return this.createdAt.equals(other.createdAt) && this.creditAmount == other.creditAmount && this.creditId.equals(other.creditId) && this.creditName.equals(other.creditName) && this.creditPluralName.equals(other.creditPluralName) && this.creditSingularName.equals(other.creditSingularName) && this.expiryType.equals(other.expiryType) && this.expiryUnit.equals(other.expiryUnit) && this.expiryUnitCount.equals(other.expiryUnitCount) && this.id.equals(other.id) && this.planId.equals(other.planId) && this.planName.equals(other.planName) && this.resetCadence.equals(other.resetCadence) && this.resetStart.equals(other.resetStart) && this.resetType.equals(other.resetType) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.creditAmount, this.creditId, this.creditName, this.creditPluralName, this.creditSingularName, this.expiryType, this.expiryUnit, this.expiryUnitCount, this.id, this.planId, this.planName, this.resetCadence, this.resetStart, this.resetType, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    CreditAmountStage,
    CreditIdStage,
    CreditNameStage,
    IdStage,
    PlanIdStage,
    PlanNameStage,
    ResetCadenceStage,
    ResetStartStage,
    UpdatedAtStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private int creditAmount;
        private String creditId;
        private String creditName;
        private String id;
        private String planId;
        private String planName;
        private String resetCadence;
        private String resetStart;
        private OffsetDateTime updatedAt;
        private Optional<String> resetType = Optional.empty();
        private Optional<Integer> expiryUnitCount = Optional.empty();
        private Optional<String> expiryUnit = Optional.empty();
        private Optional<String> expiryType = Optional.empty();
        private Optional<String> creditSingularName = Optional.empty();
        private Optional<String> creditPluralName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingPlanCreditGrantResponseData other) {
            this.createdAt(other.getCreatedAt());
            this.creditAmount(other.getCreditAmount());
            this.creditId(other.getCreditId());
            this.creditName(other.getCreditName());
            this.creditPluralName(other.getCreditPluralName());
            this.creditSingularName(other.getCreditSingularName());
            this.expiryType(other.getExpiryType());
            this.expiryUnit(other.getExpiryUnit());
            this.expiryUnitCount(other.getExpiryUnitCount());
            this.id(other.getId());
            this.planId(other.getPlanId());
            this.planName(other.getPlanName());
            this.resetCadence(other.getResetCadence());
            this.resetStart(other.getResetStart());
            this.resetType(other.getResetType());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public CreditAmountStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="credit_amount")
        public CreditIdStage creditAmount(int creditAmount) {
            this.creditAmount = creditAmount;
            return this;
        }

        @Override
        @JsonSetter(value="credit_id")
        public CreditNameStage creditId(@NotNull String creditId) {
            this.creditId = Objects.requireNonNull(creditId, "creditId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="credit_name")
        public IdStage creditName(@NotNull String creditName) {
            this.creditName = Objects.requireNonNull(creditName, "creditName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public PlanIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="plan_id")
        public PlanNameStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="plan_name")
        public ResetCadenceStage planName(@NotNull String planName) {
            this.planName = Objects.requireNonNull(planName, "planName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reset_cadence")
        public ResetStartStage resetCadence(@NotNull String resetCadence) {
            this.resetCadence = Objects.requireNonNull(resetCadence, "resetCadence must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reset_start")
        public UpdatedAtStage resetStart(@NotNull String resetStart) {
            this.resetStart = Objects.requireNonNull(resetStart, "resetStart must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage resetType(String resetType) {
            this.resetType = Optional.ofNullable(resetType);
            return this;
        }

        @Override
        @JsonSetter(value="reset_type", nulls=Nulls.SKIP)
        public _FinalStage resetType(Optional<String> resetType) {
            this.resetType = resetType;
            return this;
        }

        @Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_unit_count", nulls=Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @Override
        public _FinalStage expiryUnit(String expiryUnit) {
            this.expiryUnit = Optional.ofNullable(expiryUnit);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_unit", nulls=Nulls.SKIP)
        public _FinalStage expiryUnit(Optional<String> expiryUnit) {
            this.expiryUnit = expiryUnit;
            return this;
        }

        @Override
        public _FinalStage expiryType(String expiryType) {
            this.expiryType = Optional.ofNullable(expiryType);
            return this;
        }

        @Override
        @JsonSetter(value="expiry_type", nulls=Nulls.SKIP)
        public _FinalStage expiryType(Optional<String> expiryType) {
            this.expiryType = expiryType;
            return this;
        }

        @Override
        public _FinalStage creditSingularName(String creditSingularName) {
            this.creditSingularName = Optional.ofNullable(creditSingularName);
            return this;
        }

        @Override
        @JsonSetter(value="credit_singular_name", nulls=Nulls.SKIP)
        public _FinalStage creditSingularName(Optional<String> creditSingularName) {
            this.creditSingularName = creditSingularName;
            return this;
        }

        @Override
        public _FinalStage creditPluralName(String creditPluralName) {
            this.creditPluralName = Optional.ofNullable(creditPluralName);
            return this;
        }

        @Override
        @JsonSetter(value="credit_plural_name", nulls=Nulls.SKIP)
        public _FinalStage creditPluralName(Optional<String> creditPluralName) {
            this.creditPluralName = creditPluralName;
            return this;
        }

        @Override
        public BillingPlanCreditGrantResponseData build() {
            return new BillingPlanCreditGrantResponseData(this.createdAt, this.creditAmount, this.creditId, this.creditName, this.creditPluralName, this.creditSingularName, this.expiryType, this.expiryUnit, this.expiryUnitCount, this.id, this.planId, this.planName, this.resetCadence, this.resetStart, this.resetType, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingPlanCreditGrantResponseData build();

        public _FinalStage creditPluralName(Optional<String> var1);

        public _FinalStage creditPluralName(String var1);

        public _FinalStage creditSingularName(Optional<String> var1);

        public _FinalStage creditSingularName(String var1);

        public _FinalStage expiryType(Optional<String> var1);

        public _FinalStage expiryType(String var1);

        public _FinalStage expiryUnit(Optional<String> var1);

        public _FinalStage expiryUnit(String var1);

        public _FinalStage expiryUnitCount(Optional<Integer> var1);

        public _FinalStage expiryUnitCount(Integer var1);

        public _FinalStage resetType(Optional<String> var1);

        public _FinalStage resetType(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface ResetStartStage {
        public UpdatedAtStage resetStart(@NotNull String var1);
    }

    public static interface ResetCadenceStage {
        public ResetStartStage resetCadence(@NotNull String var1);
    }

    public static interface PlanNameStage {
        public ResetCadenceStage planName(@NotNull String var1);
    }

    public static interface PlanIdStage {
        public PlanNameStage planId(@NotNull String var1);
    }

    public static interface IdStage {
        public PlanIdStage id(@NotNull String var1);
    }

    public static interface CreditNameStage {
        public IdStage creditName(@NotNull String var1);
    }

    public static interface CreditIdStage {
        public CreditNameStage creditId(@NotNull String var1);
    }

    public static interface CreditAmountStage {
        public CreditIdStage creditAmount(int var1);
    }

    public static interface CreatedAtStage {
        public CreditAmountStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(BillingPlanCreditGrantResponseData var1);
    }
}

