/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingProductPriceTierResponseData;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingPriceView {
    private final String billingScheme;
    private final OffsetDateTime createdAt;
    private final String currency;
    private final String id;
    private final String interval;
    private final boolean isActive;
    private final Optional<String> meterEventName;
    private final Optional<String> meterEventPayloadKey;
    private final Optional<String> meterId;
    private final int packageSize;
    private final int price;
    private final Optional<String> priceDecimal;
    private final String priceExternalId;
    private final String priceId;
    private final List<BillingProductPriceTierResponseData> priceTier;
    private final String productExternalId;
    private final String productId;
    private final String productName;
    private final Optional<String> tiersMode;
    private final OffsetDateTime updatedAt;
    private final String usageType;
    private final Map<String, Object> additionalProperties;

    private BillingPriceView(String billingScheme, OffsetDateTime createdAt, String currency, String id, String interval, boolean isActive, Optional<String> meterEventName, Optional<String> meterEventPayloadKey, Optional<String> meterId, int packageSize, int price, Optional<String> priceDecimal, String priceExternalId, String priceId, List<BillingProductPriceTierResponseData> priceTier, String productExternalId, String productId, String productName, Optional<String> tiersMode, OffsetDateTime updatedAt, String usageType, Map<String, Object> additionalProperties) {
        this.billingScheme = billingScheme;
        this.createdAt = createdAt;
        this.currency = currency;
        this.id = id;
        this.interval = interval;
        this.isActive = isActive;
        this.meterEventName = meterEventName;
        this.meterEventPayloadKey = meterEventPayloadKey;
        this.meterId = meterId;
        this.packageSize = packageSize;
        this.price = price;
        this.priceDecimal = priceDecimal;
        this.priceExternalId = priceExternalId;
        this.priceId = priceId;
        this.priceTier = priceTier;
        this.productExternalId = productExternalId;
        this.productId = productId;
        this.productName = productName;
        this.tiersMode = tiersMode;
        this.updatedAt = updatedAt;
        this.usageType = usageType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="billing_scheme")
    public String getBillingScheme() {
        return this.billingScheme;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="is_active")
    public boolean getIsActive() {
        return this.isActive;
    }

    @JsonProperty(value="meter_event_name")
    public Optional<String> getMeterEventName() {
        return this.meterEventName;
    }

    @JsonProperty(value="meter_event_payload_key")
    public Optional<String> getMeterEventPayloadKey() {
        return this.meterEventPayloadKey;
    }

    @JsonProperty(value="meter_id")
    public Optional<String> getMeterId() {
        return this.meterId;
    }

    @JsonProperty(value="package_size")
    public int getPackageSize() {
        return this.packageSize;
    }

    @JsonProperty(value="price")
    public int getPrice() {
        return this.price;
    }

    @JsonProperty(value="price_decimal")
    public Optional<String> getPriceDecimal() {
        return this.priceDecimal;
    }

    @JsonProperty(value="price_external_id")
    public String getPriceExternalId() {
        return this.priceExternalId;
    }

    @JsonProperty(value="price_id")
    public String getPriceId() {
        return this.priceId;
    }

    @JsonProperty(value="price_tier")
    public List<BillingProductPriceTierResponseData> getPriceTier() {
        return this.priceTier;
    }

    @JsonProperty(value="product_external_id")
    public String getProductExternalId() {
        return this.productExternalId;
    }

    @JsonProperty(value="product_id")
    public String getProductId() {
        return this.productId;
    }

    @JsonProperty(value="product_name")
    public String getProductName() {
        return this.productName;
    }

    @JsonProperty(value="tiers_mode")
    public Optional<String> getTiersMode() {
        return this.tiersMode;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="usage_type")
    public String getUsageType() {
        return this.usageType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingPriceView && this.equalTo((BillingPriceView)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingPriceView other) {
        return this.billingScheme.equals(other.billingScheme) && this.createdAt.equals(other.createdAt) && this.currency.equals(other.currency) && this.id.equals(other.id) && this.interval.equals(other.interval) && this.isActive == other.isActive && this.meterEventName.equals(other.meterEventName) && this.meterEventPayloadKey.equals(other.meterEventPayloadKey) && this.meterId.equals(other.meterId) && this.packageSize == other.packageSize && this.price == other.price && this.priceDecimal.equals(other.priceDecimal) && this.priceExternalId.equals(other.priceExternalId) && this.priceId.equals(other.priceId) && this.priceTier.equals(other.priceTier) && this.productExternalId.equals(other.productExternalId) && this.productId.equals(other.productId) && this.productName.equals(other.productName) && this.tiersMode.equals(other.tiersMode) && this.updatedAt.equals(other.updatedAt) && this.usageType.equals(other.usageType);
    }

    public int hashCode() {
        return Objects.hash(this.billingScheme, this.createdAt, this.currency, this.id, this.interval, this.isActive, this.meterEventName, this.meterEventPayloadKey, this.meterId, this.packageSize, this.price, this.priceDecimal, this.priceExternalId, this.priceId, this.priceTier, this.productExternalId, this.productId, this.productName, this.tiersMode, this.updatedAt, this.usageType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BillingSchemeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BillingSchemeStage,
    CreatedAtStage,
    CurrencyStage,
    IdStage,
    IntervalStage,
    IsActiveStage,
    PackageSizeStage,
    PriceStage,
    PriceExternalIdStage,
    PriceIdStage,
    ProductExternalIdStage,
    ProductIdStage,
    ProductNameStage,
    UpdatedAtStage,
    UsageTypeStage,
    _FinalStage {
        private String billingScheme;
        private OffsetDateTime createdAt;
        private String currency;
        private String id;
        private String interval;
        private boolean isActive;
        private int packageSize;
        private int price;
        private String priceExternalId;
        private String priceId;
        private String productExternalId;
        private String productId;
        private String productName;
        private OffsetDateTime updatedAt;
        private String usageType;
        private Optional<String> tiersMode = Optional.empty();
        private List<BillingProductPriceTierResponseData> priceTier = new ArrayList<BillingProductPriceTierResponseData>();
        private Optional<String> priceDecimal = Optional.empty();
        private Optional<String> meterId = Optional.empty();
        private Optional<String> meterEventPayloadKey = Optional.empty();
        private Optional<String> meterEventName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingPriceView other) {
            this.billingScheme(other.getBillingScheme());
            this.createdAt(other.getCreatedAt());
            this.currency(other.getCurrency());
            this.id(other.getId());
            this.interval(other.getInterval());
            this.isActive(other.getIsActive());
            this.meterEventName(other.getMeterEventName());
            this.meterEventPayloadKey(other.getMeterEventPayloadKey());
            this.meterId(other.getMeterId());
            this.packageSize(other.getPackageSize());
            this.price(other.getPrice());
            this.priceDecimal(other.getPriceDecimal());
            this.priceExternalId(other.getPriceExternalId());
            this.priceId(other.getPriceId());
            this.priceTier(other.getPriceTier());
            this.productExternalId(other.getProductExternalId());
            this.productId(other.getProductId());
            this.productName(other.getProductName());
            this.tiersMode(other.getTiersMode());
            this.updatedAt(other.getUpdatedAt());
            this.usageType(other.getUsageType());
            return this;
        }

        @Override
        @JsonSetter(value="billing_scheme")
        public CreatedAtStage billingScheme(@NotNull String billingScheme) {
            this.billingScheme = Objects.requireNonNull(billingScheme, "billingScheme must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public CurrencyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public IdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public IntervalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="interval")
        public IsActiveStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_active")
        public PackageSizeStage isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @Override
        @JsonSetter(value="package_size")
        public PriceStage packageSize(int packageSize) {
            this.packageSize = packageSize;
            return this;
        }

        @Override
        @JsonSetter(value="price")
        public PriceExternalIdStage price(int price) {
            this.price = price;
            return this;
        }

        @Override
        @JsonSetter(value="price_external_id")
        public PriceIdStage priceExternalId(@NotNull String priceExternalId) {
            this.priceExternalId = Objects.requireNonNull(priceExternalId, "priceExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price_id")
        public ProductExternalIdStage priceId(@NotNull String priceId) {
            this.priceId = Objects.requireNonNull(priceId, "priceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="product_external_id")
        public ProductIdStage productExternalId(@NotNull String productExternalId) {
            this.productExternalId = Objects.requireNonNull(productExternalId, "productExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="product_id")
        public ProductNameStage productId(@NotNull String productId) {
            this.productId = Objects.requireNonNull(productId, "productId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="product_name")
        public UpdatedAtStage productName(@NotNull String productName) {
            this.productName = Objects.requireNonNull(productName, "productName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public UsageTypeStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="usage_type")
        public _FinalStage usageType(@NotNull String usageType) {
            this.usageType = Objects.requireNonNull(usageType, "usageType must not be null");
            return this;
        }

        @Override
        public _FinalStage tiersMode(String tiersMode) {
            this.tiersMode = Optional.ofNullable(tiersMode);
            return this;
        }

        @Override
        @JsonSetter(value="tiers_mode", nulls=Nulls.SKIP)
        public _FinalStage tiersMode(Optional<String> tiersMode) {
            this.tiersMode = tiersMode;
            return this;
        }

        @Override
        public _FinalStage addAllPriceTier(List<BillingProductPriceTierResponseData> priceTier) {
            if (priceTier != null) {
                this.priceTier.addAll(priceTier);
            }
            return this;
        }

        @Override
        public _FinalStage addPriceTier(BillingProductPriceTierResponseData priceTier) {
            this.priceTier.add(priceTier);
            return this;
        }

        @Override
        @JsonSetter(value="price_tier", nulls=Nulls.SKIP)
        public _FinalStage priceTier(List<BillingProductPriceTierResponseData> priceTier) {
            this.priceTier.clear();
            if (priceTier != null) {
                this.priceTier.addAll(priceTier);
            }
            return this;
        }

        @Override
        public _FinalStage priceDecimal(String priceDecimal) {
            this.priceDecimal = Optional.ofNullable(priceDecimal);
            return this;
        }

        @Override
        @JsonSetter(value="price_decimal", nulls=Nulls.SKIP)
        public _FinalStage priceDecimal(Optional<String> priceDecimal) {
            this.priceDecimal = priceDecimal;
            return this;
        }

        @Override
        public _FinalStage meterId(String meterId) {
            this.meterId = Optional.ofNullable(meterId);
            return this;
        }

        @Override
        @JsonSetter(value="meter_id", nulls=Nulls.SKIP)
        public _FinalStage meterId(Optional<String> meterId) {
            this.meterId = meterId;
            return this;
        }

        @Override
        public _FinalStage meterEventPayloadKey(String meterEventPayloadKey) {
            this.meterEventPayloadKey = Optional.ofNullable(meterEventPayloadKey);
            return this;
        }

        @Override
        @JsonSetter(value="meter_event_payload_key", nulls=Nulls.SKIP)
        public _FinalStage meterEventPayloadKey(Optional<String> meterEventPayloadKey) {
            this.meterEventPayloadKey = meterEventPayloadKey;
            return this;
        }

        @Override
        public _FinalStage meterEventName(String meterEventName) {
            this.meterEventName = Optional.ofNullable(meterEventName);
            return this;
        }

        @Override
        @JsonSetter(value="meter_event_name", nulls=Nulls.SKIP)
        public _FinalStage meterEventName(Optional<String> meterEventName) {
            this.meterEventName = meterEventName;
            return this;
        }

        @Override
        public BillingPriceView build() {
            return new BillingPriceView(this.billingScheme, this.createdAt, this.currency, this.id, this.interval, this.isActive, this.meterEventName, this.meterEventPayloadKey, this.meterId, this.packageSize, this.price, this.priceDecimal, this.priceExternalId, this.priceId, this.priceTier, this.productExternalId, this.productId, this.productName, this.tiersMode, this.updatedAt, this.usageType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingPriceView build();

        public _FinalStage meterEventName(Optional<String> var1);

        public _FinalStage meterEventName(String var1);

        public _FinalStage meterEventPayloadKey(Optional<String> var1);

        public _FinalStage meterEventPayloadKey(String var1);

        public _FinalStage meterId(Optional<String> var1);

        public _FinalStage meterId(String var1);

        public _FinalStage priceDecimal(Optional<String> var1);

        public _FinalStage priceDecimal(String var1);

        public _FinalStage priceTier(List<BillingProductPriceTierResponseData> var1);

        public _FinalStage addPriceTier(BillingProductPriceTierResponseData var1);

        public _FinalStage addAllPriceTier(List<BillingProductPriceTierResponseData> var1);

        public _FinalStage tiersMode(Optional<String> var1);

        public _FinalStage tiersMode(String var1);
    }

    public static interface UsageTypeStage {
        public _FinalStage usageType(@NotNull String var1);
    }

    public static interface UpdatedAtStage {
        public UsageTypeStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface ProductNameStage {
        public UpdatedAtStage productName(@NotNull String var1);
    }

    public static interface ProductIdStage {
        public ProductNameStage productId(@NotNull String var1);
    }

    public static interface ProductExternalIdStage {
        public ProductIdStage productExternalId(@NotNull String var1);
    }

    public static interface PriceIdStage {
        public ProductExternalIdStage priceId(@NotNull String var1);
    }

    public static interface PriceExternalIdStage {
        public PriceIdStage priceExternalId(@NotNull String var1);
    }

    public static interface PriceStage {
        public PriceExternalIdStage price(int var1);
    }

    public static interface PackageSizeStage {
        public PriceStage packageSize(int var1);
    }

    public static interface IsActiveStage {
        public PackageSizeStage isActive(boolean var1);
    }

    public static interface IntervalStage {
        public IsActiveStage interval(@NotNull String var1);
    }

    public static interface IdStage {
        public IntervalStage id(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public IdStage currency(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public CurrencyStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface BillingSchemeStage {
        public CreatedAtStage billingScheme(@NotNull String var1);

        public Builder from(BillingPriceView var1);
    }
}

