/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingPriceResponseData;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingProductDetailResponseData {
    private final String accountId;
    private final OffsetDateTime createdAt;
    private final Optional<String> currency;
    private final String environmentId;
    private final String externalId;
    private final boolean isActive;
    private final String name;
    private final double price;
    private final Optional<String> priceDecimal;
    private final List<BillingPriceResponseData> prices;
    private final String productId;
    private final double quantity;
    private final int subscriptionCount;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private BillingProductDetailResponseData(String accountId, OffsetDateTime createdAt, Optional<String> currency, String environmentId, String externalId, boolean isActive, String name, double price, Optional<String> priceDecimal, List<BillingPriceResponseData> prices, String productId, double quantity, int subscriptionCount, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.createdAt = createdAt;
        this.currency = currency;
        this.environmentId = environmentId;
        this.externalId = externalId;
        this.isActive = isActive;
        this.name = name;
        this.price = price;
        this.priceDecimal = priceDecimal;
        this.prices = prices;
        this.productId = productId;
        this.quantity = quantity;
        this.subscriptionCount = subscriptionCount;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_id")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="currency")
    public Optional<String> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="is_active")
    public boolean getIsActive() {
        return this.isActive;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="price")
    public double getPrice() {
        return this.price;
    }

    @JsonProperty(value="price_decimal")
    public Optional<String> getPriceDecimal() {
        return this.priceDecimal;
    }

    @JsonProperty(value="prices")
    public List<BillingPriceResponseData> getPrices() {
        return this.prices;
    }

    @JsonProperty(value="product_id")
    public String getProductId() {
        return this.productId;
    }

    @JsonProperty(value="quantity")
    public double getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="subscription_count")
    public int getSubscriptionCount() {
        return this.subscriptionCount;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingProductDetailResponseData && this.equalTo((BillingProductDetailResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingProductDetailResponseData other) {
        return this.accountId.equals(other.accountId) && this.createdAt.equals(other.createdAt) && this.currency.equals(other.currency) && this.environmentId.equals(other.environmentId) && this.externalId.equals(other.externalId) && this.isActive == other.isActive && this.name.equals(other.name) && this.price == other.price && this.priceDecimal.equals(other.priceDecimal) && this.prices.equals(other.prices) && this.productId.equals(other.productId) && this.quantity == other.quantity && this.subscriptionCount == other.subscriptionCount && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.createdAt, this.currency, this.environmentId, this.externalId, this.isActive, this.name, this.price, this.priceDecimal, this.prices, this.productId, this.quantity, this.subscriptionCount, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccountIdStage,
    CreatedAtStage,
    EnvironmentIdStage,
    ExternalIdStage,
    IsActiveStage,
    NameStage,
    PriceStage,
    ProductIdStage,
    QuantityStage,
    SubscriptionCountStage,
    UpdatedAtStage,
    _FinalStage {
        private String accountId;
        private OffsetDateTime createdAt;
        private String environmentId;
        private String externalId;
        private boolean isActive;
        private String name;
        private double price;
        private String productId;
        private double quantity;
        private int subscriptionCount;
        private OffsetDateTime updatedAt;
        private List<BillingPriceResponseData> prices = new ArrayList<BillingPriceResponseData>();
        private Optional<String> priceDecimal = Optional.empty();
        private Optional<String> currency = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingProductDetailResponseData other) {
            this.accountId(other.getAccountId());
            this.createdAt(other.getCreatedAt());
            this.currency(other.getCurrency());
            this.environmentId(other.getEnvironmentId());
            this.externalId(other.getExternalId());
            this.isActive(other.getIsActive());
            this.name(other.getName());
            this.price(other.getPrice());
            this.priceDecimal(other.getPriceDecimal());
            this.prices(other.getPrices());
            this.productId(other.getProductId());
            this.quantity(other.getQuantity());
            this.subscriptionCount(other.getSubscriptionCount());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="account_id")
        public CreatedAtStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public ExternalIdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_id")
        public IsActiveStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_active")
        public NameStage isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PriceStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price")
        public ProductIdStage price(double price) {
            this.price = price;
            return this;
        }

        @Override
        @JsonSetter(value="product_id")
        public QuantityStage productId(@NotNull String productId) {
            this.productId = Objects.requireNonNull(productId, "productId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public SubscriptionCountStage quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        @JsonSetter(value="subscription_count")
        public UpdatedAtStage subscriptionCount(int subscriptionCount) {
            this.subscriptionCount = subscriptionCount;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllPrices(List<BillingPriceResponseData> prices) {
            if (prices != null) {
                this.prices.addAll(prices);
            }
            return this;
        }

        @Override
        public _FinalStage addPrices(BillingPriceResponseData prices) {
            this.prices.add(prices);
            return this;
        }

        @Override
        @JsonSetter(value="prices", nulls=Nulls.SKIP)
        public _FinalStage prices(List<BillingPriceResponseData> prices) {
            this.prices.clear();
            if (prices != null) {
                this.prices.addAll(prices);
            }
            return this;
        }

        @Override
        public _FinalStage priceDecimal(String priceDecimal) {
            this.priceDecimal = Optional.ofNullable(priceDecimal);
            return this;
        }

        @Override
        @JsonSetter(value="price_decimal", nulls=Nulls.SKIP)
        public _FinalStage priceDecimal(Optional<String> priceDecimal) {
            this.priceDecimal = priceDecimal;
            return this;
        }

        @Override
        public _FinalStage currency(String currency) {
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        @Override
        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public _FinalStage currency(Optional<String> currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public BillingProductDetailResponseData build() {
            return new BillingProductDetailResponseData(this.accountId, this.createdAt, this.currency, this.environmentId, this.externalId, this.isActive, this.name, this.price, this.priceDecimal, this.prices, this.productId, this.quantity, this.subscriptionCount, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingProductDetailResponseData build();

        public _FinalStage currency(Optional<String> var1);

        public _FinalStage currency(String var1);

        public _FinalStage priceDecimal(Optional<String> var1);

        public _FinalStage priceDecimal(String var1);

        public _FinalStage prices(List<BillingPriceResponseData> var1);

        public _FinalStage addPrices(BillingPriceResponseData var1);

        public _FinalStage addAllPrices(List<BillingPriceResponseData> var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface SubscriptionCountStage {
        public UpdatedAtStage subscriptionCount(int var1);
    }

    public static interface QuantityStage {
        public SubscriptionCountStage quantity(double var1);
    }

    public static interface ProductIdStage {
        public QuantityStage productId(@NotNull String var1);
    }

    public static interface PriceStage {
        public ProductIdStage price(double var1);
    }

    public static interface NameStage {
        public PriceStage name(@NotNull String var1);
    }

    public static interface IsActiveStage {
        public NameStage isActive(boolean var1);
    }

    public static interface ExternalIdStage {
        public IsActiveStage externalId(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public ExternalIdStage environmentId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface AccountIdStage {
        public CreatedAtStage accountId(@NotNull String var1);

        public Builder from(BillingProductDetailResponseData var1);
    }
}

