/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingSubscriptionDiscountView {
    private final Optional<Integer> amountOff;
    private final String couponId;
    private final String couponName;
    private final Optional<String> currency;
    private final Optional<String> customerFacingCode;
    private final String discountExternalId;
    private final String duration;
    private final Optional<Integer> durationInMonths;
    private final Optional<OffsetDateTime> endedAt;
    private final boolean isActive;
    private final Optional<Double> percentOff;
    private final Optional<String> promoCodeExternalId;
    private final OffsetDateTime startedAt;
    private final String subscriptionExternalId;
    private final Map<String, Object> additionalProperties;

    private BillingSubscriptionDiscountView(Optional<Integer> amountOff, String couponId, String couponName, Optional<String> currency, Optional<String> customerFacingCode, String discountExternalId, String duration, Optional<Integer> durationInMonths, Optional<OffsetDateTime> endedAt, boolean isActive, Optional<Double> percentOff, Optional<String> promoCodeExternalId, OffsetDateTime startedAt, String subscriptionExternalId, Map<String, Object> additionalProperties) {
        this.amountOff = amountOff;
        this.couponId = couponId;
        this.couponName = couponName;
        this.currency = currency;
        this.customerFacingCode = customerFacingCode;
        this.discountExternalId = discountExternalId;
        this.duration = duration;
        this.durationInMonths = durationInMonths;
        this.endedAt = endedAt;
        this.isActive = isActive;
        this.percentOff = percentOff;
        this.promoCodeExternalId = promoCodeExternalId;
        this.startedAt = startedAt;
        this.subscriptionExternalId = subscriptionExternalId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="amount_off")
    public Optional<Integer> getAmountOff() {
        return this.amountOff;
    }

    @JsonProperty(value="coupon_id")
    public String getCouponId() {
        return this.couponId;
    }

    @JsonProperty(value="coupon_name")
    public String getCouponName() {
        return this.couponName;
    }

    @JsonProperty(value="currency")
    public Optional<String> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="customer_facing_code")
    public Optional<String> getCustomerFacingCode() {
        return this.customerFacingCode;
    }

    @JsonProperty(value="discount_external_id")
    public String getDiscountExternalId() {
        return this.discountExternalId;
    }

    @JsonProperty(value="duration")
    public String getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration_in_months")
    public Optional<Integer> getDurationInMonths() {
        return this.durationInMonths;
    }

    @JsonProperty(value="ended_at")
    public Optional<OffsetDateTime> getEndedAt() {
        return this.endedAt;
    }

    @JsonProperty(value="is_active")
    public boolean getIsActive() {
        return this.isActive;
    }

    @JsonProperty(value="percent_off")
    public Optional<Double> getPercentOff() {
        return this.percentOff;
    }

    @JsonProperty(value="promo_code_external_id")
    public Optional<String> getPromoCodeExternalId() {
        return this.promoCodeExternalId;
    }

    @JsonProperty(value="started_at")
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    @JsonProperty(value="subscription_external_id")
    public String getSubscriptionExternalId() {
        return this.subscriptionExternalId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingSubscriptionDiscountView && this.equalTo((BillingSubscriptionDiscountView)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingSubscriptionDiscountView other) {
        return this.amountOff.equals(other.amountOff) && this.couponId.equals(other.couponId) && this.couponName.equals(other.couponName) && this.currency.equals(other.currency) && this.customerFacingCode.equals(other.customerFacingCode) && this.discountExternalId.equals(other.discountExternalId) && this.duration.equals(other.duration) && this.durationInMonths.equals(other.durationInMonths) && this.endedAt.equals(other.endedAt) && this.isActive == other.isActive && this.percentOff.equals(other.percentOff) && this.promoCodeExternalId.equals(other.promoCodeExternalId) && this.startedAt.equals(other.startedAt) && this.subscriptionExternalId.equals(other.subscriptionExternalId);
    }

    public int hashCode() {
        return Objects.hash(this.amountOff, this.couponId, this.couponName, this.currency, this.customerFacingCode, this.discountExternalId, this.duration, this.durationInMonths, this.endedAt, this.isActive, this.percentOff, this.promoCodeExternalId, this.startedAt, this.subscriptionExternalId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CouponIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CouponIdStage,
    CouponNameStage,
    DiscountExternalIdStage,
    DurationStage,
    IsActiveStage,
    StartedAtStage,
    SubscriptionExternalIdStage,
    _FinalStage {
        private String couponId;
        private String couponName;
        private String discountExternalId;
        private String duration;
        private boolean isActive;
        private OffsetDateTime startedAt;
        private String subscriptionExternalId;
        private Optional<String> promoCodeExternalId = Optional.empty();
        private Optional<Double> percentOff = Optional.empty();
        private Optional<OffsetDateTime> endedAt = Optional.empty();
        private Optional<Integer> durationInMonths = Optional.empty();
        private Optional<String> customerFacingCode = Optional.empty();
        private Optional<String> currency = Optional.empty();
        private Optional<Integer> amountOff = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingSubscriptionDiscountView other) {
            this.amountOff(other.getAmountOff());
            this.couponId(other.getCouponId());
            this.couponName(other.getCouponName());
            this.currency(other.getCurrency());
            this.customerFacingCode(other.getCustomerFacingCode());
            this.discountExternalId(other.getDiscountExternalId());
            this.duration(other.getDuration());
            this.durationInMonths(other.getDurationInMonths());
            this.endedAt(other.getEndedAt());
            this.isActive(other.getIsActive());
            this.percentOff(other.getPercentOff());
            this.promoCodeExternalId(other.getPromoCodeExternalId());
            this.startedAt(other.getStartedAt());
            this.subscriptionExternalId(other.getSubscriptionExternalId());
            return this;
        }

        @Override
        @JsonSetter(value="coupon_id")
        public CouponNameStage couponId(@NotNull String couponId) {
            this.couponId = Objects.requireNonNull(couponId, "couponId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="coupon_name")
        public DiscountExternalIdStage couponName(@NotNull String couponName) {
            this.couponName = Objects.requireNonNull(couponName, "couponName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="discount_external_id")
        public DurationStage discountExternalId(@NotNull String discountExternalId) {
            this.discountExternalId = Objects.requireNonNull(discountExternalId, "discountExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="duration")
        public IsActiveStage duration(@NotNull String duration) {
            this.duration = Objects.requireNonNull(duration, "duration must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_active")
        public StartedAtStage isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @Override
        @JsonSetter(value="started_at")
        public SubscriptionExternalIdStage startedAt(@NotNull OffsetDateTime startedAt) {
            this.startedAt = Objects.requireNonNull(startedAt, "startedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="subscription_external_id")
        public _FinalStage subscriptionExternalId(@NotNull String subscriptionExternalId) {
            this.subscriptionExternalId = Objects.requireNonNull(subscriptionExternalId, "subscriptionExternalId must not be null");
            return this;
        }

        @Override
        public _FinalStage promoCodeExternalId(String promoCodeExternalId) {
            this.promoCodeExternalId = Optional.ofNullable(promoCodeExternalId);
            return this;
        }

        @Override
        @JsonSetter(value="promo_code_external_id", nulls=Nulls.SKIP)
        public _FinalStage promoCodeExternalId(Optional<String> promoCodeExternalId) {
            this.promoCodeExternalId = promoCodeExternalId;
            return this;
        }

        @Override
        public _FinalStage percentOff(Double percentOff) {
            this.percentOff = Optional.ofNullable(percentOff);
            return this;
        }

        @Override
        @JsonSetter(value="percent_off", nulls=Nulls.SKIP)
        public _FinalStage percentOff(Optional<Double> percentOff) {
            this.percentOff = percentOff;
            return this;
        }

        @Override
        public _FinalStage endedAt(OffsetDateTime endedAt) {
            this.endedAt = Optional.ofNullable(endedAt);
            return this;
        }

        @Override
        @JsonSetter(value="ended_at", nulls=Nulls.SKIP)
        public _FinalStage endedAt(Optional<OffsetDateTime> endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        @Override
        public _FinalStage durationInMonths(Integer durationInMonths) {
            this.durationInMonths = Optional.ofNullable(durationInMonths);
            return this;
        }

        @Override
        @JsonSetter(value="duration_in_months", nulls=Nulls.SKIP)
        public _FinalStage durationInMonths(Optional<Integer> durationInMonths) {
            this.durationInMonths = durationInMonths;
            return this;
        }

        @Override
        public _FinalStage customerFacingCode(String customerFacingCode) {
            this.customerFacingCode = Optional.ofNullable(customerFacingCode);
            return this;
        }

        @Override
        @JsonSetter(value="customer_facing_code", nulls=Nulls.SKIP)
        public _FinalStage customerFacingCode(Optional<String> customerFacingCode) {
            this.customerFacingCode = customerFacingCode;
            return this;
        }

        @Override
        public _FinalStage currency(String currency) {
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        @Override
        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public _FinalStage currency(Optional<String> currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public _FinalStage amountOff(Integer amountOff) {
            this.amountOff = Optional.ofNullable(amountOff);
            return this;
        }

        @Override
        @JsonSetter(value="amount_off", nulls=Nulls.SKIP)
        public _FinalStage amountOff(Optional<Integer> amountOff) {
            this.amountOff = amountOff;
            return this;
        }

        @Override
        public BillingSubscriptionDiscountView build() {
            return new BillingSubscriptionDiscountView(this.amountOff, this.couponId, this.couponName, this.currency, this.customerFacingCode, this.discountExternalId, this.duration, this.durationInMonths, this.endedAt, this.isActive, this.percentOff, this.promoCodeExternalId, this.startedAt, this.subscriptionExternalId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingSubscriptionDiscountView build();

        public _FinalStage amountOff(Optional<Integer> var1);

        public _FinalStage amountOff(Integer var1);

        public _FinalStage currency(Optional<String> var1);

        public _FinalStage currency(String var1);

        public _FinalStage customerFacingCode(Optional<String> var1);

        public _FinalStage customerFacingCode(String var1);

        public _FinalStage durationInMonths(Optional<Integer> var1);

        public _FinalStage durationInMonths(Integer var1);

        public _FinalStage endedAt(Optional<OffsetDateTime> var1);

        public _FinalStage endedAt(OffsetDateTime var1);

        public _FinalStage percentOff(Optional<Double> var1);

        public _FinalStage percentOff(Double var1);

        public _FinalStage promoCodeExternalId(Optional<String> var1);

        public _FinalStage promoCodeExternalId(String var1);
    }

    public static interface SubscriptionExternalIdStage {
        public _FinalStage subscriptionExternalId(@NotNull String var1);
    }

    public static interface StartedAtStage {
        public SubscriptionExternalIdStage startedAt(@NotNull OffsetDateTime var1);
    }

    public static interface IsActiveStage {
        public StartedAtStage isActive(boolean var1);
    }

    public static interface DurationStage {
        public IsActiveStage duration(@NotNull String var1);
    }

    public static interface DiscountExternalIdStage {
        public DurationStage discountExternalId(@NotNull String var1);
    }

    public static interface CouponNameStage {
        public DiscountExternalIdStage couponName(@NotNull String var1);
    }

    public static interface CouponIdStage {
        public CouponNameStage couponId(@NotNull String var1);

        public Builder from(BillingSubscriptionDiscountView var1);
    }
}

