/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CheckFlagResponseData {
    private final Optional<String> companyId;
    private final Optional<String> error;
    private final Optional<Integer> featureAllocation;
    private final Optional<Integer> featureUsage;
    private final Optional<String> featureUsageEvent;
    private final Optional<String> featureUsagePeriod;
    private final Optional<OffsetDateTime> featureUsageResetAt;
    private final String flag;
    private final Optional<String> flagId;
    private final String reason;
    private final Optional<String> ruleId;
    private final Optional<String> ruleType;
    private final Optional<String> userId;
    private final boolean value;
    private final Map<String, Object> additionalProperties;

    private CheckFlagResponseData(Optional<String> companyId, Optional<String> error, Optional<Integer> featureAllocation, Optional<Integer> featureUsage, Optional<String> featureUsageEvent, Optional<String> featureUsagePeriod, Optional<OffsetDateTime> featureUsageResetAt, String flag, Optional<String> flagId, String reason, Optional<String> ruleId, Optional<String> ruleType, Optional<String> userId, boolean value, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.error = error;
        this.featureAllocation = featureAllocation;
        this.featureUsage = featureUsage;
        this.featureUsageEvent = featureUsageEvent;
        this.featureUsagePeriod = featureUsagePeriod;
        this.featureUsageResetAt = featureUsageResetAt;
        this.flag = flag;
        this.flagId = flagId;
        this.reason = reason;
        this.ruleId = ruleId;
        this.ruleType = ruleType;
        this.userId = userId;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="error")
    public Optional<String> getError() {
        return this.error;
    }

    @JsonProperty(value="feature_allocation")
    public Optional<Integer> getFeatureAllocation() {
        return this.featureAllocation;
    }

    @JsonProperty(value="feature_usage")
    public Optional<Integer> getFeatureUsage() {
        return this.featureUsage;
    }

    @JsonProperty(value="feature_usage_event")
    public Optional<String> getFeatureUsageEvent() {
        return this.featureUsageEvent;
    }

    @JsonProperty(value="feature_usage_period")
    public Optional<String> getFeatureUsagePeriod() {
        return this.featureUsagePeriod;
    }

    @JsonProperty(value="feature_usage_reset_at")
    public Optional<OffsetDateTime> getFeatureUsageResetAt() {
        return this.featureUsageResetAt;
    }

    @JsonProperty(value="flag")
    public String getFlag() {
        return this.flag;
    }

    @JsonProperty(value="flag_id")
    public Optional<String> getFlagId() {
        return this.flagId;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="rule_id")
    public Optional<String> getRuleId() {
        return this.ruleId;
    }

    @JsonProperty(value="rule_type")
    public Optional<String> getRuleType() {
        return this.ruleType;
    }

    @JsonProperty(value="user_id")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="value")
    public boolean getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CheckFlagResponseData && this.equalTo((CheckFlagResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CheckFlagResponseData other) {
        return this.companyId.equals(other.companyId) && this.error.equals(other.error) && this.featureAllocation.equals(other.featureAllocation) && this.featureUsage.equals(other.featureUsage) && this.featureUsageEvent.equals(other.featureUsageEvent) && this.featureUsagePeriod.equals(other.featureUsagePeriod) && this.featureUsageResetAt.equals(other.featureUsageResetAt) && this.flag.equals(other.flag) && this.flagId.equals(other.flagId) && this.reason.equals(other.reason) && this.ruleId.equals(other.ruleId) && this.ruleType.equals(other.ruleType) && this.userId.equals(other.userId) && this.value == other.value;
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.error, this.featureAllocation, this.featureUsage, this.featureUsageEvent, this.featureUsagePeriod, this.featureUsageResetAt, this.flag, this.flagId, this.reason, this.ruleId, this.ruleType, this.userId, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FlagStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements FlagStage,
    ReasonStage,
    ValueStage,
    _FinalStage {
        private String flag;
        private String reason;
        private boolean value;
        private Optional<String> userId = Optional.empty();
        private Optional<String> ruleType = Optional.empty();
        private Optional<String> ruleId = Optional.empty();
        private Optional<String> flagId = Optional.empty();
        private Optional<OffsetDateTime> featureUsageResetAt = Optional.empty();
        private Optional<String> featureUsagePeriod = Optional.empty();
        private Optional<String> featureUsageEvent = Optional.empty();
        private Optional<Integer> featureUsage = Optional.empty();
        private Optional<Integer> featureAllocation = Optional.empty();
        private Optional<String> error = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CheckFlagResponseData other) {
            this.companyId(other.getCompanyId());
            this.error(other.getError());
            this.featureAllocation(other.getFeatureAllocation());
            this.featureUsage(other.getFeatureUsage());
            this.featureUsageEvent(other.getFeatureUsageEvent());
            this.featureUsagePeriod(other.getFeatureUsagePeriod());
            this.featureUsageResetAt(other.getFeatureUsageResetAt());
            this.flag(other.getFlag());
            this.flagId(other.getFlagId());
            this.reason(other.getReason());
            this.ruleId(other.getRuleId());
            this.ruleType(other.getRuleType());
            this.userId(other.getUserId());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="flag")
        public ReasonStage flag(@NotNull String flag) {
            this.flag = Objects.requireNonNull(flag, "flag must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reason")
        public ValueStage reason(@NotNull String reason) {
            this.reason = Objects.requireNonNull(reason, "reason must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(boolean value) {
            this.value = value;
            return this;
        }

        @Override
        public _FinalStage userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @Override
        @JsonSetter(value="user_id", nulls=Nulls.SKIP)
        public _FinalStage userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public _FinalStage ruleType(String ruleType) {
            this.ruleType = Optional.ofNullable(ruleType);
            return this;
        }

        @Override
        @JsonSetter(value="rule_type", nulls=Nulls.SKIP)
        public _FinalStage ruleType(Optional<String> ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public _FinalStage ruleId(String ruleId) {
            this.ruleId = Optional.ofNullable(ruleId);
            return this;
        }

        @Override
        @JsonSetter(value="rule_id", nulls=Nulls.SKIP)
        public _FinalStage ruleId(Optional<String> ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        @Override
        public _FinalStage flagId(String flagId) {
            this.flagId = Optional.ofNullable(flagId);
            return this;
        }

        @Override
        @JsonSetter(value="flag_id", nulls=Nulls.SKIP)
        public _FinalStage flagId(Optional<String> flagId) {
            this.flagId = flagId;
            return this;
        }

        @Override
        public _FinalStage featureUsageResetAt(OffsetDateTime featureUsageResetAt) {
            this.featureUsageResetAt = Optional.ofNullable(featureUsageResetAt);
            return this;
        }

        @Override
        @JsonSetter(value="feature_usage_reset_at", nulls=Nulls.SKIP)
        public _FinalStage featureUsageResetAt(Optional<OffsetDateTime> featureUsageResetAt) {
            this.featureUsageResetAt = featureUsageResetAt;
            return this;
        }

        @Override
        public _FinalStage featureUsagePeriod(String featureUsagePeriod) {
            this.featureUsagePeriod = Optional.ofNullable(featureUsagePeriod);
            return this;
        }

        @Override
        @JsonSetter(value="feature_usage_period", nulls=Nulls.SKIP)
        public _FinalStage featureUsagePeriod(Optional<String> featureUsagePeriod) {
            this.featureUsagePeriod = featureUsagePeriod;
            return this;
        }

        @Override
        public _FinalStage featureUsageEvent(String featureUsageEvent) {
            this.featureUsageEvent = Optional.ofNullable(featureUsageEvent);
            return this;
        }

        @Override
        @JsonSetter(value="feature_usage_event", nulls=Nulls.SKIP)
        public _FinalStage featureUsageEvent(Optional<String> featureUsageEvent) {
            this.featureUsageEvent = featureUsageEvent;
            return this;
        }

        @Override
        public _FinalStage featureUsage(Integer featureUsage) {
            this.featureUsage = Optional.ofNullable(featureUsage);
            return this;
        }

        @Override
        @JsonSetter(value="feature_usage", nulls=Nulls.SKIP)
        public _FinalStage featureUsage(Optional<Integer> featureUsage) {
            this.featureUsage = featureUsage;
            return this;
        }

        @Override
        public _FinalStage featureAllocation(Integer featureAllocation) {
            this.featureAllocation = Optional.ofNullable(featureAllocation);
            return this;
        }

        @Override
        @JsonSetter(value="feature_allocation", nulls=Nulls.SKIP)
        public _FinalStage featureAllocation(Optional<Integer> featureAllocation) {
            this.featureAllocation = featureAllocation;
            return this;
        }

        @Override
        public _FinalStage error(String error) {
            this.error = Optional.ofNullable(error);
            return this;
        }

        @Override
        @JsonSetter(value="error", nulls=Nulls.SKIP)
        public _FinalStage error(Optional<String> error) {
            this.error = error;
            return this;
        }

        @Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @Override
        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @Override
        public CheckFlagResponseData build() {
            return new CheckFlagResponseData(this.companyId, this.error, this.featureAllocation, this.featureUsage, this.featureUsageEvent, this.featureUsagePeriod, this.featureUsageResetAt, this.flag, this.flagId, this.reason, this.ruleId, this.ruleType, this.userId, this.value, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CheckFlagResponseData build();

        public _FinalStage companyId(Optional<String> var1);

        public _FinalStage companyId(String var1);

        public _FinalStage error(Optional<String> var1);

        public _FinalStage error(String var1);

        public _FinalStage featureAllocation(Optional<Integer> var1);

        public _FinalStage featureAllocation(Integer var1);

        public _FinalStage featureUsage(Optional<Integer> var1);

        public _FinalStage featureUsage(Integer var1);

        public _FinalStage featureUsageEvent(Optional<String> var1);

        public _FinalStage featureUsageEvent(String var1);

        public _FinalStage featureUsagePeriod(Optional<String> var1);

        public _FinalStage featureUsagePeriod(String var1);

        public _FinalStage featureUsageResetAt(Optional<OffsetDateTime> var1);

        public _FinalStage featureUsageResetAt(OffsetDateTime var1);

        public _FinalStage flagId(Optional<String> var1);

        public _FinalStage flagId(String var1);

        public _FinalStage ruleId(Optional<String> var1);

        public _FinalStage ruleId(String var1);

        public _FinalStage ruleType(Optional<String> var1);

        public _FinalStage ruleType(String var1);

        public _FinalStage userId(Optional<String> var1);

        public _FinalStage userId(String var1);
    }

    public static interface ValueStage {
        public _FinalStage value(boolean var1);
    }

    public static interface ReasonStage {
        public ValueStage reason(@NotNull String var1);
    }

    public static interface FlagStage {
        public ReasonStage flag(@NotNull String var1);

        public Builder from(CheckFlagResponseData var1);
    }
}

