/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompanyLedgerResponseData {
    private final String id;
    private final Optional<String> logoUrl;
    private final String name;
    private final Map<String, Object> additionalProperties;

    private CompanyLedgerResponseData(String id, Optional<String> logoUrl, String name, Map<String, Object> additionalProperties) {
        this.id = id;
        this.logoUrl = logoUrl;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="logo_url")
    public Optional<String> getLogoUrl() {
        return this.logoUrl;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanyLedgerResponseData && this.equalTo((CompanyLedgerResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyLedgerResponseData other) {
        return this.id.equals(other.id) && this.logoUrl.equals(other.logoUrl) && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.logoUrl, this.name);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    _FinalStage {
        private String id;
        private String name;
        private Optional<String> logoUrl = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CompanyLedgerResponseData other) {
            this.id(other.getId());
            this.logoUrl(other.getLogoUrl());
            this.name(other.getName());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage logoUrl(String logoUrl) {
            this.logoUrl = Optional.ofNullable(logoUrl);
            return this;
        }

        @Override
        @JsonSetter(value="logo_url", nulls=Nulls.SKIP)
        public _FinalStage logoUrl(Optional<String> logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        @Override
        public CompanyLedgerResponseData build() {
            return new CompanyLedgerResponseData(this.id, this.logoUrl, this.name, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CompanyLedgerResponseData build();

        public _FinalStage logoUrl(Optional<String> var1);

        public _FinalStage logoUrl(String var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(CompanyLedgerResponseData var1);
    }
}

