/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CompanyDetailResponseData;
import com.schematic.api.types.CompanyOverrideNoteResponseData;
import com.schematic.api.types.EntityTraitDefinitionResponseData;
import com.schematic.api.types.FeatureResponseData;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompanyOverrideResponseData {
    private final Optional<CompanyDetailResponseData> company;
    private final String companyId;
    private final Optional<Double> consumptionRate;
    private final OffsetDateTime createdAt;
    private final String environmentId;
    private final Optional<OffsetDateTime> expirationDate;
    private final Optional<FeatureResponseData> feature;
    private final String featureId;
    private final String id;
    private final Optional<String> metricPeriod;
    private final Optional<String> metricPeriodMonthReset;
    private final List<CompanyOverrideNoteResponseData> notes;
    private final Optional<String> ruleId;
    private final Optional<String> ruleIdUsageExceeded;
    private final OffsetDateTime updatedAt;
    private final Optional<Boolean> valueBool;
    private final Optional<Integer> valueNumeric;
    private final Optional<EntityTraitDefinitionResponseData> valueTrait;
    private final Optional<String> valueTraitId;
    private final String valueType;
    private final Map<String, Object> additionalProperties;

    private CompanyOverrideResponseData(Optional<CompanyDetailResponseData> company, String companyId, Optional<Double> consumptionRate, OffsetDateTime createdAt, String environmentId, Optional<OffsetDateTime> expirationDate, Optional<FeatureResponseData> feature, String featureId, String id, Optional<String> metricPeriod, Optional<String> metricPeriodMonthReset, List<CompanyOverrideNoteResponseData> notes, Optional<String> ruleId, Optional<String> ruleIdUsageExceeded, OffsetDateTime updatedAt, Optional<Boolean> valueBool, Optional<Integer> valueNumeric, Optional<EntityTraitDefinitionResponseData> valueTrait, Optional<String> valueTraitId, String valueType, Map<String, Object> additionalProperties) {
        this.company = company;
        this.companyId = companyId;
        this.consumptionRate = consumptionRate;
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.expirationDate = expirationDate;
        this.feature = feature;
        this.featureId = featureId;
        this.id = id;
        this.metricPeriod = metricPeriod;
        this.metricPeriodMonthReset = metricPeriodMonthReset;
        this.notes = notes;
        this.ruleId = ruleId;
        this.ruleIdUsageExceeded = ruleIdUsageExceeded;
        this.updatedAt = updatedAt;
        this.valueBool = valueBool;
        this.valueNumeric = valueNumeric;
        this.valueTrait = valueTrait;
        this.valueTraitId = valueTraitId;
        this.valueType = valueType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company")
    public Optional<CompanyDetailResponseData> getCompany() {
        return this.company;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="consumption_rate")
    public Optional<Double> getConsumptionRate() {
        return this.consumptionRate;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="expiration_date")
    public Optional<OffsetDateTime> getExpirationDate() {
        return this.expirationDate;
    }

    @JsonProperty(value="feature")
    public Optional<FeatureResponseData> getFeature() {
        return this.feature;
    }

    @JsonProperty(value="feature_id")
    public String getFeatureId() {
        return this.featureId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="metric_period")
    public Optional<String> getMetricPeriod() {
        return this.metricPeriod;
    }

    @JsonProperty(value="metric_period_month_reset")
    public Optional<String> getMetricPeriodMonthReset() {
        return this.metricPeriodMonthReset;
    }

    @JsonProperty(value="notes")
    public List<CompanyOverrideNoteResponseData> getNotes() {
        return this.notes;
    }

    @JsonProperty(value="rule_id")
    public Optional<String> getRuleId() {
        return this.ruleId;
    }

    @JsonProperty(value="rule_id_usage_exceeded")
    public Optional<String> getRuleIdUsageExceeded() {
        return this.ruleIdUsageExceeded;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="value_bool")
    public Optional<Boolean> getValueBool() {
        return this.valueBool;
    }

    @JsonProperty(value="value_numeric")
    public Optional<Integer> getValueNumeric() {
        return this.valueNumeric;
    }

    @JsonProperty(value="value_trait")
    public Optional<EntityTraitDefinitionResponseData> getValueTrait() {
        return this.valueTrait;
    }

    @JsonProperty(value="value_trait_id")
    public Optional<String> getValueTraitId() {
        return this.valueTraitId;
    }

    @JsonProperty(value="value_type")
    public String getValueType() {
        return this.valueType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanyOverrideResponseData && this.equalTo((CompanyOverrideResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyOverrideResponseData other) {
        return this.company.equals(other.company) && this.companyId.equals(other.companyId) && this.consumptionRate.equals(other.consumptionRate) && this.createdAt.equals(other.createdAt) && this.environmentId.equals(other.environmentId) && this.expirationDate.equals(other.expirationDate) && this.feature.equals(other.feature) && this.featureId.equals(other.featureId) && this.id.equals(other.id) && this.metricPeriod.equals(other.metricPeriod) && this.metricPeriodMonthReset.equals(other.metricPeriodMonthReset) && this.notes.equals(other.notes) && this.ruleId.equals(other.ruleId) && this.ruleIdUsageExceeded.equals(other.ruleIdUsageExceeded) && this.updatedAt.equals(other.updatedAt) && this.valueBool.equals(other.valueBool) && this.valueNumeric.equals(other.valueNumeric) && this.valueTrait.equals(other.valueTrait) && this.valueTraitId.equals(other.valueTraitId) && this.valueType.equals(other.valueType);
    }

    public int hashCode() {
        return Objects.hash(this.company, this.companyId, this.consumptionRate, this.createdAt, this.environmentId, this.expirationDate, this.feature, this.featureId, this.id, this.metricPeriod, this.metricPeriodMonthReset, this.notes, this.ruleId, this.ruleIdUsageExceeded, this.updatedAt, this.valueBool, this.valueNumeric, this.valueTrait, this.valueTraitId, this.valueType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CompanyIdStage,
    CreatedAtStage,
    EnvironmentIdStage,
    FeatureIdStage,
    IdStage,
    UpdatedAtStage,
    ValueTypeStage,
    _FinalStage {
        private String companyId;
        private OffsetDateTime createdAt;
        private String environmentId;
        private String featureId;
        private String id;
        private OffsetDateTime updatedAt;
        private String valueType;
        private Optional<String> valueTraitId = Optional.empty();
        private Optional<EntityTraitDefinitionResponseData> valueTrait = Optional.empty();
        private Optional<Integer> valueNumeric = Optional.empty();
        private Optional<Boolean> valueBool = Optional.empty();
        private Optional<String> ruleIdUsageExceeded = Optional.empty();
        private Optional<String> ruleId = Optional.empty();
        private List<CompanyOverrideNoteResponseData> notes = new ArrayList<CompanyOverrideNoteResponseData>();
        private Optional<String> metricPeriodMonthReset = Optional.empty();
        private Optional<String> metricPeriod = Optional.empty();
        private Optional<FeatureResponseData> feature = Optional.empty();
        private Optional<OffsetDateTime> expirationDate = Optional.empty();
        private Optional<Double> consumptionRate = Optional.empty();
        private Optional<CompanyDetailResponseData> company = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CompanyOverrideResponseData other) {
            this.company(other.getCompany());
            this.companyId(other.getCompanyId());
            this.consumptionRate(other.getConsumptionRate());
            this.createdAt(other.getCreatedAt());
            this.environmentId(other.getEnvironmentId());
            this.expirationDate(other.getExpirationDate());
            this.feature(other.getFeature());
            this.featureId(other.getFeatureId());
            this.id(other.getId());
            this.metricPeriod(other.getMetricPeriod());
            this.metricPeriodMonthReset(other.getMetricPeriodMonthReset());
            this.notes(other.getNotes());
            this.ruleId(other.getRuleId());
            this.ruleIdUsageExceeded(other.getRuleIdUsageExceeded());
            this.updatedAt(other.getUpdatedAt());
            this.valueBool(other.getValueBool());
            this.valueNumeric(other.getValueNumeric());
            this.valueTrait(other.getValueTrait());
            this.valueTraitId(other.getValueTraitId());
            this.valueType(other.getValueType());
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public CreatedAtStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public FeatureIdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="feature_id")
        public IdStage featureId(@NotNull String featureId) {
            this.featureId = Objects.requireNonNull(featureId, "featureId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public UpdatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public ValueTypeStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value_type")
        public _FinalStage valueType(@NotNull String valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType must not be null");
            return this;
        }

        @Override
        public _FinalStage valueTraitId(String valueTraitId) {
            this.valueTraitId = Optional.ofNullable(valueTraitId);
            return this;
        }

        @Override
        @JsonSetter(value="value_trait_id", nulls=Nulls.SKIP)
        public _FinalStage valueTraitId(Optional<String> valueTraitId) {
            this.valueTraitId = valueTraitId;
            return this;
        }

        @Override
        public _FinalStage valueTrait(EntityTraitDefinitionResponseData valueTrait) {
            this.valueTrait = Optional.ofNullable(valueTrait);
            return this;
        }

        @Override
        @JsonSetter(value="value_trait", nulls=Nulls.SKIP)
        public _FinalStage valueTrait(Optional<EntityTraitDefinitionResponseData> valueTrait) {
            this.valueTrait = valueTrait;
            return this;
        }

        @Override
        public _FinalStage valueNumeric(Integer valueNumeric) {
            this.valueNumeric = Optional.ofNullable(valueNumeric);
            return this;
        }

        @Override
        @JsonSetter(value="value_numeric", nulls=Nulls.SKIP)
        public _FinalStage valueNumeric(Optional<Integer> valueNumeric) {
            this.valueNumeric = valueNumeric;
            return this;
        }

        @Override
        public _FinalStage valueBool(Boolean valueBool) {
            this.valueBool = Optional.ofNullable(valueBool);
            return this;
        }

        @Override
        @JsonSetter(value="value_bool", nulls=Nulls.SKIP)
        public _FinalStage valueBool(Optional<Boolean> valueBool) {
            this.valueBool = valueBool;
            return this;
        }

        @Override
        public _FinalStage ruleIdUsageExceeded(String ruleIdUsageExceeded) {
            this.ruleIdUsageExceeded = Optional.ofNullable(ruleIdUsageExceeded);
            return this;
        }

        @Override
        @JsonSetter(value="rule_id_usage_exceeded", nulls=Nulls.SKIP)
        public _FinalStage ruleIdUsageExceeded(Optional<String> ruleIdUsageExceeded) {
            this.ruleIdUsageExceeded = ruleIdUsageExceeded;
            return this;
        }

        @Override
        public _FinalStage ruleId(String ruleId) {
            this.ruleId = Optional.ofNullable(ruleId);
            return this;
        }

        @Override
        @JsonSetter(value="rule_id", nulls=Nulls.SKIP)
        public _FinalStage ruleId(Optional<String> ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        @Override
        public _FinalStage addAllNotes(List<CompanyOverrideNoteResponseData> notes) {
            if (notes != null) {
                this.notes.addAll(notes);
            }
            return this;
        }

        @Override
        public _FinalStage addNotes(CompanyOverrideNoteResponseData notes) {
            this.notes.add(notes);
            return this;
        }

        @Override
        @JsonSetter(value="notes", nulls=Nulls.SKIP)
        public _FinalStage notes(List<CompanyOverrideNoteResponseData> notes) {
            this.notes.clear();
            if (notes != null) {
                this.notes.addAll(notes);
            }
            return this;
        }

        @Override
        public _FinalStage metricPeriodMonthReset(String metricPeriodMonthReset) {
            this.metricPeriodMonthReset = Optional.ofNullable(metricPeriodMonthReset);
            return this;
        }

        @Override
        @JsonSetter(value="metric_period_month_reset", nulls=Nulls.SKIP)
        public _FinalStage metricPeriodMonthReset(Optional<String> metricPeriodMonthReset) {
            this.metricPeriodMonthReset = metricPeriodMonthReset;
            return this;
        }

        @Override
        public _FinalStage metricPeriod(String metricPeriod) {
            this.metricPeriod = Optional.ofNullable(metricPeriod);
            return this;
        }

        @Override
        @JsonSetter(value="metric_period", nulls=Nulls.SKIP)
        public _FinalStage metricPeriod(Optional<String> metricPeriod) {
            this.metricPeriod = metricPeriod;
            return this;
        }

        @Override
        public _FinalStage feature(FeatureResponseData feature) {
            this.feature = Optional.ofNullable(feature);
            return this;
        }

        @Override
        @JsonSetter(value="feature", nulls=Nulls.SKIP)
        public _FinalStage feature(Optional<FeatureResponseData> feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public _FinalStage expirationDate(OffsetDateTime expirationDate) {
            this.expirationDate = Optional.ofNullable(expirationDate);
            return this;
        }

        @Override
        @JsonSetter(value="expiration_date", nulls=Nulls.SKIP)
        public _FinalStage expirationDate(Optional<OffsetDateTime> expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        @Override
        public _FinalStage consumptionRate(Double consumptionRate) {
            this.consumptionRate = Optional.ofNullable(consumptionRate);
            return this;
        }

        @Override
        @JsonSetter(value="consumption_rate", nulls=Nulls.SKIP)
        public _FinalStage consumptionRate(Optional<Double> consumptionRate) {
            this.consumptionRate = consumptionRate;
            return this;
        }

        @Override
        public _FinalStage company(CompanyDetailResponseData company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @Override
        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public _FinalStage company(Optional<CompanyDetailResponseData> company) {
            this.company = company;
            return this;
        }

        @Override
        public CompanyOverrideResponseData build() {
            return new CompanyOverrideResponseData(this.company, this.companyId, this.consumptionRate, this.createdAt, this.environmentId, this.expirationDate, this.feature, this.featureId, this.id, this.metricPeriod, this.metricPeriodMonthReset, this.notes, this.ruleId, this.ruleIdUsageExceeded, this.updatedAt, this.valueBool, this.valueNumeric, this.valueTrait, this.valueTraitId, this.valueType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CompanyOverrideResponseData build();

        public _FinalStage company(Optional<CompanyDetailResponseData> var1);

        public _FinalStage company(CompanyDetailResponseData var1);

        public _FinalStage consumptionRate(Optional<Double> var1);

        public _FinalStage consumptionRate(Double var1);

        public _FinalStage expirationDate(Optional<OffsetDateTime> var1);

        public _FinalStage expirationDate(OffsetDateTime var1);

        public _FinalStage feature(Optional<FeatureResponseData> var1);

        public _FinalStage feature(FeatureResponseData var1);

        public _FinalStage metricPeriod(Optional<String> var1);

        public _FinalStage metricPeriod(String var1);

        public _FinalStage metricPeriodMonthReset(Optional<String> var1);

        public _FinalStage metricPeriodMonthReset(String var1);

        public _FinalStage notes(List<CompanyOverrideNoteResponseData> var1);

        public _FinalStage addNotes(CompanyOverrideNoteResponseData var1);

        public _FinalStage addAllNotes(List<CompanyOverrideNoteResponseData> var1);

        public _FinalStage ruleId(Optional<String> var1);

        public _FinalStage ruleId(String var1);

        public _FinalStage ruleIdUsageExceeded(Optional<String> var1);

        public _FinalStage ruleIdUsageExceeded(String var1);

        public _FinalStage valueBool(Optional<Boolean> var1);

        public _FinalStage valueBool(Boolean var1);

        public _FinalStage valueNumeric(Optional<Integer> var1);

        public _FinalStage valueNumeric(Integer var1);

        public _FinalStage valueTrait(Optional<EntityTraitDefinitionResponseData> var1);

        public _FinalStage valueTrait(EntityTraitDefinitionResponseData var1);

        public _FinalStage valueTraitId(Optional<String> var1);

        public _FinalStage valueTraitId(String var1);
    }

    public static interface ValueTypeStage {
        public _FinalStage valueType(@NotNull String var1);
    }

    public static interface UpdatedAtStage {
        public ValueTypeStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface IdStage {
        public UpdatedAtStage id(@NotNull String var1);
    }

    public static interface FeatureIdStage {
        public IdStage featureId(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public FeatureIdStage environmentId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface CompanyIdStage {
        public CreatedAtStage companyId(@NotNull String var1);

        public Builder from(CompanyOverrideResponseData var1);
    }
}

