/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingPriceResponseData;
import com.schematic.api.types.BillingProductDetailResponseData;
import com.schematic.api.types.CustomPlanConfig;
import com.schematic.api.types.FeatureDetailResponseData;
import com.schematic.api.types.FeatureUsageResponseData;
import com.schematic.api.types.PlanCreditGrantView;
import com.schematic.api.types.PlanEntitlementResponseData;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompanyPlanDetailResponseData {
    private final Optional<String> audienceType;
    private final Optional<BillingProductDetailResponseData> billingProduct;
    private final String chargeType;
    private final boolean companyCanTrial;
    private final int companyCount;
    private final List<String> compatiblePlanIds;
    private final String controlledBy;
    private final OffsetDateTime createdAt;
    private final boolean current;
    private final boolean custom;
    private final Optional<CustomPlanConfig> customPlanConfig;
    private final String description;
    private final List<PlanEntitlementResponseData> entitlements;
    private final List<FeatureDetailResponseData> features;
    private final String icon;
    private final String id;
    private final List<PlanCreditGrantView> includedCreditGrants;
    private final boolean isCustom;
    private final boolean isDefault;
    private final boolean isFree;
    private final boolean isTrialable;
    private final Optional<BillingPriceResponseData> monthlyPrice;
    private final String name;
    private final Optional<BillingPriceResponseData> oneTimePrice;
    private final String planType;
    private final Optional<Integer> trialDays;
    private final OffsetDateTime updatedAt;
    private final List<FeatureUsageResponseData> usageViolations;
    private final boolean valid;
    private final Optional<BillingPriceResponseData> yearlyPrice;
    private final Map<String, Object> additionalProperties;

    private CompanyPlanDetailResponseData(Optional<String> audienceType, Optional<BillingProductDetailResponseData> billingProduct, String chargeType, boolean companyCanTrial, int companyCount, List<String> compatiblePlanIds, String controlledBy, OffsetDateTime createdAt, boolean current, boolean custom, Optional<CustomPlanConfig> customPlanConfig, String description, List<PlanEntitlementResponseData> entitlements, List<FeatureDetailResponseData> features, String icon, String id, List<PlanCreditGrantView> includedCreditGrants, boolean isCustom, boolean isDefault, boolean isFree, boolean isTrialable, Optional<BillingPriceResponseData> monthlyPrice, String name, Optional<BillingPriceResponseData> oneTimePrice, String planType, Optional<Integer> trialDays, OffsetDateTime updatedAt, List<FeatureUsageResponseData> usageViolations, boolean valid, Optional<BillingPriceResponseData> yearlyPrice, Map<String, Object> additionalProperties) {
        this.audienceType = audienceType;
        this.billingProduct = billingProduct;
        this.chargeType = chargeType;
        this.companyCanTrial = companyCanTrial;
        this.companyCount = companyCount;
        this.compatiblePlanIds = compatiblePlanIds;
        this.controlledBy = controlledBy;
        this.createdAt = createdAt;
        this.current = current;
        this.custom = custom;
        this.customPlanConfig = customPlanConfig;
        this.description = description;
        this.entitlements = entitlements;
        this.features = features;
        this.icon = icon;
        this.id = id;
        this.includedCreditGrants = includedCreditGrants;
        this.isCustom = isCustom;
        this.isDefault = isDefault;
        this.isFree = isFree;
        this.isTrialable = isTrialable;
        this.monthlyPrice = monthlyPrice;
        this.name = name;
        this.oneTimePrice = oneTimePrice;
        this.planType = planType;
        this.trialDays = trialDays;
        this.updatedAt = updatedAt;
        this.usageViolations = usageViolations;
        this.valid = valid;
        this.yearlyPrice = yearlyPrice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="audience_type")
    public Optional<String> getAudienceType() {
        return this.audienceType;
    }

    @JsonProperty(value="billing_product")
    public Optional<BillingProductDetailResponseData> getBillingProduct() {
        return this.billingProduct;
    }

    @JsonProperty(value="charge_type")
    public String getChargeType() {
        return this.chargeType;
    }

    @JsonProperty(value="company_can_trial")
    public boolean getCompanyCanTrial() {
        return this.companyCanTrial;
    }

    @JsonProperty(value="company_count")
    public int getCompanyCount() {
        return this.companyCount;
    }

    @JsonProperty(value="compatible_plan_ids")
    public List<String> getCompatiblePlanIds() {
        return this.compatiblePlanIds;
    }

    @JsonProperty(value="controlled_by")
    public String getControlledBy() {
        return this.controlledBy;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="current")
    public boolean getCurrent() {
        return this.current;
    }

    @JsonProperty(value="custom")
    public boolean getCustom() {
        return this.custom;
    }

    @JsonProperty(value="custom_plan_config")
    public Optional<CustomPlanConfig> getCustomPlanConfig() {
        return this.customPlanConfig;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="entitlements")
    public List<PlanEntitlementResponseData> getEntitlements() {
        return this.entitlements;
    }

    @JsonProperty(value="features")
    public List<FeatureDetailResponseData> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="icon")
    public String getIcon() {
        return this.icon;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="included_credit_grants")
    public List<PlanCreditGrantView> getIncludedCreditGrants() {
        return this.includedCreditGrants;
    }

    @JsonProperty(value="is_custom")
    public boolean getIsCustom() {
        return this.isCustom;
    }

    @JsonProperty(value="is_default")
    public boolean getIsDefault() {
        return this.isDefault;
    }

    @JsonProperty(value="is_free")
    public boolean getIsFree() {
        return this.isFree;
    }

    @JsonProperty(value="is_trialable")
    public boolean getIsTrialable() {
        return this.isTrialable;
    }

    @JsonProperty(value="monthly_price")
    public Optional<BillingPriceResponseData> getMonthlyPrice() {
        return this.monthlyPrice;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="one_time_price")
    public Optional<BillingPriceResponseData> getOneTimePrice() {
        return this.oneTimePrice;
    }

    @JsonProperty(value="plan_type")
    public String getPlanType() {
        return this.planType;
    }

    @JsonProperty(value="trial_days")
    public Optional<Integer> getTrialDays() {
        return this.trialDays;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="usage_violations")
    public List<FeatureUsageResponseData> getUsageViolations() {
        return this.usageViolations;
    }

    @JsonProperty(value="valid")
    public boolean getValid() {
        return this.valid;
    }

    @JsonProperty(value="yearly_price")
    public Optional<BillingPriceResponseData> getYearlyPrice() {
        return this.yearlyPrice;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanyPlanDetailResponseData && this.equalTo((CompanyPlanDetailResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyPlanDetailResponseData other) {
        return this.audienceType.equals(other.audienceType) && this.billingProduct.equals(other.billingProduct) && this.chargeType.equals(other.chargeType) && this.companyCanTrial == other.companyCanTrial && this.companyCount == other.companyCount && this.compatiblePlanIds.equals(other.compatiblePlanIds) && this.controlledBy.equals(other.controlledBy) && this.createdAt.equals(other.createdAt) && this.current == other.current && this.custom == other.custom && this.customPlanConfig.equals(other.customPlanConfig) && this.description.equals(other.description) && this.entitlements.equals(other.entitlements) && this.features.equals(other.features) && this.icon.equals(other.icon) && this.id.equals(other.id) && this.includedCreditGrants.equals(other.includedCreditGrants) && this.isCustom == other.isCustom && this.isDefault == other.isDefault && this.isFree == other.isFree && this.isTrialable == other.isTrialable && this.monthlyPrice.equals(other.monthlyPrice) && this.name.equals(other.name) && this.oneTimePrice.equals(other.oneTimePrice) && this.planType.equals(other.planType) && this.trialDays.equals(other.trialDays) && this.updatedAt.equals(other.updatedAt) && this.usageViolations.equals(other.usageViolations) && this.valid == other.valid && this.yearlyPrice.equals(other.yearlyPrice);
    }

    public int hashCode() {
        return Objects.hash(this.audienceType, this.billingProduct, this.chargeType, this.companyCanTrial, this.companyCount, this.compatiblePlanIds, this.controlledBy, this.createdAt, this.current, this.custom, this.customPlanConfig, this.description, this.entitlements, this.features, this.icon, this.id, this.includedCreditGrants, this.isCustom, this.isDefault, this.isFree, this.isTrialable, this.monthlyPrice, this.name, this.oneTimePrice, this.planType, this.trialDays, this.updatedAt, this.usageViolations, this.valid, this.yearlyPrice);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ChargeTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ChargeTypeStage,
    CompanyCanTrialStage,
    CompanyCountStage,
    ControlledByStage,
    CreatedAtStage,
    CurrentStage,
    CustomStage,
    DescriptionStage,
    IconStage,
    IdStage,
    IsCustomStage,
    IsDefaultStage,
    IsFreeStage,
    IsTrialableStage,
    NameStage,
    PlanTypeStage,
    UpdatedAtStage,
    ValidStage,
    _FinalStage {
        private String chargeType;
        private boolean companyCanTrial;
        private int companyCount;
        private String controlledBy;
        private OffsetDateTime createdAt;
        private boolean current;
        private boolean custom;
        private String description;
        private String icon;
        private String id;
        private boolean isCustom;
        private boolean isDefault;
        private boolean isFree;
        private boolean isTrialable;
        private String name;
        private String planType;
        private OffsetDateTime updatedAt;
        private boolean valid;
        private Optional<BillingPriceResponseData> yearlyPrice = Optional.empty();
        private List<FeatureUsageResponseData> usageViolations = new ArrayList<FeatureUsageResponseData>();
        private Optional<Integer> trialDays = Optional.empty();
        private Optional<BillingPriceResponseData> oneTimePrice = Optional.empty();
        private Optional<BillingPriceResponseData> monthlyPrice = Optional.empty();
        private List<PlanCreditGrantView> includedCreditGrants = new ArrayList<PlanCreditGrantView>();
        private List<FeatureDetailResponseData> features = new ArrayList<FeatureDetailResponseData>();
        private List<PlanEntitlementResponseData> entitlements = new ArrayList<PlanEntitlementResponseData>();
        private Optional<CustomPlanConfig> customPlanConfig = Optional.empty();
        private List<String> compatiblePlanIds = new ArrayList<String>();
        private Optional<BillingProductDetailResponseData> billingProduct = Optional.empty();
        private Optional<String> audienceType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CompanyPlanDetailResponseData other) {
            this.audienceType(other.getAudienceType());
            this.billingProduct(other.getBillingProduct());
            this.chargeType(other.getChargeType());
            this.companyCanTrial(other.getCompanyCanTrial());
            this.companyCount(other.getCompanyCount());
            this.compatiblePlanIds(other.getCompatiblePlanIds());
            this.controlledBy(other.getControlledBy());
            this.createdAt(other.getCreatedAt());
            this.current(other.getCurrent());
            this.custom(other.getCustom());
            this.customPlanConfig(other.getCustomPlanConfig());
            this.description(other.getDescription());
            this.entitlements(other.getEntitlements());
            this.features(other.getFeatures());
            this.icon(other.getIcon());
            this.id(other.getId());
            this.includedCreditGrants(other.getIncludedCreditGrants());
            this.isCustom(other.getIsCustom());
            this.isDefault(other.getIsDefault());
            this.isFree(other.getIsFree());
            this.isTrialable(other.getIsTrialable());
            this.monthlyPrice(other.getMonthlyPrice());
            this.name(other.getName());
            this.oneTimePrice(other.getOneTimePrice());
            this.planType(other.getPlanType());
            this.trialDays(other.getTrialDays());
            this.updatedAt(other.getUpdatedAt());
            this.usageViolations(other.getUsageViolations());
            this.valid(other.getValid());
            this.yearlyPrice(other.getYearlyPrice());
            return this;
        }

        @Override
        @JsonSetter(value="charge_type")
        public CompanyCanTrialStage chargeType(@NotNull String chargeType) {
            this.chargeType = Objects.requireNonNull(chargeType, "chargeType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="company_can_trial")
        public CompanyCountStage companyCanTrial(boolean companyCanTrial) {
            this.companyCanTrial = companyCanTrial;
            return this;
        }

        @Override
        @JsonSetter(value="company_count")
        public ControlledByStage companyCount(int companyCount) {
            this.companyCount = companyCount;
            return this;
        }

        @Override
        @JsonSetter(value="controlled_by")
        public CreatedAtStage controlledBy(@NotNull String controlledBy) {
            this.controlledBy = Objects.requireNonNull(controlledBy, "controlledBy must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public CurrentStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="current")
        public CustomStage current(boolean current) {
            this.current = current;
            return this;
        }

        @Override
        @JsonSetter(value="custom")
        public DescriptionStage custom(boolean custom) {
            this.custom = custom;
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public IconStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="icon")
        public IdStage icon(@NotNull String icon) {
            this.icon = Objects.requireNonNull(icon, "icon must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public IsCustomStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_custom")
        public IsDefaultStage isCustom(boolean isCustom) {
            this.isCustom = isCustom;
            return this;
        }

        @Override
        @JsonSetter(value="is_default")
        public IsFreeStage isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        @Override
        @JsonSetter(value="is_free")
        public IsTrialableStage isFree(boolean isFree) {
            this.isFree = isFree;
            return this;
        }

        @Override
        @JsonSetter(value="is_trialable")
        public NameStage isTrialable(boolean isTrialable) {
            this.isTrialable = isTrialable;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PlanTypeStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="plan_type")
        public UpdatedAtStage planType(@NotNull String planType) {
            this.planType = Objects.requireNonNull(planType, "planType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public ValidStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="valid")
        public _FinalStage valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        @Override
        public _FinalStage yearlyPrice(BillingPriceResponseData yearlyPrice) {
            this.yearlyPrice = Optional.ofNullable(yearlyPrice);
            return this;
        }

        @Override
        @JsonSetter(value="yearly_price", nulls=Nulls.SKIP)
        public _FinalStage yearlyPrice(Optional<BillingPriceResponseData> yearlyPrice) {
            this.yearlyPrice = yearlyPrice;
            return this;
        }

        @Override
        public _FinalStage addAllUsageViolations(List<FeatureUsageResponseData> usageViolations) {
            if (usageViolations != null) {
                this.usageViolations.addAll(usageViolations);
            }
            return this;
        }

        @Override
        public _FinalStage addUsageViolations(FeatureUsageResponseData usageViolations) {
            this.usageViolations.add(usageViolations);
            return this;
        }

        @Override
        @JsonSetter(value="usage_violations", nulls=Nulls.SKIP)
        public _FinalStage usageViolations(List<FeatureUsageResponseData> usageViolations) {
            this.usageViolations.clear();
            if (usageViolations != null) {
                this.usageViolations.addAll(usageViolations);
            }
            return this;
        }

        @Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @Override
        @JsonSetter(value="trial_days", nulls=Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @Override
        public _FinalStage oneTimePrice(BillingPriceResponseData oneTimePrice) {
            this.oneTimePrice = Optional.ofNullable(oneTimePrice);
            return this;
        }

        @Override
        @JsonSetter(value="one_time_price", nulls=Nulls.SKIP)
        public _FinalStage oneTimePrice(Optional<BillingPriceResponseData> oneTimePrice) {
            this.oneTimePrice = oneTimePrice;
            return this;
        }

        @Override
        public _FinalStage monthlyPrice(BillingPriceResponseData monthlyPrice) {
            this.monthlyPrice = Optional.ofNullable(monthlyPrice);
            return this;
        }

        @Override
        @JsonSetter(value="monthly_price", nulls=Nulls.SKIP)
        public _FinalStage monthlyPrice(Optional<BillingPriceResponseData> monthlyPrice) {
            this.monthlyPrice = monthlyPrice;
            return this;
        }

        @Override
        public _FinalStage addAllIncludedCreditGrants(List<PlanCreditGrantView> includedCreditGrants) {
            if (includedCreditGrants != null) {
                this.includedCreditGrants.addAll(includedCreditGrants);
            }
            return this;
        }

        @Override
        public _FinalStage addIncludedCreditGrants(PlanCreditGrantView includedCreditGrants) {
            this.includedCreditGrants.add(includedCreditGrants);
            return this;
        }

        @Override
        @JsonSetter(value="included_credit_grants", nulls=Nulls.SKIP)
        public _FinalStage includedCreditGrants(List<PlanCreditGrantView> includedCreditGrants) {
            this.includedCreditGrants.clear();
            if (includedCreditGrants != null) {
                this.includedCreditGrants.addAll(includedCreditGrants);
            }
            return this;
        }

        @Override
        public _FinalStage addAllFeatures(List<FeatureDetailResponseData> features) {
            if (features != null) {
                this.features.addAll(features);
            }
            return this;
        }

        @Override
        public _FinalStage addFeatures(FeatureDetailResponseData features) {
            this.features.add(features);
            return this;
        }

        @Override
        @JsonSetter(value="features", nulls=Nulls.SKIP)
        public _FinalStage features(List<FeatureDetailResponseData> features) {
            this.features.clear();
            if (features != null) {
                this.features.addAll(features);
            }
            return this;
        }

        @Override
        public _FinalStage addAllEntitlements(List<PlanEntitlementResponseData> entitlements) {
            if (entitlements != null) {
                this.entitlements.addAll(entitlements);
            }
            return this;
        }

        @Override
        public _FinalStage addEntitlements(PlanEntitlementResponseData entitlements) {
            this.entitlements.add(entitlements);
            return this;
        }

        @Override
        @JsonSetter(value="entitlements", nulls=Nulls.SKIP)
        public _FinalStage entitlements(List<PlanEntitlementResponseData> entitlements) {
            this.entitlements.clear();
            if (entitlements != null) {
                this.entitlements.addAll(entitlements);
            }
            return this;
        }

        @Override
        public _FinalStage customPlanConfig(CustomPlanConfig customPlanConfig) {
            this.customPlanConfig = Optional.ofNullable(customPlanConfig);
            return this;
        }

        @Override
        @JsonSetter(value="custom_plan_config", nulls=Nulls.SKIP)
        public _FinalStage customPlanConfig(Optional<CustomPlanConfig> customPlanConfig) {
            this.customPlanConfig = customPlanConfig;
            return this;
        }

        @Override
        public _FinalStage addAllCompatiblePlanIds(List<String> compatiblePlanIds) {
            if (compatiblePlanIds != null) {
                this.compatiblePlanIds.addAll(compatiblePlanIds);
            }
            return this;
        }

        @Override
        public _FinalStage addCompatiblePlanIds(String compatiblePlanIds) {
            this.compatiblePlanIds.add(compatiblePlanIds);
            return this;
        }

        @Override
        @JsonSetter(value="compatible_plan_ids", nulls=Nulls.SKIP)
        public _FinalStage compatiblePlanIds(List<String> compatiblePlanIds) {
            this.compatiblePlanIds.clear();
            if (compatiblePlanIds != null) {
                this.compatiblePlanIds.addAll(compatiblePlanIds);
            }
            return this;
        }

        @Override
        public _FinalStage billingProduct(BillingProductDetailResponseData billingProduct) {
            this.billingProduct = Optional.ofNullable(billingProduct);
            return this;
        }

        @Override
        @JsonSetter(value="billing_product", nulls=Nulls.SKIP)
        public _FinalStage billingProduct(Optional<BillingProductDetailResponseData> billingProduct) {
            this.billingProduct = billingProduct;
            return this;
        }

        @Override
        public _FinalStage audienceType(String audienceType) {
            this.audienceType = Optional.ofNullable(audienceType);
            return this;
        }

        @Override
        @JsonSetter(value="audience_type", nulls=Nulls.SKIP)
        public _FinalStage audienceType(Optional<String> audienceType) {
            this.audienceType = audienceType;
            return this;
        }

        @Override
        public CompanyPlanDetailResponseData build() {
            return new CompanyPlanDetailResponseData(this.audienceType, this.billingProduct, this.chargeType, this.companyCanTrial, this.companyCount, this.compatiblePlanIds, this.controlledBy, this.createdAt, this.current, this.custom, this.customPlanConfig, this.description, this.entitlements, this.features, this.icon, this.id, this.includedCreditGrants, this.isCustom, this.isDefault, this.isFree, this.isTrialable, this.monthlyPrice, this.name, this.oneTimePrice, this.planType, this.trialDays, this.updatedAt, this.usageViolations, this.valid, this.yearlyPrice, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CompanyPlanDetailResponseData build();

        public _FinalStage audienceType(Optional<String> var1);

        public _FinalStage audienceType(String var1);

        public _FinalStage billingProduct(Optional<BillingProductDetailResponseData> var1);

        public _FinalStage billingProduct(BillingProductDetailResponseData var1);

        public _FinalStage compatiblePlanIds(List<String> var1);

        public _FinalStage addCompatiblePlanIds(String var1);

        public _FinalStage addAllCompatiblePlanIds(List<String> var1);

        public _FinalStage customPlanConfig(Optional<CustomPlanConfig> var1);

        public _FinalStage customPlanConfig(CustomPlanConfig var1);

        public _FinalStage entitlements(List<PlanEntitlementResponseData> var1);

        public _FinalStage addEntitlements(PlanEntitlementResponseData var1);

        public _FinalStage addAllEntitlements(List<PlanEntitlementResponseData> var1);

        public _FinalStage features(List<FeatureDetailResponseData> var1);

        public _FinalStage addFeatures(FeatureDetailResponseData var1);

        public _FinalStage addAllFeatures(List<FeatureDetailResponseData> var1);

        public _FinalStage includedCreditGrants(List<PlanCreditGrantView> var1);

        public _FinalStage addIncludedCreditGrants(PlanCreditGrantView var1);

        public _FinalStage addAllIncludedCreditGrants(List<PlanCreditGrantView> var1);

        public _FinalStage monthlyPrice(Optional<BillingPriceResponseData> var1);

        public _FinalStage monthlyPrice(BillingPriceResponseData var1);

        public _FinalStage oneTimePrice(Optional<BillingPriceResponseData> var1);

        public _FinalStage oneTimePrice(BillingPriceResponseData var1);

        public _FinalStage trialDays(Optional<Integer> var1);

        public _FinalStage trialDays(Integer var1);

        public _FinalStage usageViolations(List<FeatureUsageResponseData> var1);

        public _FinalStage addUsageViolations(FeatureUsageResponseData var1);

        public _FinalStage addAllUsageViolations(List<FeatureUsageResponseData> var1);

        public _FinalStage yearlyPrice(Optional<BillingPriceResponseData> var1);

        public _FinalStage yearlyPrice(BillingPriceResponseData var1);
    }

    public static interface ValidStage {
        public _FinalStage valid(boolean var1);
    }

    public static interface UpdatedAtStage {
        public ValidStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface PlanTypeStage {
        public UpdatedAtStage planType(@NotNull String var1);
    }

    public static interface NameStage {
        public PlanTypeStage name(@NotNull String var1);
    }

    public static interface IsTrialableStage {
        public NameStage isTrialable(boolean var1);
    }

    public static interface IsFreeStage {
        public IsTrialableStage isFree(boolean var1);
    }

    public static interface IsDefaultStage {
        public IsFreeStage isDefault(boolean var1);
    }

    public static interface IsCustomStage {
        public IsDefaultStage isCustom(boolean var1);
    }

    public static interface IdStage {
        public IsCustomStage id(@NotNull String var1);
    }

    public static interface IconStage {
        public IdStage icon(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public IconStage description(@NotNull String var1);
    }

    public static interface CustomStage {
        public DescriptionStage custom(boolean var1);
    }

    public static interface CurrentStage {
        public CustomStage current(boolean var1);
    }

    public static interface CreatedAtStage {
        public CurrentStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface ControlledByStage {
        public CreatedAtStage controlledBy(@NotNull String var1);
    }

    public static interface CompanyCountStage {
        public ControlledByStage companyCount(int var1);
    }

    public static interface CompanyCanTrialStage {
        public CompanyCountStage companyCanTrial(boolean var1);
    }

    public static interface ChargeTypeStage {
        public CompanyCanTrialStage chargeType(@NotNull String var1);

        public Builder from(CompanyPlanDetailResponseData var1);
    }
}

