/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompatiblePlansResponseData {
    private final List<String> compatiblePlanIds;
    private final String sourcePlanId;
    private final Map<String, Object> additionalProperties;

    private CompatiblePlansResponseData(List<String> compatiblePlanIds, String sourcePlanId, Map<String, Object> additionalProperties) {
        this.compatiblePlanIds = compatiblePlanIds;
        this.sourcePlanId = sourcePlanId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="compatible_plan_ids")
    public List<String> getCompatiblePlanIds() {
        return this.compatiblePlanIds;
    }

    @JsonProperty(value="source_plan_id")
    public String getSourcePlanId() {
        return this.sourcePlanId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompatiblePlansResponseData && this.equalTo((CompatiblePlansResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompatiblePlansResponseData other) {
        return this.compatiblePlanIds.equals(other.compatiblePlanIds) && this.sourcePlanId.equals(other.sourcePlanId);
    }

    public int hashCode() {
        return Objects.hash(this.compatiblePlanIds, this.sourcePlanId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SourcePlanIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SourcePlanIdStage,
    _FinalStage {
        private String sourcePlanId;
        private List<String> compatiblePlanIds = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CompatiblePlansResponseData other) {
            this.compatiblePlanIds(other.getCompatiblePlanIds());
            this.sourcePlanId(other.getSourcePlanId());
            return this;
        }

        @Override
        @JsonSetter(value="source_plan_id")
        public _FinalStage sourcePlanId(@NotNull String sourcePlanId) {
            this.sourcePlanId = Objects.requireNonNull(sourcePlanId, "sourcePlanId must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllCompatiblePlanIds(List<String> compatiblePlanIds) {
            if (compatiblePlanIds != null) {
                this.compatiblePlanIds.addAll(compatiblePlanIds);
            }
            return this;
        }

        @Override
        public _FinalStage addCompatiblePlanIds(String compatiblePlanIds) {
            this.compatiblePlanIds.add(compatiblePlanIds);
            return this;
        }

        @Override
        @JsonSetter(value="compatible_plan_ids", nulls=Nulls.SKIP)
        public _FinalStage compatiblePlanIds(List<String> compatiblePlanIds) {
            this.compatiblePlanIds.clear();
            if (compatiblePlanIds != null) {
                this.compatiblePlanIds.addAll(compatiblePlanIds);
            }
            return this;
        }

        @Override
        public CompatiblePlansResponseData build() {
            return new CompatiblePlansResponseData(this.compatiblePlanIds, this.sourcePlanId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CompatiblePlansResponseData build();

        public _FinalStage compatiblePlanIds(List<String> var1);

        public _FinalStage addCompatiblePlanIds(String var1);

        public _FinalStage addAllCompatiblePlanIds(List<String> var1);
    }

    public static interface SourcePlanIdStage {
        public _FinalStage sourcePlanId(@NotNull String var1);

        public Builder from(CompatiblePlansResponseData var1);
    }
}

