/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ComponentCheckoutSettings {
    private final boolean collectAddress;
    private final boolean collectEmail;
    private final boolean collectPhone;
    private final boolean taxCollectionEnabled;
    private final Map<String, Object> additionalProperties;

    private ComponentCheckoutSettings(boolean collectAddress, boolean collectEmail, boolean collectPhone, boolean taxCollectionEnabled, Map<String, Object> additionalProperties) {
        this.collectAddress = collectAddress;
        this.collectEmail = collectEmail;
        this.collectPhone = collectPhone;
        this.taxCollectionEnabled = taxCollectionEnabled;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="collect_address")
    public boolean getCollectAddress() {
        return this.collectAddress;
    }

    @JsonProperty(value="collect_email")
    public boolean getCollectEmail() {
        return this.collectEmail;
    }

    @JsonProperty(value="collect_phone")
    public boolean getCollectPhone() {
        return this.collectPhone;
    }

    @JsonProperty(value="tax_collection_enabled")
    public boolean getTaxCollectionEnabled() {
        return this.taxCollectionEnabled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ComponentCheckoutSettings && this.equalTo((ComponentCheckoutSettings)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ComponentCheckoutSettings other) {
        return this.collectAddress == other.collectAddress && this.collectEmail == other.collectEmail && this.collectPhone == other.collectPhone && this.taxCollectionEnabled == other.taxCollectionEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.collectAddress, this.collectEmail, this.collectPhone, this.taxCollectionEnabled);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CollectAddressStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CollectAddressStage,
    CollectEmailStage,
    CollectPhoneStage,
    TaxCollectionEnabledStage,
    _FinalStage {
        private boolean collectAddress;
        private boolean collectEmail;
        private boolean collectPhone;
        private boolean taxCollectionEnabled;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ComponentCheckoutSettings other) {
            this.collectAddress(other.getCollectAddress());
            this.collectEmail(other.getCollectEmail());
            this.collectPhone(other.getCollectPhone());
            this.taxCollectionEnabled(other.getTaxCollectionEnabled());
            return this;
        }

        @Override
        @JsonSetter(value="collect_address")
        public CollectEmailStage collectAddress(boolean collectAddress) {
            this.collectAddress = collectAddress;
            return this;
        }

        @Override
        @JsonSetter(value="collect_email")
        public CollectPhoneStage collectEmail(boolean collectEmail) {
            this.collectEmail = collectEmail;
            return this;
        }

        @Override
        @JsonSetter(value="collect_phone")
        public TaxCollectionEnabledStage collectPhone(boolean collectPhone) {
            this.collectPhone = collectPhone;
            return this;
        }

        @Override
        @JsonSetter(value="tax_collection_enabled")
        public _FinalStage taxCollectionEnabled(boolean taxCollectionEnabled) {
            this.taxCollectionEnabled = taxCollectionEnabled;
            return this;
        }

        @Override
        public ComponentCheckoutSettings build() {
            return new ComponentCheckoutSettings(this.collectAddress, this.collectEmail, this.collectPhone, this.taxCollectionEnabled, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ComponentCheckoutSettings build();
    }

    public static interface TaxCollectionEnabledStage {
        public _FinalStage taxCollectionEnabled(boolean var1);
    }

    public static interface CollectPhoneStage {
        public TaxCollectionEnabledStage collectPhone(boolean var1);
    }

    public static interface CollectEmailStage {
        public CollectPhoneStage collectEmail(boolean var1);
    }

    public static interface CollectAddressStage {
        public CollectEmailStage collectAddress(boolean var1);

        public Builder from(ComponentCheckoutSettings var1);
    }
}

