/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingCreditBundleView;
import com.schematic.api.types.CompanyDetailResponseData;
import com.schematic.api.types.CompanyPlanDetailResponseData;
import com.schematic.api.types.CompanySubscriptionResponseData;
import com.schematic.api.types.CompatiblePlans;
import com.schematic.api.types.ComponentCapabilities;
import com.schematic.api.types.ComponentCheckoutSettings;
import com.schematic.api.types.ComponentResponseData;
import com.schematic.api.types.CreditCompanyGrantView;
import com.schematic.api.types.FeatureUsageDetailResponseData;
import com.schematic.api.types.InvoiceResponseData;
import com.schematic.api.types.PlanDetailResponseData;
import com.schematic.api.types.StripeEmbedInfo;
import com.schematic.api.types.UsageBasedEntitlementResponseData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ComponentPreviewResponseData {
    private final List<CompanyPlanDetailResponseData> activeAddOns;
    private final List<CompanyPlanDetailResponseData> activePlans;
    private final List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements;
    private final List<CompatiblePlans> addOnCompatibilities;
    private final Optional<ComponentCapabilities> capabilities;
    private final ComponentCheckoutSettings checkoutSettings;
    private final Optional<CompanyDetailResponseData> company;
    private final Optional<ComponentResponseData> component;
    private final List<BillingCreditBundleView> creditBundles;
    private final List<CreditCompanyGrantView> creditGrants;
    private final Optional<PlanDetailResponseData> defaultPlan;
    private final Optional<FeatureUsageDetailResponseData> featureUsage;
    private final List<InvoiceResponseData> invoices;
    private final Optional<PlanDetailResponseData> postTrialPlan;
    private final boolean showCredits;
    private final boolean showPeriodToggle;
    private final boolean showZeroPriceAsFree;
    private final Optional<StripeEmbedInfo> stripeEmbed;
    private final Optional<CompanySubscriptionResponseData> subscription;
    private final Optional<Boolean> trialPaymentMethodRequired;
    private final Optional<InvoiceResponseData> upcomingInvoice;
    private final Map<String, Object> additionalProperties;

    private ComponentPreviewResponseData(List<CompanyPlanDetailResponseData> activeAddOns, List<CompanyPlanDetailResponseData> activePlans, List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements, List<CompatiblePlans> addOnCompatibilities, Optional<ComponentCapabilities> capabilities, ComponentCheckoutSettings checkoutSettings, Optional<CompanyDetailResponseData> company, Optional<ComponentResponseData> component, List<BillingCreditBundleView> creditBundles, List<CreditCompanyGrantView> creditGrants, Optional<PlanDetailResponseData> defaultPlan, Optional<FeatureUsageDetailResponseData> featureUsage, List<InvoiceResponseData> invoices, Optional<PlanDetailResponseData> postTrialPlan, boolean showCredits, boolean showPeriodToggle, boolean showZeroPriceAsFree, Optional<StripeEmbedInfo> stripeEmbed, Optional<CompanySubscriptionResponseData> subscription, Optional<Boolean> trialPaymentMethodRequired, Optional<InvoiceResponseData> upcomingInvoice, Map<String, Object> additionalProperties) {
        this.activeAddOns = activeAddOns;
        this.activePlans = activePlans;
        this.activeUsageBasedEntitlements = activeUsageBasedEntitlements;
        this.addOnCompatibilities = addOnCompatibilities;
        this.capabilities = capabilities;
        this.checkoutSettings = checkoutSettings;
        this.company = company;
        this.component = component;
        this.creditBundles = creditBundles;
        this.creditGrants = creditGrants;
        this.defaultPlan = defaultPlan;
        this.featureUsage = featureUsage;
        this.invoices = invoices;
        this.postTrialPlan = postTrialPlan;
        this.showCredits = showCredits;
        this.showPeriodToggle = showPeriodToggle;
        this.showZeroPriceAsFree = showZeroPriceAsFree;
        this.stripeEmbed = stripeEmbed;
        this.subscription = subscription;
        this.trialPaymentMethodRequired = trialPaymentMethodRequired;
        this.upcomingInvoice = upcomingInvoice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="active_add_ons")
    public List<CompanyPlanDetailResponseData> getActiveAddOns() {
        return this.activeAddOns;
    }

    @JsonProperty(value="active_plans")
    public List<CompanyPlanDetailResponseData> getActivePlans() {
        return this.activePlans;
    }

    @JsonProperty(value="active_usage_based_entitlements")
    public List<UsageBasedEntitlementResponseData> getActiveUsageBasedEntitlements() {
        return this.activeUsageBasedEntitlements;
    }

    @JsonProperty(value="add_on_compatibilities")
    public List<CompatiblePlans> getAddOnCompatibilities() {
        return this.addOnCompatibilities;
    }

    @JsonProperty(value="capabilities")
    public Optional<ComponentCapabilities> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="checkout_settings")
    public ComponentCheckoutSettings getCheckoutSettings() {
        return this.checkoutSettings;
    }

    @JsonProperty(value="company")
    public Optional<CompanyDetailResponseData> getCompany() {
        return this.company;
    }

    @JsonProperty(value="component")
    public Optional<ComponentResponseData> getComponent() {
        return this.component;
    }

    @JsonProperty(value="credit_bundles")
    public List<BillingCreditBundleView> getCreditBundles() {
        return this.creditBundles;
    }

    @JsonProperty(value="credit_grants")
    public List<CreditCompanyGrantView> getCreditGrants() {
        return this.creditGrants;
    }

    @JsonProperty(value="default_plan")
    public Optional<PlanDetailResponseData> getDefaultPlan() {
        return this.defaultPlan;
    }

    @JsonProperty(value="feature_usage")
    public Optional<FeatureUsageDetailResponseData> getFeatureUsage() {
        return this.featureUsage;
    }

    @JsonProperty(value="invoices")
    public List<InvoiceResponseData> getInvoices() {
        return this.invoices;
    }

    @JsonProperty(value="post_trial_plan")
    public Optional<PlanDetailResponseData> getPostTrialPlan() {
        return this.postTrialPlan;
    }

    @JsonProperty(value="show_credits")
    public boolean getShowCredits() {
        return this.showCredits;
    }

    @JsonProperty(value="show_period_toggle")
    public boolean getShowPeriodToggle() {
        return this.showPeriodToggle;
    }

    @JsonProperty(value="show_zero_price_as_free")
    public boolean getShowZeroPriceAsFree() {
        return this.showZeroPriceAsFree;
    }

    @JsonProperty(value="stripe_embed")
    public Optional<StripeEmbedInfo> getStripeEmbed() {
        return this.stripeEmbed;
    }

    @JsonProperty(value="subscription")
    public Optional<CompanySubscriptionResponseData> getSubscription() {
        return this.subscription;
    }

    @JsonProperty(value="trial_payment_method_required")
    public Optional<Boolean> getTrialPaymentMethodRequired() {
        return this.trialPaymentMethodRequired;
    }

    @JsonProperty(value="upcoming_invoice")
    public Optional<InvoiceResponseData> getUpcomingInvoice() {
        return this.upcomingInvoice;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ComponentPreviewResponseData && this.equalTo((ComponentPreviewResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ComponentPreviewResponseData other) {
        return this.activeAddOns.equals(other.activeAddOns) && this.activePlans.equals(other.activePlans) && this.activeUsageBasedEntitlements.equals(other.activeUsageBasedEntitlements) && this.addOnCompatibilities.equals(other.addOnCompatibilities) && this.capabilities.equals(other.capabilities) && this.checkoutSettings.equals(other.checkoutSettings) && this.company.equals(other.company) && this.component.equals(other.component) && this.creditBundles.equals(other.creditBundles) && this.creditGrants.equals(other.creditGrants) && this.defaultPlan.equals(other.defaultPlan) && this.featureUsage.equals(other.featureUsage) && this.invoices.equals(other.invoices) && this.postTrialPlan.equals(other.postTrialPlan) && this.showCredits == other.showCredits && this.showPeriodToggle == other.showPeriodToggle && this.showZeroPriceAsFree == other.showZeroPriceAsFree && this.stripeEmbed.equals(other.stripeEmbed) && this.subscription.equals(other.subscription) && this.trialPaymentMethodRequired.equals(other.trialPaymentMethodRequired) && this.upcomingInvoice.equals(other.upcomingInvoice);
    }

    public int hashCode() {
        return Objects.hash(this.activeAddOns, this.activePlans, this.activeUsageBasedEntitlements, this.addOnCompatibilities, this.capabilities, this.checkoutSettings, this.company, this.component, this.creditBundles, this.creditGrants, this.defaultPlan, this.featureUsage, this.invoices, this.postTrialPlan, this.showCredits, this.showPeriodToggle, this.showZeroPriceAsFree, this.stripeEmbed, this.subscription, this.trialPaymentMethodRequired, this.upcomingInvoice);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CheckoutSettingsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CheckoutSettingsStage,
    ShowCreditsStage,
    ShowPeriodToggleStage,
    ShowZeroPriceAsFreeStage,
    _FinalStage {
        private ComponentCheckoutSettings checkoutSettings;
        private boolean showCredits;
        private boolean showPeriodToggle;
        private boolean showZeroPriceAsFree;
        private Optional<InvoiceResponseData> upcomingInvoice = Optional.empty();
        private Optional<Boolean> trialPaymentMethodRequired = Optional.empty();
        private Optional<CompanySubscriptionResponseData> subscription = Optional.empty();
        private Optional<StripeEmbedInfo> stripeEmbed = Optional.empty();
        private Optional<PlanDetailResponseData> postTrialPlan = Optional.empty();
        private List<InvoiceResponseData> invoices = new ArrayList<InvoiceResponseData>();
        private Optional<FeatureUsageDetailResponseData> featureUsage = Optional.empty();
        private Optional<PlanDetailResponseData> defaultPlan = Optional.empty();
        private List<CreditCompanyGrantView> creditGrants = new ArrayList<CreditCompanyGrantView>();
        private List<BillingCreditBundleView> creditBundles = new ArrayList<BillingCreditBundleView>();
        private Optional<ComponentResponseData> component = Optional.empty();
        private Optional<CompanyDetailResponseData> company = Optional.empty();
        private Optional<ComponentCapabilities> capabilities = Optional.empty();
        private List<CompatiblePlans> addOnCompatibilities = new ArrayList<CompatiblePlans>();
        private List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements = new ArrayList<UsageBasedEntitlementResponseData>();
        private List<CompanyPlanDetailResponseData> activePlans = new ArrayList<CompanyPlanDetailResponseData>();
        private List<CompanyPlanDetailResponseData> activeAddOns = new ArrayList<CompanyPlanDetailResponseData>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ComponentPreviewResponseData other) {
            this.activeAddOns(other.getActiveAddOns());
            this.activePlans(other.getActivePlans());
            this.activeUsageBasedEntitlements(other.getActiveUsageBasedEntitlements());
            this.addOnCompatibilities(other.getAddOnCompatibilities());
            this.capabilities(other.getCapabilities());
            this.checkoutSettings(other.getCheckoutSettings());
            this.company(other.getCompany());
            this.component(other.getComponent());
            this.creditBundles(other.getCreditBundles());
            this.creditGrants(other.getCreditGrants());
            this.defaultPlan(other.getDefaultPlan());
            this.featureUsage(other.getFeatureUsage());
            this.invoices(other.getInvoices());
            this.postTrialPlan(other.getPostTrialPlan());
            this.showCredits(other.getShowCredits());
            this.showPeriodToggle(other.getShowPeriodToggle());
            this.showZeroPriceAsFree(other.getShowZeroPriceAsFree());
            this.stripeEmbed(other.getStripeEmbed());
            this.subscription(other.getSubscription());
            this.trialPaymentMethodRequired(other.getTrialPaymentMethodRequired());
            this.upcomingInvoice(other.getUpcomingInvoice());
            return this;
        }

        @Override
        @JsonSetter(value="checkout_settings")
        public ShowCreditsStage checkoutSettings(@NotNull ComponentCheckoutSettings checkoutSettings) {
            this.checkoutSettings = Objects.requireNonNull(checkoutSettings, "checkoutSettings must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="show_credits")
        public ShowPeriodToggleStage showCredits(boolean showCredits) {
            this.showCredits = showCredits;
            return this;
        }

        @Override
        @JsonSetter(value="show_period_toggle")
        public ShowZeroPriceAsFreeStage showPeriodToggle(boolean showPeriodToggle) {
            this.showPeriodToggle = showPeriodToggle;
            return this;
        }

        @Override
        @JsonSetter(value="show_zero_price_as_free")
        public _FinalStage showZeroPriceAsFree(boolean showZeroPriceAsFree) {
            this.showZeroPriceAsFree = showZeroPriceAsFree;
            return this;
        }

        @Override
        public _FinalStage upcomingInvoice(InvoiceResponseData upcomingInvoice) {
            this.upcomingInvoice = Optional.ofNullable(upcomingInvoice);
            return this;
        }

        @Override
        @JsonSetter(value="upcoming_invoice", nulls=Nulls.SKIP)
        public _FinalStage upcomingInvoice(Optional<InvoiceResponseData> upcomingInvoice) {
            this.upcomingInvoice = upcomingInvoice;
            return this;
        }

        @Override
        public _FinalStage trialPaymentMethodRequired(Boolean trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = Optional.ofNullable(trialPaymentMethodRequired);
            return this;
        }

        @Override
        @JsonSetter(value="trial_payment_method_required", nulls=Nulls.SKIP)
        public _FinalStage trialPaymentMethodRequired(Optional<Boolean> trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = trialPaymentMethodRequired;
            return this;
        }

        @Override
        public _FinalStage subscription(CompanySubscriptionResponseData subscription) {
            this.subscription = Optional.ofNullable(subscription);
            return this;
        }

        @Override
        @JsonSetter(value="subscription", nulls=Nulls.SKIP)
        public _FinalStage subscription(Optional<CompanySubscriptionResponseData> subscription) {
            this.subscription = subscription;
            return this;
        }

        @Override
        public _FinalStage stripeEmbed(StripeEmbedInfo stripeEmbed) {
            this.stripeEmbed = Optional.ofNullable(stripeEmbed);
            return this;
        }

        @Override
        @JsonSetter(value="stripe_embed", nulls=Nulls.SKIP)
        public _FinalStage stripeEmbed(Optional<StripeEmbedInfo> stripeEmbed) {
            this.stripeEmbed = stripeEmbed;
            return this;
        }

        @Override
        public _FinalStage postTrialPlan(PlanDetailResponseData postTrialPlan) {
            this.postTrialPlan = Optional.ofNullable(postTrialPlan);
            return this;
        }

        @Override
        @JsonSetter(value="post_trial_plan", nulls=Nulls.SKIP)
        public _FinalStage postTrialPlan(Optional<PlanDetailResponseData> postTrialPlan) {
            this.postTrialPlan = postTrialPlan;
            return this;
        }

        @Override
        public _FinalStage addAllInvoices(List<InvoiceResponseData> invoices) {
            if (invoices != null) {
                this.invoices.addAll(invoices);
            }
            return this;
        }

        @Override
        public _FinalStage addInvoices(InvoiceResponseData invoices) {
            this.invoices.add(invoices);
            return this;
        }

        @Override
        @JsonSetter(value="invoices", nulls=Nulls.SKIP)
        public _FinalStage invoices(List<InvoiceResponseData> invoices) {
            this.invoices.clear();
            if (invoices != null) {
                this.invoices.addAll(invoices);
            }
            return this;
        }

        @Override
        public _FinalStage featureUsage(FeatureUsageDetailResponseData featureUsage) {
            this.featureUsage = Optional.ofNullable(featureUsage);
            return this;
        }

        @Override
        @JsonSetter(value="feature_usage", nulls=Nulls.SKIP)
        public _FinalStage featureUsage(Optional<FeatureUsageDetailResponseData> featureUsage) {
            this.featureUsage = featureUsage;
            return this;
        }

        @Override
        public _FinalStage defaultPlan(PlanDetailResponseData defaultPlan) {
            this.defaultPlan = Optional.ofNullable(defaultPlan);
            return this;
        }

        @Override
        @JsonSetter(value="default_plan", nulls=Nulls.SKIP)
        public _FinalStage defaultPlan(Optional<PlanDetailResponseData> defaultPlan) {
            this.defaultPlan = defaultPlan;
            return this;
        }

        @Override
        public _FinalStage addAllCreditGrants(List<CreditCompanyGrantView> creditGrants) {
            if (creditGrants != null) {
                this.creditGrants.addAll(creditGrants);
            }
            return this;
        }

        @Override
        public _FinalStage addCreditGrants(CreditCompanyGrantView creditGrants) {
            this.creditGrants.add(creditGrants);
            return this;
        }

        @Override
        @JsonSetter(value="credit_grants", nulls=Nulls.SKIP)
        public _FinalStage creditGrants(List<CreditCompanyGrantView> creditGrants) {
            this.creditGrants.clear();
            if (creditGrants != null) {
                this.creditGrants.addAll(creditGrants);
            }
            return this;
        }

        @Override
        public _FinalStage addAllCreditBundles(List<BillingCreditBundleView> creditBundles) {
            if (creditBundles != null) {
                this.creditBundles.addAll(creditBundles);
            }
            return this;
        }

        @Override
        public _FinalStage addCreditBundles(BillingCreditBundleView creditBundles) {
            this.creditBundles.add(creditBundles);
            return this;
        }

        @Override
        @JsonSetter(value="credit_bundles", nulls=Nulls.SKIP)
        public _FinalStage creditBundles(List<BillingCreditBundleView> creditBundles) {
            this.creditBundles.clear();
            if (creditBundles != null) {
                this.creditBundles.addAll(creditBundles);
            }
            return this;
        }

        @Override
        public _FinalStage component(ComponentResponseData component) {
            this.component = Optional.ofNullable(component);
            return this;
        }

        @Override
        @JsonSetter(value="component", nulls=Nulls.SKIP)
        public _FinalStage component(Optional<ComponentResponseData> component) {
            this.component = component;
            return this;
        }

        @Override
        public _FinalStage company(CompanyDetailResponseData company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @Override
        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public _FinalStage company(Optional<CompanyDetailResponseData> company) {
            this.company = company;
            return this;
        }

        @Override
        public _FinalStage capabilities(ComponentCapabilities capabilities) {
            this.capabilities = Optional.ofNullable(capabilities);
            return this;
        }

        @Override
        @JsonSetter(value="capabilities", nulls=Nulls.SKIP)
        public _FinalStage capabilities(Optional<ComponentCapabilities> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @Override
        public _FinalStage addAllAddOnCompatibilities(List<CompatiblePlans> addOnCompatibilities) {
            if (addOnCompatibilities != null) {
                this.addOnCompatibilities.addAll(addOnCompatibilities);
            }
            return this;
        }

        @Override
        public _FinalStage addAddOnCompatibilities(CompatiblePlans addOnCompatibilities) {
            this.addOnCompatibilities.add(addOnCompatibilities);
            return this;
        }

        @Override
        @JsonSetter(value="add_on_compatibilities", nulls=Nulls.SKIP)
        public _FinalStage addOnCompatibilities(List<CompatiblePlans> addOnCompatibilities) {
            this.addOnCompatibilities.clear();
            if (addOnCompatibilities != null) {
                this.addOnCompatibilities.addAll(addOnCompatibilities);
            }
            return this;
        }

        @Override
        public _FinalStage addAllActiveUsageBasedEntitlements(List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements) {
            if (activeUsageBasedEntitlements != null) {
                this.activeUsageBasedEntitlements.addAll(activeUsageBasedEntitlements);
            }
            return this;
        }

        @Override
        public _FinalStage addActiveUsageBasedEntitlements(UsageBasedEntitlementResponseData activeUsageBasedEntitlements) {
            this.activeUsageBasedEntitlements.add(activeUsageBasedEntitlements);
            return this;
        }

        @Override
        @JsonSetter(value="active_usage_based_entitlements", nulls=Nulls.SKIP)
        public _FinalStage activeUsageBasedEntitlements(List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements) {
            this.activeUsageBasedEntitlements.clear();
            if (activeUsageBasedEntitlements != null) {
                this.activeUsageBasedEntitlements.addAll(activeUsageBasedEntitlements);
            }
            return this;
        }

        @Override
        public _FinalStage addAllActivePlans(List<CompanyPlanDetailResponseData> activePlans) {
            if (activePlans != null) {
                this.activePlans.addAll(activePlans);
            }
            return this;
        }

        @Override
        public _FinalStage addActivePlans(CompanyPlanDetailResponseData activePlans) {
            this.activePlans.add(activePlans);
            return this;
        }

        @Override
        @JsonSetter(value="active_plans", nulls=Nulls.SKIP)
        public _FinalStage activePlans(List<CompanyPlanDetailResponseData> activePlans) {
            this.activePlans.clear();
            if (activePlans != null) {
                this.activePlans.addAll(activePlans);
            }
            return this;
        }

        @Override
        public _FinalStage addAllActiveAddOns(List<CompanyPlanDetailResponseData> activeAddOns) {
            if (activeAddOns != null) {
                this.activeAddOns.addAll(activeAddOns);
            }
            return this;
        }

        @Override
        public _FinalStage addActiveAddOns(CompanyPlanDetailResponseData activeAddOns) {
            this.activeAddOns.add(activeAddOns);
            return this;
        }

        @Override
        @JsonSetter(value="active_add_ons", nulls=Nulls.SKIP)
        public _FinalStage activeAddOns(List<CompanyPlanDetailResponseData> activeAddOns) {
            this.activeAddOns.clear();
            if (activeAddOns != null) {
                this.activeAddOns.addAll(activeAddOns);
            }
            return this;
        }

        @Override
        public ComponentPreviewResponseData build() {
            return new ComponentPreviewResponseData(this.activeAddOns, this.activePlans, this.activeUsageBasedEntitlements, this.addOnCompatibilities, this.capabilities, this.checkoutSettings, this.company, this.component, this.creditBundles, this.creditGrants, this.defaultPlan, this.featureUsage, this.invoices, this.postTrialPlan, this.showCredits, this.showPeriodToggle, this.showZeroPriceAsFree, this.stripeEmbed, this.subscription, this.trialPaymentMethodRequired, this.upcomingInvoice, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ComponentPreviewResponseData build();

        public _FinalStage activeAddOns(List<CompanyPlanDetailResponseData> var1);

        public _FinalStage addActiveAddOns(CompanyPlanDetailResponseData var1);

        public _FinalStage addAllActiveAddOns(List<CompanyPlanDetailResponseData> var1);

        public _FinalStage activePlans(List<CompanyPlanDetailResponseData> var1);

        public _FinalStage addActivePlans(CompanyPlanDetailResponseData var1);

        public _FinalStage addAllActivePlans(List<CompanyPlanDetailResponseData> var1);

        public _FinalStage activeUsageBasedEntitlements(List<UsageBasedEntitlementResponseData> var1);

        public _FinalStage addActiveUsageBasedEntitlements(UsageBasedEntitlementResponseData var1);

        public _FinalStage addAllActiveUsageBasedEntitlements(List<UsageBasedEntitlementResponseData> var1);

        public _FinalStage addOnCompatibilities(List<CompatiblePlans> var1);

        public _FinalStage addAddOnCompatibilities(CompatiblePlans var1);

        public _FinalStage addAllAddOnCompatibilities(List<CompatiblePlans> var1);

        public _FinalStage capabilities(Optional<ComponentCapabilities> var1);

        public _FinalStage capabilities(ComponentCapabilities var1);

        public _FinalStage company(Optional<CompanyDetailResponseData> var1);

        public _FinalStage company(CompanyDetailResponseData var1);

        public _FinalStage component(Optional<ComponentResponseData> var1);

        public _FinalStage component(ComponentResponseData var1);

        public _FinalStage creditBundles(List<BillingCreditBundleView> var1);

        public _FinalStage addCreditBundles(BillingCreditBundleView var1);

        public _FinalStage addAllCreditBundles(List<BillingCreditBundleView> var1);

        public _FinalStage creditGrants(List<CreditCompanyGrantView> var1);

        public _FinalStage addCreditGrants(CreditCompanyGrantView var1);

        public _FinalStage addAllCreditGrants(List<CreditCompanyGrantView> var1);

        public _FinalStage defaultPlan(Optional<PlanDetailResponseData> var1);

        public _FinalStage defaultPlan(PlanDetailResponseData var1);

        public _FinalStage featureUsage(Optional<FeatureUsageDetailResponseData> var1);

        public _FinalStage featureUsage(FeatureUsageDetailResponseData var1);

        public _FinalStage invoices(List<InvoiceResponseData> var1);

        public _FinalStage addInvoices(InvoiceResponseData var1);

        public _FinalStage addAllInvoices(List<InvoiceResponseData> var1);

        public _FinalStage postTrialPlan(Optional<PlanDetailResponseData> var1);

        public _FinalStage postTrialPlan(PlanDetailResponseData var1);

        public _FinalStage stripeEmbed(Optional<StripeEmbedInfo> var1);

        public _FinalStage stripeEmbed(StripeEmbedInfo var1);

        public _FinalStage subscription(Optional<CompanySubscriptionResponseData> var1);

        public _FinalStage subscription(CompanySubscriptionResponseData var1);

        public _FinalStage trialPaymentMethodRequired(Optional<Boolean> var1);

        public _FinalStage trialPaymentMethodRequired(Boolean var1);

        public _FinalStage upcomingInvoice(Optional<InvoiceResponseData> var1);

        public _FinalStage upcomingInvoice(InvoiceResponseData var1);
    }

    public static interface ShowZeroPriceAsFreeStage {
        public _FinalStage showZeroPriceAsFree(boolean var1);
    }

    public static interface ShowPeriodToggleStage {
        public ShowZeroPriceAsFreeStage showPeriodToggle(boolean var1);
    }

    public static interface ShowCreditsStage {
        public ShowPeriodToggleStage showCredits(boolean var1);
    }

    public static interface CheckoutSettingsStage {
        public ShowCreditsStage checkoutSettings(@NotNull ComponentCheckoutSettings var1);

        public Builder from(ComponentPreviewResponseData var1);
    }
}

